/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class NamespaceDeclaration
extends Statement {
    private NamespaceName name;
    private Block body;
    private boolean bracketed = true;

    public NamespaceDeclaration(int start, int end, NamespaceName name, Block body, boolean bracketed) {
        super(start, end);
        if (!bracketed && name == null) {
            throw new IllegalArgumentException("Not bracketed statement must contain namespace name");
        }
        this.bracketed = bracketed;
        if (body == null) {
            body = new Block(end, end, new ArrayList<Statement>());
        }
        this.name = name;
        this.body = body;
    }

    public boolean isBracketed() {
        return this.bracketed;
    }

    public void addStatement(Statement statement) {
        this.body.getStatements().add(statement);
        int statementEnd = statement.getEndOffset();
        int bodyStart = this.body.getStartOffset();
        this.body.setSourceRange(bodyStart, statementEnd);
        int namespaceStart = this.getStartOffset();
        this.setSourceRange(namespaceStart, statementEnd);
    }

    public Block getBody() {
        return this.body;
    }

    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return String.valueOf(this.getName()) + String.valueOf(this.getBody());
    }
}

