/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class ArrowFunctionDeclaration
extends Expression
implements Attributed {
    private final boolean isReference;
    private final boolean isStatic;
    private final List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
    @NullAllowed
    private final Expression returnType;
    private final Expression expression;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public ArrowFunctionDeclaration(int start, int end, List formalParameters, Expression returnType, Expression expression, boolean isReference, boolean isStatic) {
        this(start, end, formalParameters, returnType, expression, isReference, isStatic, Collections.emptyList());
    }

    private ArrowFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, Expression returnType, Expression expression, boolean isReference, boolean isStatic, List<Attribute> attributes) {
        super(start, end);
        if (formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.attributes.addAll(attributes);
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.formalParameters.addAll(formalParameters);
        this.returnType = returnType;
        this.expression = expression;
    }

    public static ArrowFunctionDeclaration create(ArrowFunctionDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new ArrowFunctionDeclaration(start, declaration.getEndOffset(), declaration.getFormalParameters(), declaration.getReturnType(), declaration.getExpression(), declaration.isReference(), declaration.isStatic(), attributes);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<FormalParameter> getFormalParameters() {
        return Collections.unmodifiableList(this.formalParameters);
    }

    @CheckForNull
    public Expression getReturnType() {
        return this.returnType;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sbParams = new StringBuilder();
        this.getFormalParameters().forEach(param -> sbParams.append(param).append(","));
        return sbAttributes.toString() + (this.isStatic() ? "static " : " ") + "fn" + (this.isReference() ? " & " : "") + "(" + sbParams.toString() + ")" + (String)(this.getReturnType() != null ? ": " + String.valueOf(this.getReturnType()) : "") + " => " + String.valueOf(this.getExpression());
    }
}

