/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;

public class ClassDeclarationInfo
extends ASTNodeInfo<ClassDeclaration> {
    ClassDeclarationInfo(ClassDeclaration node) {
        super(node);
    }

    public static ClassDeclarationInfo create(ClassDeclaration classDeclaration) {
        return new ClassDeclarationInfo(classDeclaration);
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.CLASS;
    }

    @Override
    public String getName() {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.getOriginalNode();
        return classDeclaration.getName().getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create(((ClassDeclaration)this.getOriginalNode()).getName());
    }

    @Override
    public OffsetRange getRange() {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.getOriginalNode();
        Identifier name = classDeclaration.getName();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public Expression getSuperClass() {
        return ((ClassDeclaration)this.getOriginalNode()).getSuperClass() != null ? ((ClassDeclaration)this.getOriginalNode()).getSuperClass() : null;
    }

    public QualifiedName getSuperClassName() {
        Expression superClass = this.getSuperClass();
        return superClass != null ? QualifiedName.create(superClass) : null;
    }

    public List<? extends Expression> getInterfaces() {
        return ((ClassDeclaration)this.getOriginalNode()).getInterfaces();
    }

    public Set<QualifiedName> getInterfaceNames() {
        HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
        List<Expression> interfaes = ((ClassDeclaration)this.getOriginalNode()).getInterfaces();
        for (Expression iface : interfaes) {
            QualifiedName ifaceName = QualifiedName.create(iface);
            if (ifaceName == null) continue;
            retval.add(ifaceName);
        }
        return retval;
    }

    public PhpModifiers getAccessModifiers() {
        ArrayList<Integer> phpModifiers = new ArrayList<Integer>(((ClassDeclaration)this.getOriginalNode()).getModifiers().keySet().size());
        phpModifiers.add(1);
        block6: for (ClassDeclaration.Modifier modifier : ((ClassDeclaration)this.getOriginalNode()).getModifiers().keySet()) {
            switch (modifier) {
                case ABSTRACT: {
                    phpModifiers.add(1024);
                    continue block6;
                }
                case FINAL: {
                    phpModifiers.add(16);
                    continue block6;
                }
                case READONLY: {
                    phpModifiers.add(64);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
            }
            assert (false) : "Handle " + String.valueOf((Object)modifier) + " modifier";
        }
        return PhpModifiers.fromBitMask(phpModifiers.stream().mapToInt(i -> i).toArray());
    }

    public Collection<QualifiedName> getUsedTraits() {
        ASTNodeInfo.UsedTraitsVisitor visitor = new ASTNodeInfo.UsedTraitsVisitor();
        ((ClassDeclaration)this.getOriginalNode()).getBody().accept(visitor);
        return visitor.getUsedTraits();
    }

    public List<Attribute> getAttributes() {
        return ((ClassDeclaration)this.getOriginalNode()).getAttributes();
    }
}

