/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.execute;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.spi.debug.GradleJavaDebugger;
import org.netbeans.modules.gradle.spi.actions.AfterBuildActionHook;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.web.browser.spi.URLDisplayerImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DeployHook
implements AfterBuildActionHook {
    private static final Logger LOGGER = Logger.getLogger(DeployHook.class.getName());
    final Project project;

    public DeployHook(Project project) {
        this.project = project;
    }

    public void afterAction(String action, Lookup context, int result, PrintWriter out) {
        if ("run".equals(action) && result == 0) {
            this.deploy(out, Deployment.Mode.RUN);
        }
        if ("debug".equals(action) && result == 0) {
            this.deploy(out, Deployment.Mode.DEBUG);
        }
    }

    private void deploy(PrintWriter out, Deployment.Mode mode) {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        Callable<Void> debuggerHook = null;
        if (mode == Deployment.Mode.DEBUG) {
            debuggerHook = () -> {
                ServerDebugInfo sdi = jmp.getServerDebugInfo();
                if (sdi != null) {
                    String h = sdi.getHost();
                    String transport = sdi.getTransport();
                    String address = transport.equals("dt_shmem") ? sdi.getShmemName() : Integer.toString(sdi.getPort());
                    GradleJavaDebugger deb = (GradleJavaDebugger)this.project.getLookup().lookup(GradleJavaDebugger.class);
                    try {
                        deb.attachDebugger("Debug Deployed app", transport, h, address);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Exception occured while trying to attach debugger", ex);
                    }
                }
                return null;
            };
        }
        try {
            String showPage = this.showBrowserOnRun();
            String browserUrl = Deployment.getDefault().deploy(jmp, mode, null, showPage == null ? "" : showPage, true, message -> out.println(message), debuggerHook);
            if (browserUrl != null) {
                URL url = new URL(browserUrl);
                if (showPage != null) {
                    URLDisplayerImplementation urlDisplayer = (URLDisplayerImplementation)this.project.getLookup().lookup(URLDisplayerImplementation.class);
                    if (urlDisplayer != null) {
                        URL appRoot = url;
                        if (showPage.length() > 0 && browserUrl.endsWith(showPage)) {
                            appRoot = new URL(browserUrl.substring(0, browserUrl.length() - showPage.length()));
                        }
                        urlDisplayer.showURL(appRoot, url, this.project.getProjectDirectory());
                    } else {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                    }
                }
            }
        }
        catch (IOException | Deployment.DeploymentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String showBrowserOnRun() {
        Preferences prefs = NbGradleProject.getPreferences((Project)this.project, (boolean)false);
        if (prefs.getBoolean("netbeans.deploy.show", true)) {
            return prefs.get("netbeans.deploy.show.page", "");
        }
        return null;
    }
}

