/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.lsp.ResourceModificationException;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.project.dependency.impl.TextDocumentEditProcessor;
import org.netbeans.spi.lsp.ApplyEditsImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Union2;

public class DefaultApplyEditsImplementation
implements ApplyEditsImplementation {
    public CompletableFuture<List<String>> applyChanges(List<WorkspaceEdit> edits, boolean saveResources) {
        Worker wk = new Worker(edits, saveResources);
        try {
            wk.execute();
            return CompletableFuture.completedFuture(wk.getProcessedResources());
        }
        catch (ResourceModificationException ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    static class Worker {
        final boolean doSave;
        final List<WorkspaceEdit> edits;
        final List<WorkspaceEdit> completed = new ArrayList<WorkspaceEdit>();
        final Set<String> saved = new LinkedHashSet<String>();
        final Set<String> processed = new LinkedHashSet<String>();
        WorkspaceEdit currentEdit;
        int currentIndex = -1;

        public Worker(List<WorkspaceEdit> edits, boolean doSave) {
            this.edits = edits;
            this.doSave = doSave;
        }

        public List<String> getProcessedResources() {
            return new ArrayList<String>(this.processed);
        }

        void applyChangeToFile(TextDocumentEdit tde) throws ResourceModificationException {
            TextDocumentEditProcessor proc = new TextDocumentEditProcessor(tde).setSaveAfterEdit(this.doSave);
            try {
                proc.execute();
            }
            catch (IOException ex) {
                throw new ResourceModificationException(this.completed, this.currentEdit, this.currentIndex, proc.getFailedOperationIndex(), this.saved, ex.getMessage(), (Throwable)ex);
            }
        }

        void applyResourceOperation(ResourceOperation ro) throws IOException {
            if (!(ro instanceof ResourceOperation.CreateFile)) {
                throw new UnsupportedOperationException(ro.getClass().getName());
            }
            this.applyCreateOperation((ResourceOperation.CreateFile)ro);
        }

        void applyCreateOperation(ResourceOperation.CreateFile cf) throws IOException {
            Path filePath;
            try {
                URI u = URI.create(cf.getNewFile());
                filePath = Paths.get(u);
            }
            catch (FileSystemNotFoundException ex) {
                IOException e = new IOException("Invalid resource specification");
                e.initCause(ex);
                throw e;
            }
            catch (IllegalArgumentException ex) {
                String filename = cf.getNewFile();
                try {
                    filePath = Paths.get(filename, new String[0]);
                }
                catch (IllegalArgumentException ex2) {
                    IOException e = new IOException("Invalid resource specification");
                    e.initCause(ex2);
                    throw e;
                }
            }
            if (Files.exists(filePath, new LinkOption[0])) {
                throw new FileAlreadyExistsException(filePath.toString());
            }
            Path parent = filePath;
            while ((parent = parent.getParent()) != null && !Files.exists(parent, new LinkOption[0])) {
            }
            if (parent == null) {
                throw new IOException("Cannot create file with no existing parent: " + String.valueOf(filePath));
            }
            FileObject parentFile = URLMapper.findFileObject((URL)parent.toUri().toURL());
            String relativePath = parent.relativize(filePath).toString();
            FileUtil.createData((FileObject)parentFile, (String)relativePath);
            this.processed.add(cf.getNewFile());
        }

        public void execute() throws ResourceModificationException {
            Iterator<WorkspaceEdit> iterator = this.edits.iterator();
            while (iterator.hasNext()) {
                WorkspaceEdit e;
                this.currentEdit = e = iterator.next();
                this.currentIndex = 0;
                for (Union2 ch : this.currentEdit.getDocumentChanges()) {
                    if (ch.hasFirst()) {
                        TextDocumentEdit te = (TextDocumentEdit)ch.first();
                        this.applyChangeToFile(te);
                        if (this.doSave) {
                            this.saved.add(te.getDocument());
                        }
                        this.processed.add(te.getDocument());
                    } else if (ch.hasSecond()) {
                        try {
                            this.applyResourceOperation((ResourceOperation)ch.second());
                        }
                        catch (IOException ex) {
                            throw new ResourceModificationException(this.completed, this.currentEdit, this.currentIndex, -2, this.saved, ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++this.currentIndex;
                }
            }
        }
    }
}

