/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.util.WeakSet;

public final class MutualExclusionSupport<K> {
    private static final int TRIES = Integer.getInteger("org.netbeans.modules.masterfs.mutualexclusion.tries", 10);
    private final Map<K, Set<Closeable>> exclusive = Collections.synchronizedMap(new WeakHashMap());
    private final Map<K, Set<Closeable>> shared = Collections.synchronizedMap(new WeakHashMap());

    public synchronized Closeable addResource(K key, boolean isShared) throws IOException {
        boolean isInUse = true;
        Map<K, Set<Closeable>> unexpected = isShared ? this.exclusive : this.shared;
        Map<K, Set<Closeable>> expected = isShared ? this.shared : this.exclusive;
        Set<Closeable> unexpectedCounter = unexpected.get(key);
        WeakSet expectedCounter = expected.get(key);
        for (int i = 0; i < TRIES && isInUse; ++i) {
            boolean bl = isInUse = unexpectedCounter != null && unexpectedCounter.size() > 0;
            if (!isInUse) {
                if (expectedCounter == null) {
                    expectedCounter = new WeakSet();
                    expected.put(key, (Set<Closeable>)expectedCounter);
                }
                boolean bl2 = isInUse = !isShared && expectedCounter.size() > 0;
            }
            if (!isInUse) continue;
            try {
                this.wait(200L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (isInUse) {
            try {
                FSException.io(isShared ? "EXC_CannotGetSharedAccess" : "EXC_CannotGetExclusiveAccess", key.toString());
            }
            catch (IOException x) {
                assert (this.addStack(x, unexpectedCounter, (Set<Closeable>)expectedCounter));
                throw x;
            }
        }
        Closeable retVal = new Closeable(key, isShared);
        expectedCounter.add((Closeable)retVal);
        return retVal;
    }

    private boolean addStack(IOException x, Set<Closeable> unexpectedCounter, Set<Closeable> expectedCounter) {
        try {
            this.addStack(x, unexpectedCounter);
            this.addStack(x, expectedCounter);
        }
        catch (IllegalArgumentException e) {
            Logger log = Logger.getLogger(MutualExclusionSupport.class.getName());
            String unexpectedStr = unexpectedCounter == null ? "null" : Arrays.toString(unexpectedCounter.toArray());
            String expectedStr = expectedCounter == null ? "null" : Arrays.toString(expectedCounter.toArray());
            log.log(Level.WARNING, "Cannot add stack to exception: unexpectedCounter: {0}, expectedCounter: {1}", new Object[]{unexpectedStr, expectedStr});
            log.log(Level.INFO, null, e);
            log.log(Level.INFO, "Exception x", x);
        }
        return true;
    }

    private void addStack(IOException x, Set<Closeable> cs) {
        if (cs != null) {
            for (Closeable c : cs) {
                Throwable stack = c.stack;
                if (stack == null) continue;
                Throwable t = x;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                t.initCause(stack);
            }
        }
    }

    private synchronized void removeResource(K key, Closeable value, boolean isShared) {
        Map<K, Set<Closeable>> expected = isShared ? this.shared : this.exclusive;
        Set<Closeable> expectedCounter = expected.get(key);
        if (expectedCounter != null) {
            expectedCounter.remove(value);
        }
    }

    synchronized boolean isBeingWritten(K file) {
        Set<Closeable> counter = this.exclusive.get(file);
        return counter != null && !counter.isEmpty();
    }

    public final class Closeable {
        private final boolean isShared;
        private final Reference<K> keyRef;
        private boolean isClosed = false;
        Throwable stack;

        private Closeable(K key, boolean isShared) {
            this.isShared = isShared;
            this.keyRef = new WeakReference(key);
            assert (this.populateStack());
        }

        private boolean populateStack() {
            this.stack = new Throwable("opened stream here");
            return true;
        }

        public void close() {
            if (!this.isClosed()) {
                this.isClosed = true;
                Object key = this.keyRef.get();
                if (key != null) {
                    MutualExclusionSupport.this.removeResource(key, this, this.isShared);
                }
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

