/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RenamePropertyRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class RenameTransformer
extends RefactoringVisitor {
    private final Set<ElementHandle<ExecutableElement>> allMethods;
    private final Set<TreePathHandle> recordLinkedDeclarations;
    private final TreePathHandle handle;
    private final DocTreePathHandle docHandle;
    private final String newName;
    private final boolean renameInComments;
    private final RenameRefactoring refactoring;
    private Iterable<? extends Element> shadowed;
    private Map<ImportTree, ImportTree> imports;
    private List<ImportTree> newImports;

    public RenameTransformer(TreePathHandle handle, DocTreePathHandle docHandle, RenameRefactoring refactoring, Set<ElementHandle<ExecutableElement>> am, Set<TreePathHandle> recordLinkedDeclarations, boolean renameInComments) {
        super(true);
        this.handle = handle;
        this.docHandle = docHandle;
        this.refactoring = refactoring;
        this.newName = refactoring.getNewName();
        this.allMethods = am;
        this.recordLinkedDeclarations = recordLinkedDeclarations;
        this.renameInComments = renameInComments;
    }

    @Override
    public Tree scan(Tree tree, Element p) {
        if (p == null && this.handle == null) {
            p = this.docHandle != null ? ((DocTrees)this.workingCopy.getTrees()).getElement(this.docHandle.resolve((CompilationInfo)this.workingCopy)) : this.handle.resolveElement((CompilationInfo)this.workingCopy);
        }
        return super.scan(tree, p);
    }

    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        genUtils.importComments((Tree)node, node);
        if (this.renameInComments) {
            if (p.getKind() == ElementKind.PARAMETER) {
                this.renameParameterInMethodComments(p);
            } else {
                String originalName = this.getOldSimpleName(p);
                if (originalName != null) {
                    TokenSequence ts = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    while (ts.moveNext()) {
                        Token t = ts.token();
                        if (!this.isComment((Token<JavaTokenId>)t)) continue;
                        this.rewriteAllInComment(t.text().toString(), ts.offset(), originalName);
                    }
                }
            }
        }
        this.imports = new HashMap<ImportTree, ImportTree>();
        this.newImports = new LinkedList<ImportTree>();
        Tree value = (Tree)super.visitCompilationUnit(node, (Object)p);
        if (!this.imports.isEmpty() || !this.newImports.isEmpty()) {
            CompilationUnitTree newNode = node;
            for (Map.Entry<ImportTree, ImportTree> entry : this.imports.entrySet()) {
                newNode = this.make.removeCompUnitImport(newNode, entry.getKey());
                newNode = this.make.addCompUnitImport(newNode, entry.getValue());
            }
            for (ImportTree newImport : this.newImports) {
                newNode = this.make.addCompUnitImport(newNode, newImport);
            }
            this.rewrite(node, newNode);
        }
        return value;
    }

    public Tree visitIdentifier(com.sun.source.tree.IdentifierTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        this.renameShadowIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, (Object)p);
    }

    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, (Object)p);
    }

    public Tree visitMemberReference(MemberReferenceTree node, Element p) {
        this.renameUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberReference(node, (Object)p);
    }

    public Tree visitLabeledStatement(LabeledStatementTree tree, Element p) {
        if (this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT && tree == this.handle.resolve((CompilationInfo)this.workingCopy).getLeaf()) {
            LabeledStatementTree newTree = this.make.LabeledStatement((CharSequence)this.newName, tree.getStatement());
            this.rewrite(tree, newTree);
        }
        return (Tree)super.visitLabeledStatement(tree, (Object)p);
    }

    public Tree visitContinue(ContinueTree tree, Element p) {
        StatementTree target;
        if (this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT && (target = this.workingCopy.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath())) == this.handle.resolve((CompilationInfo)this.workingCopy).getLeaf()) {
            ContinueTree newTree = this.make.Continue((CharSequence)this.newName);
            this.rewrite(tree, newTree);
        }
        return (Tree)super.visitContinue(tree, (Object)p);
    }

    public Tree visitBreak(BreakTree tree, Element p) {
        Tree target;
        if (this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT && (target = this.workingCopy.getTreeUtilities().getBreakContinueTargetTree(this.getCurrentPath())) == this.handle.resolve((CompilationInfo)this.workingCopy).getLeaf()) {
            BreakTree newTree = this.make.Break((CharSequence)this.newName);
            this.rewrite(tree, newTree);
        }
        return (Tree)super.visitBreak(tree, (Object)p);
    }

    private String getOldSimpleName(Element p) {
        if (p != null) {
            return p.getSimpleName().toString();
        }
        for (ElementHandle<ExecutableElement> mh : this.allMethods) {
            ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
            if (baseMethod == null) continue;
            return baseMethod.getSimpleName().toString();
        }
        return null;
    }

    private void renameUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, path) || this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT) {
            return;
        }
        this.doRenameUsageIfMatch(this.getCurrentPath(), tree, elementToFind);
        for (TreePathHandle h : this.recordLinkedDeclarations) {
            Element linked = h.resolveElement((CompilationInfo)this.workingCopy);
            if (linked == null) continue;
            this.doRenameUsageIfMatch(this.getCurrentPath(), tree, linked);
        }
    }

    private void doRenameUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        TreePath elementPath = path;
        Trees trees = this.workingCopy.getTrees();
        Element el = this.workingCopy.getTrees().getElement(elementPath);
        if (el == null) {
            if ((elementPath = elementPath.getParentPath()) != null && elementPath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)elementPath.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id == null || id.contentEquals("*") || !id.contentEquals(elementToFind.getSimpleName())) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                elementPath = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(elementPath);
                if (el == null) {
                    return;
                }
                Iterator iterator = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){
                    final /* synthetic */ RenameTransformer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public boolean accept(Element e, TypeMirror type) {
                        return id.equals(e.getSimpleName());
                    }
                }).iterator();
                if (iterator.hasNext()) {
                    el = (Element)iterator.next();
                    if (iterator.hasNext()) {
                        if (el.equals(elementToFind) || this.isMethodMatch(el)) {
                            this.newImports.add(this.make.Import((Tree)this.make.QualIdent((Element)iterator.next()), true));
                        } else {
                            this.newImports.add(this.make.Import((Tree)this.make.QualIdent(el), true));
                            do {
                                el = (Element)iterator.next();
                            } while (iterator.hasNext() && el != null && !el.equals(elementToFind) && !this.isMethodMatch(el));
                            if (el == null) {
                                return;
                            }
                        }
                    }
                }
            } else {
                return;
            }
        }
        if (el.equals(elementToFind) || this.isMethodMatch(el)) {
            Types types;
            Scope scope;
            Object useThis = null;
            Object useSuper = null;
            if (elementToFind != null && elementToFind.getKind().isField() && tree.getKind() == Tree.Kind.IDENTIFIER) {
                scope = this.workingCopy.getTrees().getScope(elementPath);
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER || !element.getSimpleName().toString().equals(this.newName)) continue;
                    if (elementToFind.getModifiers().contains((Object)Modifier.STATIC)) {
                        useThis = elementToFind.getEnclosingElement().getSimpleName().toString() + ".";
                        break;
                    }
                    types = this.workingCopy.getTypes();
                    if (types.isSubtype(scope.getEnclosingClass().asType(), elementToFind.getEnclosingElement().asType())) {
                        useThis = "this.";
                        break;
                    }
                    useThis = String.valueOf(elementToFind.getEnclosingElement().getSimpleName()) + ".this.";
                    break;
                }
            }
            if (elementToFind != null && elementToFind.getKind().isField() || elementToFind.getKind() == ElementKind.METHOD) {
                scope = this.workingCopy.getTrees().getScope(elementPath);
                TypeElement enclosingTypeElement = scope.getEnclosingClass();
                TypeMirror typeMirror = enclosingTypeElement == null ? null : enclosingTypeElement.getSuperclass();
                types = this.workingCopy.getTypes();
                if (typeMirror != null && !types.isSameType(types.getNoType(TypeKind.NONE), typeMirror) && types.isSubtype(typeMirror, elementToFind.getEnclosingElement().asType())) {
                    ElementUtilities utils;
                    if (elementToFind.getKind().isField()) {
                        for (Element element : enclosingTypeElement.getEnclosedElements()) {
                            String isSuper;
                            if (!element.getKind().isField() || !element.getSimpleName().toString().equals(this.newName)) continue;
                            if (tree.getKind() != Tree.Kind.MEMBER_SELECT || !(isSuper = ((MemberSelectTree)tree).getExpression().toString()).equals("super") && !isSuper.endsWith(".super")) {
                                useSuper = types.isSubtype(enclosingTypeElement.asType(), elementToFind.getEnclosingElement().asType()) ? "super." : String.valueOf(elementToFind.getEnclosingElement().getSimpleName()) + ".super.";
                            }
                            break;
                        }
                    } else if (elementToFind.getKind() == ElementKind.METHOD && (utils = this.workingCopy.getElementUtilities()).alreadyDefinedIn((CharSequence)this.newName, (ExecutableType)elementToFind.asType(), enclosingTypeElement)) {
                        boolean bl;
                        String superString;
                        boolean bl2 = false;
                        if (tree.getKind() == Tree.Kind.MEMBER_SELECT && ((superString = ((MemberSelectTree)tree).getExpression().toString()).equals("super") || superString.endsWith(".super"))) {
                            bl = true;
                        }
                        if (!bl) {
                            useSuper = types.isSubtype(enclosingTypeElement.asType(), elementToFind.getEnclosingElement().asType()) ? "super." : String.valueOf(elementToFind.getEnclosingElement().getSimpleName()) + ".super.";
                        }
                    }
                }
            }
            Tree nju = null;
            if (useThis != null) {
                nju = this.make.setLabel(tree, (CharSequence)(useThis + this.newName));
            } else if (useSuper != null) {
                nju = this.make.setLabel(tree, (CharSequence)(useSuper + this.newName));
            } else if (elementToFind.getKind().isClass()) {
                boolean duplicate = this.duplicateDeclaration();
                TreePath treePath = path.getParentPath();
                if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                    ImportTree importTree = (ImportTree)treePath.getLeaf();
                    if (duplicate) {
                        nju = this.make.removeCompUnitImport(this.workingCopy.getCompilationUnit(), importTree);
                        tree = this.workingCopy.getCompilationUnit();
                    } else {
                        nju = this.make.setLabel(tree, (CharSequence)this.newName);
                    }
                } else {
                    nju = duplicate ? this.make.QualIdent(((ExpressionTree)this.make.setLabel((Tree)this.make.QualIdent(elementToFind), (CharSequence)this.newName)).toString()) : this.make.setLabel(tree, (CharSequence)this.newName);
                }
            } else {
                TreePath parentPath = path.getParentPath();
                if (parentPath != null && parentPath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                    ImportTree importTree = (ImportTree)parentPath.getLeaf();
                    this.imports.put(importTree, this.make.Import(this.make.setLabel(tree, (CharSequence)this.newName), importTree.isStatic()));
                } else {
                    nju = this.make.setLabel(tree, (CharSequence)this.newName);
                }
            }
            if (nju != null) {
                this.rewrite(tree, nju);
            }
        }
    }

    private void renameShadowIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.shadowed == null || JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, path) || this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT) {
            return;
        }
        TreePath elementPath = path;
        Element el = this.workingCopy.getTrees().getElement(elementPath);
        if (el == null) {
            return;
        }
        for (Element element : this.shadowed) {
            if (!element.equals(el)) continue;
            if (elementToFind.getModifiers().contains((Object)Modifier.STATIC)) {
                this.rewrite(tree, this.make.MemberSelect(this.make.QualIdent(el.getEnclosingElement()), element));
                break;
            }
            this.rewrite(tree, this.make.MemberSelect((ExpressionTree)this.make.MemberSelect(this.make.QualIdent(el.getEnclosingElement()), (CharSequence)"this"), element));
            break;
        }
    }

    public Tree visitMethod(MethodTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, (Object)p);
    }

    public Tree visitClass(ClassTree tree, final Element p) {
        Trees trees;
        TreePath pPath;
        TreePath currentPath = this.getCurrentPath();
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        Element el = this.workingCopy.getTrees().getElement(currentPath);
        if (el != null && el.getEnclosedElements().contains(p) && (pPath = (trees = this.workingCopy.getTrees()).getPath(p)) != null) {
            Scope scope = trees.getScope(pPath);
            this.shadowed = this.workingCopy.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){
                final /* synthetic */ RenameTransformer this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean accept(Element element, TypeMirror type) {
                    return !element.equals(p) && element.getKind() == p.getKind() && element.getSimpleName().contentEquals(this.this$0.newName);
                }
            });
        }
        Tree value = (Tree)super.visitClass(tree, (Object)p);
        this.shadowed = null;
        return value;
    }

    public Tree visitVariable(VariableTree tree, Element p) {
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitVariable(tree, (Object)p);
    }

    public Tree visitTypeParameter(TypeParameterTree arg0, Element arg1) {
        this.renameDeclIfMatch(this.getCurrentPath(), arg0, arg1);
        return (Tree)super.visitTypeParameter(arg0, (Object)arg1);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, path) || this.handle != null && this.handle.getKind() == Tree.Kind.LABELED_STATEMENT) {
            return;
        }
        this.doRenameDeclIfMatch(path, tree, elementToFind);
        for (TreePathHandle h : this.recordLinkedDeclarations) {
            Element linked = h.resolveElement((CompilationInfo)this.workingCopy);
            if (linked == null) continue;
            this.doRenameDeclIfMatch(this.getCurrentPath(), tree, linked);
        }
    }

    private void doRenameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        Element el = this.workingCopy.getTrees().getElement(path);
        if (el == null) {
            return;
        }
        if (el.equals(elementToFind) || this.isMethodMatch(el)) {
            Tree nju = this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, nju);
            return;
        }
    }

    private boolean isMethodMatch(Element method) {
        if (method.getKind() == ElementKind.METHOD && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("RenameTransformer cannot resolve " + String.valueOf(mh));
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DocTree visitReference(ReferenceTree node, Element elementToFind) {
        DocTreePath currentDocPath = this.getCurrentDocPath();
        DocTrees trees = this.workingCopy.getDocTrees();
        Element el = trees.getElement(currentDocPath);
        ExpressionTree classReference = this.workingCopy.getTreeUtilities().getReferenceClass(currentDocPath);
        if ((el == null || !el.equals(elementToFind) && !this.isMethodMatch(el)) && classReference != null) {
            el = trees.getElement(new TreePath(this.getCurrentPath(), classReference));
        }
        if (el != null && (el.equals(elementToFind) || this.isMethodMatch(el))) {
            Name memberName = this.workingCopy.getTreeUtilities().getReferenceName(currentDocPath);
            List methodParameters = this.workingCopy.getTreeUtilities().getReferenceParameters(currentDocPath);
            ReferenceTree newRef = el.getKind().isClass() || el.getKind().isInterface() ? this.make.Reference((ExpressionTree)this.make.setLabel((Tree)classReference, (CharSequence)this.newName), (CharSequence)memberName, methodParameters) : this.make.Reference(classReference, (CharSequence)this.newName, methodParameters);
            this.rewrite(currentDocPath.getTreePath().getLeaf(), node, newRef);
        }
        return super.visitReference(node, elementToFind);
    }

    @Override
    public DocTree visitText(TextTree node, Element p) {
        if (this.renameInComments && this.refactoring.getContext().lookup(RenamePropertyRefactoringPlugin.class) == null) {
            DocTreePath currentDocPath = this.getCurrentDocPath();
            if (p.getKind() == ElementKind.PARAMETER) {
                VariableElement var = (VariableElement)p;
                Element method = this.workingCopy.getTrees().getElement(currentDocPath.getTreePath());
                if (!var.getEnclosingElement().equals(method)) {
                    return super.visitText(node, p);
                }
            }
            String originalName = this.getOldSimpleName(p);
            if (node.getBody().contains(originalName)) {
                StringBuilder text = new StringBuilder(node.getBody());
                int index = text.indexOf(originalName);
                while (index != -1) {
                    if (!(index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1)) || index + originalName.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(index + originalName.length())))) {
                        text.delete(index, index + originalName.length());
                        text.insert(index, this.newName);
                    }
                    index = text.indexOf(originalName, index + 1);
                }
                if (!node.getBody().contentEquals(text)) {
                    TextTree newText = this.make.Text(text.toString());
                    this.rewrite(currentDocPath.getTreePath().getLeaf(), node, newText);
                }
            }
        }
        return super.visitText(node, p);
    }

    @Override
    public DocTree visitIdentifier(IdentifierTree node, Element elementToFind) {
        DocTreePath currentDocPath = this.getCurrentDocPath();
        DocTrees trees = this.workingCopy.getDocTrees();
        Element el = trees.getElement(currentDocPath);
        if (el != null && el.equals(elementToFind)) {
            IdentifierTree newIdent = this.make.DocIdentifier((CharSequence)this.newName);
            this.rewrite(currentDocPath.getTreePath().getLeaf(), node, newIdent);
        }
        return super.visitIdentifier(node, elementToFind);
    }

    private void renameParameterInMethodComments(Element parameter) {
        if (this.refactoring.getContext().lookup(RenamePropertyRefactoringPlugin.class) != null) {
            return;
        }
        Tree method = this.workingCopy.getTrees().getPath(parameter).getParentPath().getLeaf();
        String originalName = this.getOldSimpleName(parameter);
        int methodStart = (int)this.workingCopy.getTrees().getSourcePositions().getStartPosition(this.workingCopy.getCompilationUnit(), method);
        TokenSequence tokenSequence = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(methodStart);
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (this.isComment((Token<JavaTokenId>)token)) {
                this.rewriteAllInComment(token.text().toString(), tokenSequence.offset(), originalName);
                continue;
            }
            if (token.id() == JavaTokenId.WHITESPACE) continue;
            break;
        }
        int methodEnd = (int)this.workingCopy.getTrees().getSourcePositions().getEndPosition(this.workingCopy.getCompilationUnit(), method);
        tokenSequence.move(methodStart);
        while (tokenSequence.moveNext() && tokenSequence.offset() < methodEnd) {
            Token token = tokenSequence.token();
            if (!this.isComment((Token<JavaTokenId>)token)) continue;
            this.rewriteAllInComment(token.text().toString(), tokenSequence.offset(), originalName);
        }
    }

    private boolean isComment(Token<JavaTokenId> token) {
        switch ((JavaTokenId)token.id()) {
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private void rewriteAllInComment(String text, int offset, String originalName) {
        int index = text.indexOf(originalName);
        while (index != -1) {
            if (!(index > 0 && Character.isJavaIdentifierPart(text.charAt(index - 1)) || index + originalName.length() < text.length() && Character.isJavaIdentifierPart(text.charAt(index + originalName.length())) || text.charAt(index - 1) == '<' || text.charAt(index - 1) == '/')) {
                this.workingCopy.rewriteInComment(offset + index, originalName.length(), this.newName);
            }
            index = text.indexOf(originalName, index + 1);
        }
    }

    private boolean duplicateDeclaration() {
        ErrorAwareTreeScanner<Boolean, String> duplicateIds = new ErrorAwareTreeScanner<Boolean, String>(){

            public Boolean visitClass(ClassTree node, String p) {
                if (node.getSimpleName().contentEquals(p)) {
                    return Boolean.TRUE;
                }
                return (Boolean)super.visitClass(node, (Object)p);
            }

            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 != null ? r1 : r2;
            }
        };
        return Boolean.TRUE == duplicateIds.scan((Tree)this.workingCopy.getCompilationUnit(), (Object)this.newName);
    }
}

