/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.annotation;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationElementAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.QualifierAnalyzer;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class InterceptorBindingMembersAnalyzer
implements AnnotationElementAnalyzer.AnnotationAnalyzer {
    @Override
    public void analyze(TypeElement element, AtomicBoolean cancel, CdiAnalysisResult result) {
        if (AnnotationUtil.hasAnnotation((Element)element, result.getInfo(), "jakarta.interceptor.InterceptorBinding", "javax.interceptor.InterceptorBinding")) {
            this.checkMembers(element, result, NbBundle.getMessage(QualifierAnalyzer.class, (String)"WARN_ArrayAnnotationValuedIBindingMember"));
        }
    }

    protected void checkMembers(TypeElement element, CdiAnalysisResult result, String localizedWarning) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        for (ExecutableElement executableElement : methods) {
            TypeMirror returnType = executableElement.getReturnType();
            boolean warning = false;
            if (returnType.getKind() == TypeKind.ARRAY) {
                warning = true;
            } else if (returnType.getKind() == TypeKind.DECLARED) {
                Element returnElement = result.getInfo().getTypes().asElement(returnType);
                boolean bl = warning = returnElement.getKind() == ElementKind.ANNOTATION_TYPE;
            }
            if (!warning || AnnotationUtil.hasAnnotation((Element)executableElement, result.getInfo(), "jakarta.enterprise.util.Nonbinding", "javax.enterprise.util.Nonbinding")) continue;
            result.addNotification(Severity.WARNING, element, localizedWarning);
        }
    }
}

