/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.dashboard;

import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class WidgetElement {
    private WidgetElement() {
    }

    public static TextElement text(String text) {
        return new TextElement(TextElement.Kind.NORMAL, text);
    }

    public static TextElement aside(String text) {
        return new TextElement(TextElement.Kind.ASIDE, text);
    }

    public static TextElement unavailable(String text) {
        return new TextElement(TextElement.Kind.UNAVAILABLE, text);
    }

    public static TextElement subheading(String text) {
        return new TextElement(TextElement.Kind.SUBHEADING, text);
    }

    public static ImageElement image(String resourcePath) {
        return new ImageElement(resourcePath);
    }

    public static ActionElement action(Action action) {
        return new ActionElement(action, false, true);
    }

    public static ActionElement actionNoIcon(Action action) {
        return new ActionElement(action, false, false);
    }

    public static ActionElement actionLink(Action action) {
        return new ActionElement(action, true, true);
    }

    public static ActionElement actionLinkNoIcon(Action action) {
        return new ActionElement(action, true, false);
    }

    public static LinkElement link(String text, URI link) {
        return new LinkElement(text, link, false);
    }

    public static LinkElement linkButton(String text, URI link) {
        return new LinkElement(text, link, true);
    }

    public static SeparatorElement separator() {
        return new SeparatorElement();
    }

    public static ComponentElement component(Supplier<JComponent> componentSupplier) {
        return new ComponentElement(componentSupplier);
    }

    public static final class TextElement
    extends WidgetElement {
        private final Kind kind;
        private final String text;

        TextElement(Kind kind, String text) {
            this.kind = Objects.requireNonNull(kind);
            this.text = Objects.requireNonNull(text);
        }

        public String text() {
            return this.text;
        }

        public Kind kind() {
            return this.kind;
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode(this.text);
            hash = 89 * hash + Objects.hashCode((Object)this.kind);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextElement other = (TextElement)obj;
            if (!Objects.equals(this.text, other.text)) {
                return false;
            }
            return this.kind == other.kind;
        }

        public String toString() {
            return "TextElement{kind=" + String.valueOf((Object)this.kind) + ", text=" + this.text + "}";
        }

        public static enum Kind {
            NORMAL,
            ASIDE,
            SUBHEADING,
            UNAVAILABLE;

        }
    }

    public static final class ImageElement
    extends WidgetElement {
        private final String resourcePath;

        ImageElement(String resourcePath) {
            this.resourcePath = Objects.requireNonNull(resourcePath);
        }

        public String resourcePath() {
            return this.resourcePath;
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.resourcePath);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageElement other = (ImageElement)obj;
            return Objects.equals(this.resourcePath, other.resourcePath);
        }

        public String toString() {
            return "ImageElement{resourcePath=" + this.resourcePath + "}";
        }
    }

    public static final class ActionElement
    extends WidgetElement {
        private final Action action;
        private final boolean link;
        private final boolean icon;

        ActionElement(Action action, boolean link, boolean icon) {
            this.action = Objects.requireNonNull(action);
            this.link = link;
            this.icon = icon;
        }

        public Action action() {
            return this.action;
        }

        public boolean asLink() {
            return this.link;
        }

        public boolean showIcon() {
            return this.icon;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + Objects.hashCode(this.action);
            hash = 29 * hash + (this.link ? 1 : 0);
            hash = 29 * hash + (this.icon ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActionElement other = (ActionElement)obj;
            if (this.link != other.link) {
                return false;
            }
            if (this.icon != other.icon) {
                return false;
            }
            return Objects.equals(this.action, other.action);
        }

        public String toString() {
            return "ActionElement{action=" + String.valueOf(this.action) + ", link=" + this.link + ", icon=" + this.icon + "}";
        }
    }

    public static final class LinkElement
    extends WidgetElement {
        private final String text;
        private final URI link;
        private final boolean button;

        LinkElement(String text, URI link, boolean button) {
            this.text = Objects.requireNonNull(text);
            this.link = Objects.requireNonNull(link);
            this.button = button;
        }

        public String text() {
            return this.text;
        }

        public URI link() {
            return this.link;
        }

        public boolean asButton() {
            return this.button;
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + Objects.hashCode(this.text);
            hash = 23 * hash + Objects.hashCode(this.link);
            hash = 23 * hash + (this.button ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LinkElement other = (LinkElement)obj;
            if (this.button != other.button) {
                return false;
            }
            if (!Objects.equals(this.text, other.text)) {
                return false;
            }
            return Objects.equals(this.link, other.link);
        }

        public String toString() {
            return "LinkElement{text=" + this.text + ", link=" + String.valueOf(this.link) + ", button=" + this.button + "}";
        }
    }

    public static final class SeparatorElement
    extends WidgetElement {
        SeparatorElement() {
        }

        public boolean equals(Object obj) {
            return obj instanceof SeparatorElement;
        }

        public int hashCode() {
            return SeparatorElement.class.hashCode();
        }

        public String toString() {
            return "SeparatorElement{}";
        }
    }

    public static final class ComponentElement
    extends WidgetElement {
        private final Supplier<JComponent> componentSupplier;

        ComponentElement(Supplier<JComponent> componentSupplier) {
            this.componentSupplier = Objects.requireNonNull(componentSupplier);
        }

        public Supplier<JComponent> componentSupplier() {
            return this.componentSupplier;
        }

        public JComponent component() {
            return this.componentSupplier.get();
        }

        public String toString() {
            return "ComponentElement{componentSupplier=" + String.valueOf(this.componentSupplier) + "}";
        }
    }
}

