/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.netbeans.modules.java.hints.introduce.IntroduceAction;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.Exceptions;

public class MethodCandidateChooser
extends JPanel
implements FocusListener {
    private final String caption;
    private final List<IntroduceAction.Candidate> toShow;
    private final Document doc;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public MethodCandidateChooser(String caption, List<IntroduceAction.Candidate> toShow, final Document doc) {
        this.caption = caption;
        this.toShow = toShow;
        this.doc = doc;
        this.initComponents();
        this.jList1.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MethodCandidateChooser.this.valueChanged();
            }
        });
        this.jList1.setSelectedIndex(0);
        this.valueChanged();
        this.addAncestorListener(new AncestorListener(){
            final /* synthetic */ MethodCandidateChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                IntroduceHint.introduceBag(doc).clear();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void valueChanged() {
        IntroduceAction.Candidate c = (IntroduceAction.Candidate)this.jList1.getSelectedValue();
        if (c == null) {
            return;
        }
        OffsetsBag bag = new OffsetsBag(this.doc);
        bag.addHighlight(c.start, c.end, IntroduceHint.DUPE);
        IntroduceHint.introduceBag(this.doc).setHighlights(bag);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(this.caption);
        this.jLabel1.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.setModel(this.createListModel());
        this.jList1.setCellRenderer(new RendererImpl());
        this.jList1.setSelectedIndex(0);
        this.jList1.setVisibleRowCount(this.toShow.size());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MethodCandidateChooser.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MethodCandidateChooser.this.jList1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 1) {
            this.openSelected();
        }
    }

    private void jList1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && evt.getModifiers() == 0) {
            this.openSelected();
        }
    }

    private void openSelected() {
        PopupUtil.hidePopup();
        IntroduceAction.Candidate cand = (IntroduceAction.Candidate)this.jList1.getSelectedValue();
        if (cand != null) {
            try {
                cand.fix.implement();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private ListModel createListModel() {
        DefaultListModel<IntroduceAction.Candidate> dlm = new DefaultListModel<IntroduceAction.Candidate>();
        for (IntroduceAction.Candidate cand : this.toShow) {
            dlm.addElement(cand);
        }
        return dlm;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.jList1.requestFocus();
        this.jList1.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    private static class RendererImpl
    extends DefaultListCellRenderer {
        private RendererImpl() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof IntroduceAction.Candidate) {
                IntroduceAction.Candidate desc = (IntroduceAction.Candidate)value;
                this.setText(desc.displayName);
            }
            return c;
        }
    }
}

