/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.java.hints.friendapi.OverrideErrorMessage;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.EmbeddedHintsCollector;
import org.netbeans.modules.java.hints.infrastructure.ErrorPositionRefresherHelper;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.jdk.ConvertToDiamondBulkHint;
import org.netbeans.modules.java.hints.jdk.ConvertToLambda;
import org.netbeans.modules.java.hints.legacy.spi.RulesManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.source.parsing.Hacks;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class ErrorHintsProvider
extends JavaParserResultTask {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final Map<Diagnostic.Kind, Severity> errorKind2Severity = new EnumMap<Diagnostic.Kind, Severity>(Diagnostic.Kind.class);
    private static final Set<String> INVALID_METHOD_INVOCATION;
    private static final Set<String> CANNOT_RESOLVE;
    private static final Set<String> UNDERLINE_IDENTIFIER;
    private static final Set<String> USE_PROVIDED_SPAN;
    private static final Set<JavaTokenId> WHITESPACE;
    private boolean cancel;

    public ErrorHintsProvider() {
        super(JavaSource.Phase.RESOLVED);
    }

    public List<ErrorDescription> computeErrors(CompilationInfo info, Document doc, String mimeType) throws IOException {
        return this.computeErrors(info, doc, null, mimeType);
    }

    ErrorDescription processRule(CompilationInfo info, Integer forPosition, Diagnostic d, String code, Map<String, List<ErrorRule>> code2Rules, Map<Class, ErrorRule.Data> data, Document doc, boolean processDefault) throws IOException {
        int endPos;
        LazyFixList ehm;
        List<ErrorRule> rules = code2Rules.get(code);
        ArrayList<ErrorRule> allRules = rules == null ? new ArrayList<ErrorRule>() : new ArrayList<ErrorRule>(rules);
        List<ErrorRule> catchAllRules = code2Rules.get("*");
        if (catchAllRules != null) {
            allRules.addAll(catchAllRules);
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "code= " + code);
            ERR.log(1, "rules = " + String.valueOf(rules));
        }
        String desc = d.getMessage(null);
        int pos = (int)ErrorHintsProvider.getPrefferedPosition(info, d);
        TreePath path = info.getTreeUtilities().pathFor(pos + 1);
        ErrorRule.Data ruleData = new ErrorRule.Data();
        int messageRuleCount = 0;
        for (ErrorRule r : allRules) {
            String msg;
            if (!(r instanceof OverrideErrorMessage)) continue;
            OverrideErrorMessage rcm = (OverrideErrorMessage)r;
            ErrorRule.Data rd = data.get(rcm.getClass());
            if (rd == null) {
                rd = ruleData;
            }
            if ((msg = rcm.createMessage(info, d, pos, path, rd)) != null) {
                if (msg.isEmpty()) {
                    return null;
                }
                desc = msg;
                break;
            }
            if (rd.getData() == null) continue;
            data.put(rcm.getClass(), rd);
            ruleData = new ErrorRule.Data();
        }
        if (messageRuleCount < allRules.size()) {
            ehm = new CreatorBasedLazyFixList(info.getFileObject(), code, desc, pos, allRules, data);
        } else if (processDefault) {
            ehm = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
        } else {
            return null;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "ehm=" + String.valueOf(ehm));
        }
        Position[] range = this.getLine(info, d, doc, pos, (endPos = (int)d.getEndPosition()) < 0 ? pos : endPos);
        if (this.isCanceled()) {
            return null;
        }
        if (range == null || range[0] == null || range[1] == null) {
            return null;
        }
        if (forPosition != null) {
            try {
                int posRowStart = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((NbEditorDocument)doc), (int)forPosition);
                int errRowStart = org.netbeans.editor.Utilities.getRowStart((BaseDocument)((NbEditorDocument)doc), (int)range[0].getOffset());
                if (posRowStart != errRowStart) {
                    return null;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get((Object)d.getKind()), (String)desc, (LazyFixList)ehm, (Document)doc, (Position)range[0], (Position)range[1]);
    }

    List<ErrorDescription> computeErrors(CompilationInfo info, Document doc, Integer forPosition, String mimeType) throws IOException {
        if ("text/x-javahints".equals(mimeType) && info.getText().startsWith("//no-errors")) {
            return Collections.emptyList();
        }
        List errors = info.getDiagnostics();
        LinkedHashSet<ErrorDescription> descs = new LinkedHashSet<ErrorDescription>();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + String.valueOf(errors));
        }
        boolean isJava = "text/x-java".equals(mimeType);
        HashMap<Class, ErrorRule.Data> data = new HashMap<Class, ErrorRule.Data>();
        block0: for (Diagnostic _d : errors) {
            if (ConvertToDiamondBulkHint.CODES.contains(_d.getCode()) && (isJava || !ConvertToDiamondBulkHint.isHintEnabled()) || ConvertToLambda.CODES.contains(_d.getCode())) continue;
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + String.valueOf(_d));
            }
            Map code2Rules = RulesManager.getInstance().getErrors(mimeType);
            List<String> composedCodes = Collections.singletonList(_d.getCode());
            Diagnostic[] nested = Hacks.getNestedDiagnostics((Diagnostic)_d);
            if (nested != null) {
                composedCodes = new ArrayList<String>(nested.length + 1);
                composedCodes.add(_d.getCode());
                StringBuilder b = new StringBuilder();
                b.append(_d.getCode());
                for (Diagnostic d2 : nested) {
                    if (this.isCanceled()) {
                        return null;
                    }
                    String code = d2.getCode();
                    b.append("/");
                    b.append(code);
                    ErrorDescription ed = this.processRule(info, forPosition, _d, b.toString(), code2Rules, data, doc, false);
                    if (ed == null) continue;
                    descs.add(ed);
                    continue block0;
                }
            }
            if (this.isCanceled()) {
                return null;
            }
            ErrorDescription ed = this.processRule(info, forPosition, _d, _d.getCode(), code2Rules, data, doc, true);
            if (ed == null) continue;
            descs.add(ed);
        }
        if (this.isCanceled()) {
            return null;
        }
        Set disabled = Utilities.disableErrors((FileObject)info.getFileObject());
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(descs.size());
        for (ErrorDescription ed : descs) {
            if (disabled.contains(ed.getSeverity())) continue;
            result.add(ed);
        }
        if (isJava) {
            LazyHintComputationFactory.getAndClearToCompute(info.getFileObject());
        } else {
            for (ErrorDescription d : result) {
                d.getFixes().getFixes();
            }
        }
        return result;
    }

    public static Token findUnresolvedElementToken(CompilationInfo info, int offset) throws IOException {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.NEW || t.id() == JavaTokenId.WHITESPACE ? (t = ErrorHintsProvider.skipWhitespaces((TokenSequence<JavaTokenId>)ts)) == null : t.id() == JavaTokenId.IMPORT && (t = ErrorHintsProvider.skipWhitespaces((TokenSequence<JavaTokenId>)ts)) == null) {
                return null;
            }
            while (t.id() == JavaTokenId.WHITESPACE) {
                ts.moveNext();
                t = ts.token();
            }
            switch ((JavaTokenId)t.id()) {
                case IDENTIFIER: 
                case INT_LITERAL: 
                case LONG_LITERAL: 
                case FLOAT_LITERAL: 
                case DOUBLE_LITERAL: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case TRUE: 
                case FALSE: 
                case NULL: {
                    return ts.offsetToken();
                }
            }
        }
        return null;
    }

    private static Token skipWhitespaces(TokenSequence<JavaTokenId> ts) {
        boolean cont = ts.moveNext();
        while (cont && ts.token().id() == JavaTokenId.WHITESPACE) {
            cont = ts.moveNext();
        }
        if (!cont) {
            return null;
        }
        return ts.token();
    }

    private static int[] findUnresolvedElementSpan(CompilationInfo info, int offset) throws IOException {
        Token t = ErrorHintsProvider.findUnresolvedElementToken(info, offset);
        if (t != null) {
            return new int[]{t.offset(null), t.offset(null) + t.length()};
        }
        return null;
    }

    public static TreePath findUnresolvedElement(CompilationInfo info, int offset) throws IOException {
        int[] span = ErrorHintsProvider.findUnresolvedElementSpan(info, offset);
        if (span != null) {
            return info.getTreeUtilities().pathFor(span[0] + 1);
        }
        return null;
    }

    private int[] handlePossibleMethodInvocation(CompilationInfo info, Diagnostic d, Document doc, int startOffset, int endOffset) throws IOException {
        int pos = (int)ErrorHintsProvider.getPrefferedPosition(info, d);
        TreePath tp = info.getTreeUtilities().pathFor(pos + 1);
        if (tp != null && tp.getParentPath() != null && tp.getParentPath().getLeaf() != null && (tp.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION || tp.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS)) {
            int[] index = new int[1];
            if (!org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)info, (TreePath)(tp = tp.getParentPath()), new ArrayList(), (int[])index).isEmpty()) {
                Tree a;
                if (tp.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                    mit = (MethodInvocationTree)tp.getLeaf();
                    a = mit.getArguments().get(index[0]);
                } else {
                    mit = (NewClassTree)tp.getLeaf();
                    a = mit.getArguments().get(index[0]);
                }
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), a);
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), a);
                return new int[]{start, end};
            }
        }
        return null;
    }

    private Position[] getLine(CompilationInfo info, Diagnostic d, Document doc, int startOffset, int endOffset) throws IOException {
        int originalEndOffset;
        Diagnostic[] nested;
        int[] span;
        StyledDocument sdoc = (StyledDocument)doc;
        FileObject f = EditorDocumentUtils.getFileObject((Document)doc);
        if (f == null) {
            return new Position[]{null, null};
        }
        Object rawProp = doc.getProperty("stream");
        DataObject dObj = rawProp instanceof DataObject ? (DataObject)rawProp : null;
        int originalStartOffset = info.getSnapshot().getOriginalOffset(startOffset);
        int soff = startOffset;
        boolean rangePrepared = false;
        if (INVALID_METHOD_INVOCATION.contains(d.getCode()) && (span = ErrorHintsProvider.translatePositions(info, this.handlePossibleMethodInvocation(info, d, doc, soff, endOffset))) != null) {
            soff = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if (CANNOT_RESOLVE.contains(d.getCode()) && !rangePrepared && (span = ErrorHintsProvider.translatePositions(info, ErrorHintsProvider.findUnresolvedElementSpan(info, (int)ErrorHintsProvider.getPrefferedPosition(info, d)))) != null) {
            soff = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if (UNDERLINE_IDENTIFIER.contains(d.getCode()) && (span = ErrorHintsProvider.findIdentifierSpan(info, soff)) != null) {
            soff = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if ("compiler.err.illegal.unicode.esc".equals(d.getCode())) {
            String text = info.getText();
            soff = endOffset = info.getSnapshot().getOriginalOffset((int)d.getEndPosition());
            while (text.charAt(soff) != '\\') {
                --soff;
            }
            rangePrepared = true;
        }
        if (!(rangePrepared || info.getSnapshot().getOriginalOffset(startOffset) != -1 && info.getSnapshot().getOriginalOffset(endOffset) != -1)) {
            return null;
        }
        if ("compiler.err.preview.feature.disabled.plural".equals(d.getCode()) && "compiler.misc.feature.unnamed.classes".equals((nested = Hacks.getNestedDiagnostics((Diagnostic)d))[0].getCode()) && endOffset == info.getText().length()) {
            ClassTree topLevelClass = (ClassTree)info.getCompilationUnit().getTypeDecls().get(0);
            TreePath topLevelClassTP = new TreePath(new TreePath(info.getCompilationUnit()), topLevelClass);
            Tree firstNonClass = topLevelClass.getMembers().stream().filter(t -> !TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())).filter(t -> !info.getTreeUtilities().isSynthetic(new TreePath(topLevelClassTP, (Tree)t))).findFirst().orElse(null);
            if (firstNonClass != null) {
                soff = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), firstNonClass);
                endOffset = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), firstNonClass);
            }
        }
        PosExtractor ex = new PosExtractor(info, sdoc, soff, endOffset, dObj, rangePrepared);
        String text = ex.getText();
        int lineOffset = ex.lineOffset;
        if (this.isCanceled()) {
            return null;
        }
        if (!rangePrepared && d.getCode().endsWith("proc.messager") && (originalEndOffset = info.getSnapshot().getOriginalOffset(endOffset)) <= lineOffset + text.length() && originalStartOffset != -1 && originalEndOffset != -1) {
            soff = originalStartOffset;
            endOffset = originalEndOffset;
            rangePrepared = true;
        }
        if (!rangePrepared && USE_PROVIDED_SPAN.contains(d.getCode())) {
            soff = originalStartOffset;
            endOffset = info.getSnapshot().getOriginalOffset(endOffset);
            rangePrepared = true;
        }
        if (!rangePrepared || endOffset < soff) {
            int column;
            int length = text.length();
            for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
            }
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
            soff = length == 0 ? lineOffset : lineOffset + column;
            endOffset = lineOffset + length;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + soff);
            ERR.log(1, "endOffset = " + endOffset);
        }
        if (soff < 0) {
            LOG.log(Level.WARNING, "Incorrect offsets computed, add report to https://netbeans.org/bugzilla/show_bug.cgi?id=242191");
            LOG.log(Level.WARNING, "Diagnostic: {0}, code: {1} ", new Object[]{d, d.getCode()});
            LOG.log(Level.WARNING, "Start: {0}, End: {1}, Soff: {2}, RangePrepared: {3}", new Object[]{startOffset, endOffset, soff, rangePrepared});
            LOG.log(Level.WARNING, "Source text:\n--------------------------------------------------------\n" + String.valueOf(info.getSnapshot().getText()) + "\n--------------------------------------------------------");
        }
        return ex.getResult(soff, endOffset);
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.resume();
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            Logger.getLogger(ErrorHintsProvider.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long version = DocumentUtilities.getDocumentVersion((Document)doc);
        String mimeType = result.getSnapshot().getSource().getMimeType();
        long start = System.currentTimeMillis();
        try {
            List<ErrorDescription> errors = this.computeErrors(info, doc, mimeType);
            if (errors == null) {
                return;
            }
            EmbeddedHintsCollector.setAnnotations(result.getSnapshot(), errors);
            ErrorPositionRefresherHelper.setVersion(doc, errors);
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Java Hints", new Object[]{info.getFileObject(), end - start});
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private static int[] translatePositions(CompilationInfo info, int[] span) {
        if (span == null || span[0] == -1 || span[1] == -1) {
            return null;
        }
        int start = info.getSnapshot().getOriginalOffset(span[0]);
        int end = info.getSnapshot().getOriginalOffset(span[1]);
        if (start == -1 || end == -1 || end < start) {
            return null;
        }
        return new int[]{start, end};
    }

    public static long getPrefferedPosition(CompilationInfo info, Diagnostic d) throws IOException {
        TreePath path;
        Object param;
        int[] span;
        if ("compiler.err.doesnt.exist".equals(d.getCode()) || "compiler.err.try.with.resources.expr.needs.var".equals(d.getCode())) {
            return d.getStartPosition();
        }
        if ("compiler.err.cant.resolve.location".equals(d.getCode()) || "compiler.err.cant.resolve.location.args".equals(d.getCode())) {
            int[] span2 = ErrorHintsProvider.findUnresolvedElementSpan(info, (int)d.getPosition());
            if (span2 != null) {
                return span2[0];
            }
            return d.getPosition();
        }
        if ("compiler.err.not.stmt".equals(d.getCode())) {
            javax.lang.model.element.Element el;
            TreePath path2 = ErrorHintsProvider.findUnresolvedElement(info, (int)d.getStartPosition() - 1);
            javax.lang.model.element.Element element = el = path2 != null ? info.getTrees().getElement(path2) : null;
            if (el == null || el.asType().getKind() == TypeKind.ERROR) {
                return d.getStartPosition() - 1L;
            }
            return d.getStartPosition();
        }
        if ("compiler.err.var.might.not.have.been.initialized".equals(d.getCode()) && (span = ErrorHintsProvider.findIdentifierSpan(info, (int)d.getPosition())) == null && (param = SourceUtils.getDiagnosticParam((Diagnostic)d, (int)0)) instanceof VariableElement && (path = info.getTrees().getPath((VariableElement)param)) != null && path.getLeaf().getKind() == Tree.Kind.VARIABLE && (span = info.getTreeUtilities().findNameSpan((VariableTree)path.getLeaf())) != null) {
            return span[0];
        }
        return d.getPosition();
    }

    private static int[] findIdentifierSpan(CompilationInfo info, int offset) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        int diff = ts.move(offset);
        if (ts.moveNext() && diff >= 0 && diff < ts.token().length()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.NEW) {
                while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.CLASS) {
                while (ts.moveNext() && WHITESPACE.contains(ts.token().id())) {
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ErrorHintsProvider.translatePositions(info, new int[]{ts.offset(), ts.offset() + t.length()});
            }
        }
        return null;
    }

    static {
        errorKind2Severity.put(Diagnostic.Kind.ERROR, Severity.ERROR);
        errorKind2Severity.put(Diagnostic.Kind.MANDATORY_WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.NOTE, Severity.HINT);
        errorKind2Severity.put(Diagnostic.Kind.OTHER, Severity.WARNING);
        INVALID_METHOD_INVOCATION = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.resolve.location.args"));
        CANNOT_RESOLVE = new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.doesnt.exist", "compiler.err.type.error"));
        UNDERLINE_IDENTIFIER = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final", "compiler.err.var.might.not.have.been.initialized", "compiler.err.report.access", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated", "compiler.warn.missing.SVUID", "compiler.warn.has.been.deprecated", "compiler.warn.raw.class.use", "compiler.err.class.public.should.be.in.file", "compiler.err.cant.ref.non.effectively.final.var"));
        USE_PROVIDED_SPAN = new HashSet<String>(Arrays.asList("compiler.err.method.does.not.override.superclass", "compiler.err.illegal.unicode.esc", "compiler.err.unreported.exception.need.to.catch.or.throw"));
        WHITESPACE = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    }

    class PosExtractor
    implements Runnable {
        private final CompilationInfo info;
        private int startOffset;
        private int endOffset;
        private final boolean rangePrepared;
        private final StyledDocument sdoc;
        private final DataObject dobj;
        private String text;
        private int lineOffset;
        private Position[] result = new Position[2];
        private int state;

        public PosExtractor(CompilationInfo info, StyledDocument doc, int startOffset, int endOffset, DataObject dobj, boolean rangePrepared) {
            this.info = info;
            this.sdoc = doc;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.rangePrepared = rangePrepared;
            this.dobj = dobj;
        }

        private void findText() {
            final int lineNumber = NbDocument.findLineNumber((StyledDocument)this.sdoc, (int)this.info.getSnapshot().getOriginalOffset(this.startOffset));
            this.lineOffset = NbDocument.findLineOffset((StyledDocument)this.sdoc, (int)lineNumber);
            if (this.rangePrepared) {
                return;
            }
            if (this.dobj == null) {
                this.sdoc.render(new Runnable(){
                    final /* synthetic */ PosExtractor this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        Element root = NbDocument.findLineRootElement((StyledDocument)this.this$1.sdoc);
                        if (root.getElementCount() <= lineNumber) {
                            this.this$1.text = null;
                        } else {
                            try {
                                Element line = root.getElement(lineNumber);
                                this.this$1.text = this.this$1.sdoc.getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset());
                            }
                            catch (BadLocationException ex) {
                                this.this$1.text = null;
                            }
                        }
                    }
                });
            } else {
                LineCookie lc = (LineCookie)this.dobj.getCookie(LineCookie.class);
                Line line = lc.getLineSet().getCurrent(lineNumber);
                this.text = line.getText();
            }
            if (this.text == null) {
                ErrorHintsProvider.this.cancel();
                return;
            }
        }

        public String getText() {
            this.state = 0;
            this.sdoc.render(this);
            return this.text;
        }

        public Position[] getResult(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.state = 1;
            this.sdoc.render(this);
            return this.result;
        }

        private void findResult() {
            if (ErrorHintsProvider.this.isCanceled()) {
                return;
            }
            int len = this.sdoc.getLength();
            if (this.startOffset >= len || this.endOffset > len) {
                if (!ErrorHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                    ERR.log(16, "document changed, but not canceled?");
                    ERR.log(16, "len = " + len);
                    ERR.log(16, "startOffset = " + this.startOffset);
                    ERR.log(16, "endOffset = " + this.endOffset);
                }
                ErrorHintsProvider.this.cancel();
                return;
            }
            try {
                this.result[0] = NbDocument.createPosition((Document)this.sdoc, (int)this.startOffset, (Position.Bias)Position.Bias.Forward);
                this.result[1] = NbDocument.createPosition((Document)this.sdoc, (int)this.endOffset, (Position.Bias)Position.Bias.Backward);
            }
            catch (BadLocationException e) {
                ERR.notify(65536, (Throwable)e);
            }
        }

        @Override
        public void run() {
            switch (this.state) {
                case 0: {
                    this.findText();
                    break;
                }
                case 1: {
                    this.findResult();
                }
            }
        }
    }
}

