/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AssignResultToVariable
extends AbstractHint {
    private static final Set<JavaTokenId> TO_IGNORE = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    private static final String VAR_TYPE_TAG = "varType";
    private static final Set<TypeKind> NOT_ACCEPTABLE_TYPE_KINDS = EnumSet.of(TypeKind.ERROR, new TypeKind[]{TypeKind.EXECUTABLE, TypeKind.NONE, TypeKind.NULL, TypeKind.OTHER, TypeKind.PACKAGE, TypeKind.WILDCARD, TypeKind.VOID});

    public AssignResultToVariable() {
        super(true, false, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.BLOCK);
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        try {
            int offset = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
            boolean verifyOffset = true;
            boolean error = false;
            if (treePath.getLeaf().getKind() == Tree.Kind.BLOCK) {
                StatementTree found = this.findStatementForgiving(info, (BlockTree)treePath.getLeaf(), offset);
                if (found == null || found.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                    return null;
                }
                ExpressionStatementTree est = (ExpressionStatementTree)found;
                Tree.Kind innerKind = est.getExpression().getKind();
                if (innerKind == Tree.Kind.ERRONEOUS) {
                    ErroneousTree err = (ErroneousTree)est.getExpression();
                    if (err.getErrorTrees().isEmpty()) {
                        return null;
                    }
                    treePath = new TreePath(new TreePath(treePath, found), err.getErrorTrees().get(0));
                    error = true;
                } else if (innerKind == Tree.Kind.METHOD_INVOCATION || innerKind == Tree.Kind.NEW_CLASS) {
                    treePath = new TreePath(new TreePath(treePath, found), est.getExpression());
                } else {
                    return null;
                }
                verifyOffset = false;
            }
            if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                return null;
            }
            Tree tree = treePath.getLeaf();
            Tree exprTree = null;
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.METHOD_INVOCATION) {
                exprTree = ((MethodInvocationTree)tree).getMethodSelect();
            } else if (kind == Tree.Kind.NEW_CLASS) {
                exprTree = tree;
            }
            long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), exprTree);
            long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), exprTree);
            if (verifyOffset) {
                NewClassTree nct;
                if (start == -1L || end == -1L || (long)offset < start || (long)offset > end) {
                    return null;
                }
                if (kind == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)exprTree).getClassBody() != null) {
                    long bodyStart = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), nct.getClassBody());
                    long bodyEnd = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), nct.getClassBody());
                    if (bodyStart != -1L && bodyEnd != -1L && (long)offset > bodyStart && (long)offset <= bodyEnd) {
                        return null;
                    }
                }
            }
            Element elem = info.getTrees().getElement(treePath);
            if (!error && (elem == null || elem.getKind() != ElementKind.METHOD && elem.getKind() != ElementKind.CONSTRUCTOR)) {
                return null;
            }
            TypeMirror base = info.getTrees().getTypeMirror(treePath);
            TypeMirror type = Utilities.resolveTypeForDeclaration(info, base);
            if (!error && !Utilities.isValidType(base) && type.getKind() != TypeKind.EXECUTABLE && treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                TypeMirror retType = ((ExecutableElement)elem).getReturnType();
                if (!info.getTypes().isAssignable(info.getTypes().erasure(retType), info.getTypes().erasure(type))) {
                    return null;
                }
            }
            if (type == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)type.getKind())) {
                return null;
            }
            List<FixImpl> fixes = Collections.singletonList(new FixImpl(info.getFileObject(), info.getDocument(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), TypeMirrorHandle.create((TypeMirror)type)));
            String description = NbBundle.getMessage(AssignResultToVariable.class, (String)"HINT_AssignResultToVariable");
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)description, fixes, (FileObject)info.getFileObject(), (int)offset, (int)offset));
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private int findFirstNonWhitespace(CompilationInfo info, int offset, boolean previous) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (!ts.moveNext()) {
            return -1;
        }
        if (!TO_IGNORE.contains(ts.token().id())) {
            return offset;
        }
        do {
            JavaTokenId id;
            if (!TO_IGNORE.contains(id = (JavaTokenId)ts.token().id())) {
                offset = ts.offset() + (previous ? ts.token().length() : 0);
                break;
            }
            CharSequence text = ts.token().text();
            int start = Math.max(0, previous ? 0 : offset - ts.offset());
            int end = Math.min(text.length(), previous ? offset - ts.offset() : Integer.MAX_VALUE);
            for (int c = start; c < end; ++c) {
                if (text.charAt(c) != '\n') continue;
                return -1;
            }
        } while (!previous ? ts.moveNext() : ts.movePrevious());
        return offset;
    }

    private StatementTree findExactStatement(CompilationInfo info, BlockTree block, int offset, boolean start) {
        if (offset == -1) {
            return null;
        }
        SourcePositions sp = info.getTrees().getSourcePositions();
        CompilationUnitTree cut = info.getCompilationUnit();
        for (StatementTree statementTree : block.getStatements()) {
            long pos = start ? sp.getStartPosition(info.getCompilationUnit(), statementTree) : sp.getEndPosition(cut, statementTree);
            if ((long)offset != pos) continue;
            return statementTree;
        }
        return null;
    }

    private StatementTree findMatchingMethodInvocation(CompilationInfo info, BlockTree block, int offset) {
        for (StatementTree statementTree : block.getStatements()) {
            if (statementTree.getKind() != Tree.Kind.EXPRESSION_STATEMENT) continue;
            long statementStart = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), statementTree);
            if ((long)offset < statementStart) {
                return null;
            }
            ExpressionStatementTree est = (ExpressionStatementTree)statementTree;
            long statementEnd = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), statementTree);
            long expressionEnd = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), est.getExpression());
            if (expressionEnd > (long)offset || (long)offset >= statementEnd) continue;
            return statementTree;
        }
        return null;
    }

    private StatementTree findStatementForgiving(CompilationInfo info, BlockTree block, int offset) {
        StatementTree found = this.findMatchingMethodInvocation(info, block, offset);
        if (found != null) {
            return found;
        }
        StatementTree left = this.findExactStatement(info, block, offset, false);
        StatementTree right = this.findExactStatement(info, block, offset, true);
        if (left != null && right != null) {
            return null;
        }
        if (left != null) {
            return left;
        }
        if (right != null) {
            return right;
        }
        int leftOffset = this.findFirstNonWhitespace(info, offset, true);
        int rightOffset = this.findFirstNonWhitespace(info, offset, false);
        left = this.findExactStatement(info, block, leftOffset, false);
        right = this.findExactStatement(info, block, rightOffset, true);
        if (left != null && right != null) {
            return null;
        }
        return left != null ? left : right;
    }

    public void cancel() {
    }

    public String getId() {
        return AssignResultToVariable.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DN_AssignResultToVariable");
    }

    public String getDescription() {
        return NbBundle.getMessage(AssignResultToVariable.class, (String)"DESC_AssignResultToVariable");
    }

    static final class FixImpl
    implements Fix,
    Runnable {
        private FileObject file;
        private Document doc;
        private TreePathHandle tph;
        private Position pos;
        private TypeMirrorHandle typeHandle;

        public FixImpl(FileObject file, Document doc, TreePathHandle tph, TypeMirrorHandle typeHandle) {
            this.file = file;
            this.doc = doc;
            this.tph = tph;
            this.typeHandle = typeHandle;
        }

        public String getText() {
            return NbBundle.getMessage(AssignResultToVariable.class, (String)"FIX_AssignResultToVariable");
        }

        @Override
        public void run() {
            if (this.pos == null) {
                return;
            }
            try {
                EditorCookie cook = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                JEditorPane[] arr = cook.getOpenedPanes();
                if (arr == null) {
                    return;
                }
                arr[0].setCaretPosition(this.pos.getOffset());
                InstantRenamePerformer.invokeInstantRename((JTextComponent)arr[0]);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public ChangeInfo implement() {
            try {
                final String[] name = new String[1];
                ModificationResult result = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)new Task<WorkingCopy>(){
                    final /* synthetic */ FixImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(WorkingCopy copy) throws Exception {
                        copy.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath tp = this.this$0.tph.resolve((CompilationInfo)copy);
                        if (tp == null) {
                            Logger.getLogger(AssignResultToVariable.class.getName()).info("tp=null");
                            return;
                        }
                        TypeMirror type = this.this$0.typeHandle.resolve((CompilationInfo)copy);
                        if (type == null || NOT_ACCEPTABLE_TYPE_KINDS.contains((Object)type.getKind())) {
                            return;
                        }
                        Tree t = tp.getLeaf();
                        boolean isAnonymous = false;
                        ExpressionTree identifier = null;
                        if (t instanceof NewClassTree) {
                            Element el = copy.getTrees().getElement(tp);
                            if (el == null) {
                                return;
                            }
                            NewClassTree nct = (NewClassTree)t;
                            isAnonymous = nct.getClassBody() != null || el.getKind().isInterface() || el.getModifiers().contains((Object)Modifier.ABSTRACT);
                            identifier = nct.getIdentifier();
                        }
                        type = Utilities.resolveTypeForDeclaration((CompilationInfo)copy, type);
                        TreeMaker make = copy.getTreeMaker();
                        name[0] = Utilities.guessName((CompilationInfo)copy, tp);
                        ExpressionTree varType = isAnonymous ? identifier : make.Type(type);
                        VariableTree var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name[0], (Tree)varType, (ExpressionTree)tp.getLeaf());
                        var = Utilities.copyComments(copy, tp.getParentPath().getLeaf(), var);
                        copy.tag((Tree)varType, (Object)AssignResultToVariable.VAR_TYPE_TAG);
                        copy.rewrite(tp.getParentPath().getLeaf(), (Tree)var);
                    }
                });
                result.commit();
                final int[] varTypeSpan = result.getSpan((Object)AssignResultToVariable.VAR_TYPE_TAG);
                if (varTypeSpan == null) {
                    Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "Cannot resolve variable type span.");
                    return null;
                }
                final ChangeInfo[] info = new ChangeInfo[1];
                this.doc.render(new Runnable(){
                    final /* synthetic */ FixImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            CharSequence text = DocumentUtilities.getText((Document)this.this$0.doc, (int)varTypeSpan[1], (int)(this.this$0.doc.getLength() - varTypeSpan[1]));
                            Pattern p = Pattern.compile(Pattern.quote(name[0]));
                            Matcher m = p.matcher(text);
                            if (m.find()) {
                                int startPos = varTypeSpan[1] + m.start();
                                this.this$0.pos = this.this$0.doc.createPosition(startPos);
                                info[0] = new ChangeInfo(this.this$0.pos, this.this$0.doc.createPosition(startPos + name[0].length()));
                            } else {
                                Logger.getLogger(AssignResultToVariable.class.getName()).log(Level.INFO, "Cannot find the name in: {0}", text.toString());
                            }
                        }
                        catch (BadLocationException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
                SwingUtilities.invokeLater(this);
                return info[0];
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                return null;
            }
        }
    }
}

