/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.openide.util.RequestProcessor;

public abstract class ConnectionDialogMediator {
    public static final String PROP_VALID = "valid";
    private final List<ConnectionProgressListener> connProgressListeners = new ArrayList<ConnectionProgressListener>();
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private boolean valid = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionProgressListener(ConnectionProgressListener listener) {
        List<ConnectionProgressListener> list = this.connProgressListeners;
        synchronized (list) {
            this.connProgressListeners.add(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void closeConnection() {
    }

    protected abstract boolean retrieveSchemas(SchemaPanel var1, DatabaseConnection var2, String var3);

    protected RequestProcessor.Task retrieveSchemasAsync(final SchemaPanel schemaPanel, final DatabaseConnection dbcon, final String defaultSchema) {
        this.fireConnectionStarted();
        RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ ConnectionDialogMediator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.retrieveSchemas(schemaPanel, dbcon, defaultSchema);
                this.this$0.fireConnectionFinished();
            }
        });
        return task;
    }

    protected void fireConnectionStarted() {
        Iterator<ConnectionProgressListener> i = this.connProgressListenersCopy();
        while (i.hasNext()) {
            i.next().connectionStarted();
        }
    }

    protected void fireConnectionStep(String step) {
        Iterator<ConnectionProgressListener> i = this.connProgressListenersCopy();
        while (i.hasNext()) {
            i.next().connectionStep(step);
        }
    }

    protected void fireConnectionFinished() {
        Iterator<ConnectionProgressListener> i = this.connProgressListenersCopy();
        while (i.hasNext()) {
            i.next().connectionFinished();
        }
    }

    protected void fireConnectionFailed() {
        Iterator<ConnectionProgressListener> i = this.connProgressListenersCopy();
        while (i.hasNext()) {
            i.next().connectionFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ConnectionProgressListener> connProgressListenersCopy() {
        ArrayList<ConnectionProgressListener> listenersCopy = null;
        List<ConnectionProgressListener> list = this.connProgressListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<ConnectionProgressListener>(this.connProgressListeners);
        }
        return listenersCopy.iterator();
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.propChangeSupport.firePropertyChange(PROP_VALID, null, null);
    }

    public boolean getValid() {
        return this.valid;
    }
}

