/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class SelectJavadocTask
implements Runnable,
Callable<Boolean>,
CancellableTask<CompilationController> {
    private final Lookup.Provider lookupProvider;
    private ElementHandle<?> handle;
    private ElementJavadoc doc;
    private volatile boolean cancelled;

    private SelectJavadocTask(@NonNull Lookup.Provider lookupProvider) {
        Parameters.notNull((CharSequence)"lookupProvider", (Object)lookupProvider);
        this.lookupProvider = lookupProvider;
    }

    @Override
    public void run() {
        Pair<FileObject, ElementJavadoc> documentation;
        this.cancelled = false;
        if (JavadocTopComponent.shouldUpdate() && (documentation = this.getJavaDoc()) != null) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ SelectJavadocTask this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JavadocTopComponent tc = JavadocTopComponent.findInstance();
                    if (tc != null) {
                        tc.open();
                        tc.setJavadoc((FileObject)documentation.first(), (ElementJavadoc)documentation.second());
                    }
                }
            });
        }
    }

    public void run(CompilationController cc) throws Exception {
        if (this.cancelled) {
            return;
        }
        cc.toPhase(JavaSource.Phase.UP_TO_DATE);
        if (this.cancelled) {
            return;
        }
        Element e = this.handle.resolve((CompilationInfo)cc);
        if (e != null && !this.cancelled) {
            this.doc = ElementJavadoc.create((CompilationInfo)cc, (Element)e, (Callable)this);
        }
    }

    @Override
    @NonNull
    public Boolean call() throws Exception {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    @CheckForNull
    private Pair<FileObject, ElementJavadoc> getJavaDoc() {
        Node node = (Node)this.lookupProvider.getLookup().lookup(Node.class);
        if (node == null) {
            return null;
        }
        TreePathHandle tph = (TreePathHandle)node.getLookup().lookup(TreePathHandle.class);
        if (tph == null) {
            return null;
        }
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        this.handle = tph.getElementHandle();
        try {
            js.runUserActionTask((Task)this, true);
        }
        catch (IOException ioE) {
            Exceptions.printStackTrace((Throwable)ioE);
            return null;
        }
        return Pair.of((Object)fo, (Object)this.doc);
    }

    public static SelectJavadocTask create(@NonNull Lookup.Provider lookupProvider) {
        return new SelectJavadocTask(lookupProvider);
    }
}

