/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.codetemplates;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.latte.completion.LatteCompletionContext;
import org.netbeans.modules.php.latte.completion.LatteCompletionContextFinder;
import org.netbeans.modules.php.latte.parser.LatteParserResult;
import org.openide.util.RequestProcessor;

public final class LatteCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private static final Logger LOGGER = Logger.getLogger(LatteCodeTemplateFilter.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(LatteCodeTemplateFilter.class);
    private volatile boolean accept = true;
    private final int offset;
    private final Future<Future<Void>> future;

    private LatteCodeTemplateFilter(final JTextComponent component, int offset) {
        this.offset = offset;
        this.future = RP.submit((Callable)new Callable<Future<Void>>(){
            final /* synthetic */ LatteCodeTemplateFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Future<Void> call() throws Exception {
                try {
                    return this.this$0.parseDocument(component.getDocument());
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                    return null;
                }
            }
        });
    }

    private Future<Void> parseDocument(Document document) throws ParseException {
        return ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)document)), (UserTask)this);
    }

    public boolean accept(CodeTemplate template) {
        try {
            this.future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return this.accept;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        assert (resultIterator != null);
        Parser.Result parserResult = resultIterator.getParserResult();
        if (parserResult instanceof LatteParserResult) {
            LatteCompletionContext context = LatteCompletionContextFinder.find((LatteParserResult)parserResult, this.offset);
            this.accept = LatteCompletionContext.MACRO.equals((Object)context) || LatteCompletionContext.ALL.equals((Object)context);
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new LatteCodeTemplateFilter(component, offset);
        }
    }
}

