/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.wizards.Bundle;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureExistingProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.ConfigureNewProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConfigureProjectPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
SourcesFolderProvider,
ChangeListener,
CancelablePanel {
    static final String PROJECT_NAME = "projectName";
    static final String PROJECT_DIR = "projectDir";
    static final String IS_PROJECT_DIR_USED = "isProjectDirUsed";
    static final String SOURCES_FOLDER = "sourcesFolder";
    static final String LOCAL_SERVERS = "localServers";
    static final String PHP_VERSION = "phpVersion";
    static final String ENCODING = "encoding";
    static final String ROOTS = "roots";
    private final String[] steps;
    private final NewPhpProjectWizardIterator.WizardType wizardType;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private ConfigurableProjectPanel configureProjectPanelVisual = null;
    private WizardDescriptor descriptor = null;
    private String originalProjectName = null;
    private String originalSources = null;
    private volatile boolean canceled;

    public ConfigureProjectPanel(String[] steps, NewPhpProjectWizardIterator.WizardType wizardType) {
        this.steps = (String[])steps.clone();
        this.wizardType = wizardType;
    }

    public Component getComponent() {
        if (this.configureProjectPanelVisual == null) {
            switch (this.wizardType) {
                case NEW: 
                case REMOTE: {
                    this.configureProjectPanelVisual = new ConfigureNewProjectPanelVisual(this);
                    break;
                }
                case EXISTING: {
                    this.configureProjectPanelVisual = new ConfigureExistingProjectPanelVisual(this);
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                    break;
                }
            }
            this.addListeners();
        }
        return this.configureProjectPanelVisual;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ConfigureProjectPanel.class.getName() + "." + (Object)((Object)this.wizardType));
    }

    public void readSettings(WizardDescriptor settings) {
        this.getComponent();
        this.descriptor = settings;
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                MutableComboBoxModel<LocalServer> localServers = this.getLocalServers();
                if (localServers != null) {
                    this.configureProjectPanelVisual.setLocalServerModel(localServers);
                } else {
                    this.configureProjectPanelVisual.setLocalServerModel(new LocalServer.ComboBoxModel(LocalServer.PENDING_LOCAL_SERVER));
                    this.configureProjectPanelVisual.setState(false);
                    this.canceled = false;
                    PhpEnvironment.get().readDocumentRoots(new PhpEnvironment.ReadDocumentRootsNotifier(){

                        @Override
                        public void finished(final List<PhpEnvironment.DocumentRoot> documentRoots) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.ConfigureProjectPanel.this.initLocalServers(documentRoots);
                                }
                            });
                        }
                    });
                }
                LocalServer sourcesLocation = this.getLocalServer();
                if (sourcesLocation == null) break;
                this.configureProjectPanelVisual.selectSourcesLocation(sourcesLocation);
                break;
            }
            case EXISTING: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.configureProjectPanelVisual.setProjectFolder(this.getProjectFolder().getAbsolutePath());
        PhpVersion phpVersion = this.getPhpVersion();
        if (phpVersion != null) {
            this.configureProjectPanelVisual.setPhpVersion(phpVersion);
        }
        this.configureProjectPanelVisual.setEncoding(this.getEncoding());
    }

    private void addListeners() {
        this.configureProjectPanelVisual.addConfigureProjectListener(this);
    }

    private void removeListeners() {
        this.configureProjectPanelVisual.removeConfigureProjectListener(this);
    }

    public void storeSettings(WizardDescriptor settings) {
        File projectDir = this.getProjectFolderFile();
        if (projectDir != null) {
            projectDir = FileUtil.normalizeFile((File)projectDir);
        }
        settings.putProperty(IS_PROJECT_DIR_USED, (Object)this.configureProjectPanelVisual.isProjectFolderUsed());
        settings.putProperty(PROJECT_DIR, (Object)projectDir);
        settings.putProperty(PROJECT_NAME, (Object)this.configureProjectPanelVisual.getProjectName());
        settings.putProperty(SOURCES_FOLDER, (Object)this.configureProjectPanelVisual.getSourcesLocation());
        settings.putProperty(LOCAL_SERVERS, this.configureProjectPanelVisual.getLocalServerModel());
        settings.putProperty(PHP_VERSION, (Object)this.configureProjectPanelVisual.getPhpVersion());
        settings.putProperty(ENCODING, (Object)this.configureProjectPanelVisual.getEncoding());
    }

    public File getProjectFolderFile() {
        String projectFolder = this.configureProjectPanelVisual.getProjectFolder();
        if (!StringUtils.hasText((String)projectFolder)) {
            return null;
        }
        return new File(projectFolder);
    }

    public boolean isFinishPanel() {
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.REMOTE) {
            return false;
        }
        return NewPhpProjectWizardIterator.areAllStepsValid(this.descriptor);
    }

    public boolean isValid() {
        this.getComponent();
        if (!this.configureProjectPanelVisual.getState()) {
            return false;
        }
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String error = null;
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                if (this.descriptor.getProperty(ROOTS) == null) {
                    return false;
                }
                error = this.validateProject();
                if (error != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                    return false;
                }
                error = this.validateSources(false);
                if (error != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                    return false;
                }
                error = this.validateProjectDirectory();
                if (error == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                return false;
            }
            case EXISTING: {
                String sourcesFolder = this.configureProjectPanelVisual.getSourcesFolder();
                if (sourcesFolder == null || sourcesFolder.trim().length() == 0) {
                    this.descriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_EmptySources"));
                    return false;
                }
                error = this.validateSources(true);
                if (error != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                    return false;
                }
                error = this.validateProject();
                if (error != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                    return false;
                }
                error = this.validateProjectDirectory();
                if (error == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
                return false;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public File getSourcesFolder() {
        this.getComponent();
        return FileUtil.normalizeFile((File)new File(this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot()));
    }

    @Override
    public String getSourcesFolderName() {
        this.getComponent();
        return this.configureProjectPanelVisual.getProjectName();
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    String[] getSteps() {
        return this.steps;
    }

    public NewPhpProjectWizardIterator.WizardType getWizardType() {
        return this.wizardType;
    }

    String getProjectName() {
        String projectName = (String)this.descriptor.getProperty(PROJECT_NAME);
        if (projectName == null) {
            projectName = this.getDefaultFreeName(ProjectChooser.getProjectsFolder());
            this.descriptor.putProperty(PROJECT_NAME, (Object)projectName);
        }
        return projectName;
    }

    private File getProjectFolder(String projectName) {
        return new File(this.getProjectFolder().getParentFile(), projectName);
    }

    private File getProjectFolder() {
        File projectFolder = (File)this.descriptor.getProperty(PROJECT_DIR);
        if (projectFolder == null) {
            projectFolder = new File(ProjectChooser.getProjectsFolder(), this.getProjectName());
            this.descriptor.putProperty(PROJECT_DIR, (Object)projectFolder);
        }
        return projectFolder;
    }

    private String getDefaultFreeName(File projectFolder) {
        String projectName;
        int i = 1;
        while ((projectName = this.validFreeProjectName(projectFolder, i++)) == null) {
        }
        return projectName;
    }

    private PhpVersion getPhpVersion() {
        return (PhpVersion)this.descriptor.getProperty(PHP_VERSION);
    }

    private Charset getEncoding() {
        Charset enc = (Charset)this.descriptor.getProperty(ENCODING);
        if (enc == null) {
            enc = FileEncodingQuery.getDefaultEncoding();
        }
        return enc;
    }

    private LocalServer getLocalServer() {
        return (LocalServer)this.descriptor.getProperty(SOURCES_FOLDER);
    }

    private MutableComboBoxModel<LocalServer> getLocalServers() {
        return (MutableComboBoxModel)this.descriptor.getProperty(LOCAL_SERVERS);
    }

    private void initLocalServers(List<PhpEnvironment.DocumentRoot> documentRoots) {
        if (this.canceled) {
            return;
        }
        File preferredRoot = ProjectChooser.getProjectsFolder();
        for (PhpEnvironment.DocumentRoot root : documentRoots) {
            if (!root.isPreferred()) continue;
            preferredRoot = new File(root.getDocumentRoot());
            break;
        }
        this.descriptor.putProperty(ROOTS, documentRoots);
        String projectName = this.getDefaultFreeName(preferredRoot);
        this.descriptor.putProperty(PROJECT_NAME, (Object)projectName);
        int size = documentRoots.size();
        ArrayList<LocalServer> localServers = new ArrayList<LocalServer>(size);
        for (PhpEnvironment.DocumentRoot root : documentRoots) {
            String srcRoot = new File(root.getDocumentRoot(), projectName).getAbsolutePath();
            LocalServer ls = new LocalServer(null, root.getUrl(), root.getDocumentRoot(), srcRoot, true);
            localServers.add(ls);
        }
        this.descriptor.putProperty("copySrcTargets", (Object)new LocalServer.ComboBoxModel(localServers.toArray(new LocalServer[size])));
        File projectFolder = FileUtil.normalizeFile((File)this.getProjectFolder(projectName));
        LocalServer selected = new LocalServer(projectFolder.getAbsolutePath());
        LocalServer.ComboBoxModel model = new LocalServer.ComboBoxModel(selected);
        for (PhpEnvironment.DocumentRoot root : documentRoots) {
            LocalServer ls = new LocalServer(root.getDocumentRoot() + File.separator + projectName);
            ls.setHint(root.getHint());
            model.addElement(ls);
            if (!root.isPreferred()) continue;
            selected = ls;
        }
        model.setSelectedItem(selected);
        this.descriptor.putProperty(SOURCES_FOLDER, (Object)selected);
        this.descriptor.putProperty(LOCAL_SERVERS, (Object)model);
        this.descriptor.putProperty(PROJECT_DIR, (Object)projectFolder);
        this.configureProjectPanelVisual.setLocalServerModel(model);
        this.configureProjectPanelVisual.setProjectName(projectName);
        this.configureProjectPanelVisual.setProjectFolder(projectFolder.getAbsolutePath());
        this.configureProjectPanelVisual.setState(true);
        this.fireChangeEvent();
    }

    private String validFreeProjectName(File parentFolder, int index) {
        String name = MessageFormat.format(NbBundle.getMessage(ConfigureProjectPanel.class, (String)"TXT_DefaultProjectName"), index);
        File file = new File(parentFolder, name);
        if (file.exists()) {
            return null;
        }
        return name;
    }

    private String validateProject() {
        String projectName = this.configureProjectPanelVisual.getProjectName();
        if (projectName.trim().length() == 0) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectName");
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed()) {
            return null;
        }
        File projectFolder = this.getProjectFolderFile();
        if (projectFolder == null || !Utils.isValidFileName(projectFolder)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectFolder");
        }
        String err = Utils.validateProjectDirectory(projectFolder, "Project", true, false);
        if (err != null) {
            return err;
        }
        if (PhpProjectUtils.isProject(projectFolder)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectAlreadyProject");
        }
        this.warnIfNotEmpty(projectFolder.getAbsolutePath(), "Project");
        return null;
    }

    private String validateSources(boolean children) {
        String err = null;
        LocalServer localServer = this.configureProjectPanelVisual.getSourcesLocation();
        String sourcesLocation = localServer.getSrcRoot();
        File sources = FileUtil.normalizeFile((File)new File(sourcesLocation));
        if (sourcesLocation.trim().length() == 0 || !Utils.isValidFileName(sources)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
        }
        if (this.isHomeDir(sources)) {
            return Bundle.ConfigureProjectPanel_error_sources_homeDir();
        }
        err = Utils.validateProjectDirectory(sourcesLocation, "Sources", true, true);
        if (err != null) {
            return err;
        }
        if (children) {
            if (!sources.isDirectory()) {
                return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
            }
            if (sources.listFiles() == null) {
                return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesCannotBeRead");
            }
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed() && PhpProjectUtils.isProject(sources)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesAlreadyProject");
        }
        err = this.validateSourcesAndCopyTarget();
        if (err != null) {
            return err;
        }
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                this.warnIfNotEmpty(sourcesLocation, "Sources");
                break;
            }
            case EXISTING: {
                this.warnIfEmptySources(sourcesLocation);
            }
        }
        return null;
    }

    private boolean isHomeDir(File folder) {
        return folder.equals(new File(System.getProperty("user.home")));
    }

    private String validateSourcesAndCopyTarget() {
        if (!NewPhpProjectWizardIterator.areAllStepsValid(this.descriptor)) {
            return null;
        }
        Boolean copyFiles = (Boolean)this.descriptor.getProperty("copySrcFiles");
        if (copyFiles == null || !copyFiles.booleanValue()) {
            return null;
        }
        LocalServer sources = this.configureProjectPanelVisual.getSourcesLocation();
        String sourcesSrcRoot = sources.getSrcRoot();
        LocalServer copyTarget = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        File normalized = FileUtil.normalizeFile((File)new File(copyTarget.getSrcRoot()));
        String cpTarget = normalized.getAbsolutePath();
        return Utils.validateSourcesAndCopyTarget(sourcesSrcRoot, cpTarget);
    }

    private String validateProjectDirectory() {
        File projectDirectory;
        File[] fsRoots = File.listRoots();
        if (fsRoots == null || fsRoots.length == 0) {
            return null;
        }
        File file = projectDirectory = this.configureProjectPanelVisual.isProjectFolderUsed() ? this.getProjectFolderFile() : this.getSourcesFolder();
        assert (projectDirectory != null);
        if (Arrays.asList(fsRoots).contains(projectDirectory)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderIsRoot");
        }
        if (projectDirectory.isDirectory() && projectDirectory.listFiles() == null) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderCannotBeRead");
        }
        return null;
    }

    private void warnIfNotEmpty(String location, String type) {
        File destFolder = new File(location);
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String warning = NbBundle.getMessage(ConfigureProjectPanel.class, (String)("MSG_" + type + "NotEmpty"));
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)warning);
        }
    }

    private void warnIfEmptySources(String location) {
        File destFolder = new File(location);
        assert (destFolder.isDirectory()) : "Sources directory must exist: " + location;
        File[] kids = destFolder.listFiles();
        assert (kids != null) : "Sources directory should have children: " + location;
        if (kids.length == 0) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesEmpty"));
        }
    }

    private void projectNameChanged() {
        String projectName = this.configureProjectPanelVisual.getProjectName();
        if (projectName.length() == 0) {
            return;
        }
        if (this.originalProjectName == null) {
            this.originalProjectName = projectName;
        }
        if (projectName.equals(this.originalProjectName)) {
            return;
        }
        this.adjustProjectFolder(this.originalProjectName, projectName);
        this.adjustSources(this.originalProjectName, projectName);
        this.originalProjectName = projectName;
    }

    private void adjustProjectFolder(String originalProjectName, String projectName) {
        File projectFolderFile = this.getProjectFolderFile();
        if (projectFolderFile == null) {
            return;
        }
        String projectFolder = projectFolderFile.getName();
        if (!originalProjectName.equals(projectFolder)) {
            return;
        }
        File newProjecFolder = new File(projectFolderFile.getParentFile(), projectName);
        this.configureProjectPanelVisual.setProjectFolder(newProjecFolder.getAbsolutePath());
    }

    private void adjustSources(String originalProjectName, String projectName) {
        LocalServer.ComboBoxModel model = (LocalServer.ComboBoxModel)this.configureProjectPanelVisual.getLocalServerModel();
        boolean fire = false;
        for (int i = 0; i < model.getSize(); ++i) {
            LocalServer ls = model.getElementAt(i);
            File src = new File(ls.getSrcRoot());
            if (!originalProjectName.equals(src.getName())) continue;
            File newSrc = new File(src.getParentFile(), projectName);
            ls.setSrcRoot(newSrc.getAbsolutePath());
            fire = true;
        }
        if (fire) {
            model.fireContentsChanged();
        }
    }

    private void sourceFolderChanged() {
        String sources = this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot();
        if (sources.length() == 0) {
            return;
        }
        if (sources.equals(this.originalSources)) {
            return;
        }
        this.adjustProjectName(this.originalSources, sources);
        String projectName = new File(sources).getName();
        String originalName = null;
        if (this.originalSources == null) {
            assert (this.getProjectFolderFile() != null);
            originalName = this.getProjectFolderFile().getName();
        } else {
            originalName = new File(this.originalSources).getName();
        }
        this.adjustProjectFolder(originalName, projectName);
        this.originalSources = sources;
    }

    private void adjustProjectName(String originalSources, String sources) {
        String projectName;
        String sourcesFolder;
        if (originalSources != null && !(sourcesFolder = new File(originalSources).getName()).equals(projectName = this.configureProjectPanelVisual.getProjectName())) {
            return;
        }
        String newProjectName = new File(sources).getName();
        this.configureProjectPanelVisual.setProjectName(newProjectName);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.removeListeners();
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                this.projectNameChanged();
                break;
            }
            case EXISTING: {
                this.sourceFolderChanged();
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.addListeners();
        this.fireChangeEvent();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }
}

