/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.netbeans.modules.php.project.ui.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.awt.StatusLineElementProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class PhpVersionStatusLineElementProvider
implements StatusLineElementProvider {
    public Component getStatusLineElement() {
        return PhpVersionStatusLineElementProvider.panelWithSeparator(PhpVersionLabel.getInstance());
    }

    private static Component panelWithSeparator(JLabel cell) {
        JSeparator separator = new JSeparator(1){
            private static final long serialVersionUID = 4857471448025818174L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(3, 3);
            }
        };
        separator.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)separator, "West");
        panel.add(cell);
        return panel;
    }

    private static final class PhpVersionLabel
    extends JLabel {
        private static final RequestProcessor RP = new RequestProcessor(PhpVersionLabel.class);
        private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
        private static final PhpVersionLabel INSTANCE = new PhpVersionLabel();
        private static final long serialVersionUID = -3407578574821051662L;

        private PhpVersionLabel() {
            this.addMouseListener(new MouseAdapterImpl());
            this.initMinDimension(this.getPhpVersionStrings());
        }

        public static PhpVersionLabel getInstance() {
            return INSTANCE;
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            String toolTipText = this.getToolTipText(event);
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(toolTipText);
            return new Point(-5 - jToolTip.getPreferredSize().width, 0);
        }

        private Collection<String> getPhpVersionStrings() {
            ArrayList<String> phpVersionStrings = new ArrayList<String>();
            for (PhpVersion phpVersion : PhpVersion.values()) {
                phpVersionStrings.add(phpVersion.getDisplayName());
            }
            return phpVersionStrings;
        }

        private void initMinDimension(Iterable<? extends String> maxStrings) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int minWidth = 0;
            for (String string : maxStrings) {
                minWidth = Math.max(minWidth, fontMetrics.stringWidth(string));
            }
            Border border = this.getBorder();
            Insets insets = border != null ? border.getBorderInsets(this) : NULL_INSETS;
            int minHeight = fontMetrics.getHeight() + insets.top + insets.bottom;
            this.setMinimumSize(new Dimension(minWidth += insets.left + insets.right, minHeight));
            this.setPreferredSize(new Dimension(minWidth, minHeight));
        }

        private void updatePhpVersion() {
            assert (EventQueue.isDispatchThread());
            JTextComponent comp = EditorRegistry.focusedComponent();
            if (comp != null) {
                this.showPhpVersion(comp.getDocument());
            } else {
                this.clear();
            }
        }

        private void showPhpVersion(Document document) {
            this.setText(Bundle.PhpVersionLabel_loading_message());
            RP.post(() -> {
                PhpProject phpProject;
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                PhpVersion phpVersion = null;
                String projectName = null;
                if (fileObject != null && (phpProject = PhpProjectUtils.getPhpProject(fileObject)) != null) {
                    projectName = phpProject.getName();
                    phpVersion = PhpLanguageProperties.forFileObject(fileObject).getPhpVersion();
                }
                this.showPhpVersionOnDispatchThread(projectName, phpVersion);
            });
        }

        private void showPhpVersionOnDispatchThread(String projectName, PhpVersion phpVersion) {
            if (EventQueue.isDispatchThread()) {
                this.showPhpVersion(projectName, phpVersion);
            } else {
                SwingUtilities.invokeLater(() -> this.showPhpVersion(projectName, phpVersion));
            }
        }

        private void showPhpVersion(String projectName, PhpVersion phpVersion) {
            assert (EventQueue.isDispatchThread());
            if (projectName != null && phpVersion != null) {
                this.setToolTipText(projectName);
                this.setText(phpVersion.getDisplayName());
                this.setVisible(true);
            } else {
                this.clear();
            }
        }

        private void clear() {
            assert (EventQueue.isDispatchThread());
            this.setToolTipText(null);
            this.setText("");
            this.setVisible(false);
        }

        private JList<PhpVersion> createPhpVersionList(JTextComponent component, FileObject fileObject) {
            JList<PhpVersion> phpVersionList = new JList<PhpVersion>();
            DefaultListModel<PhpVersion> model = new DefaultListModel<PhpVersion>();
            for (PhpVersion phpVersion : PhpVersion.values()) {
                model.addElement(phpVersion);
            }
            phpVersionList.setModel(model);
            PhpVersion phpVersion = PhpLanguageProperties.forFileObject(fileObject).getPhpVersion();
            phpVersionList.setSelectedValue(phpVersion, true);
            phpVersionList.setBorder(new LineBorder(Color.GRAY, 1));
            phpVersionList.addListSelectionListener(e -> this.savePhpVersion(component, (PhpVersion)phpVersionList.getSelectedValue()));
            return phpVersionList;
        }

        void showPhpVersionList() {
            JTextComponent component = EditorRegistry.focusedComponent();
            if (component == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)component.getDocument());
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            JList<PhpVersion> phpVersionList = this.createPhpVersionList(component, fileObject);
            Popup popup = this.getPopup(phpVersionList);
            popup.show();
        }

        private Popup getPopup(JList<PhpVersion> phpVersionList) {
            Point labelStart = this.getLocationOnScreen();
            int x = Math.min(labelStart.x, labelStart.x + this.getSize().width - phpVersionList.getPreferredSize().width);
            int y = labelStart.y - phpVersionList.getPreferredSize().height;
            final Popup popup = PopupFactory.getSharedInstance().getPopup(this, phpVersionList, x, y);
            AWTEventListener multicastListener = new AWTEventListener(){
                final /* synthetic */ PhpVersionLabel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof MouseEvent && ((MouseEvent)event).getClickCount() > 0) {
                        popup.hide();
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(multicastListener, 16L);
            return popup;
        }

        private void savePhpVersion(JTextComponent component, PhpVersion phpVersion) {
            RP.post(() -> {
                PhpProject phpProject;
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)component.getDocument());
                if (fileObject != null && (phpProject = PhpProjectUtils.getPhpProject(fileObject)) != null) {
                    PhpProjectProperties projectProperties = new PhpProjectProperties(phpProject);
                    projectProperties.setPhpVersion(phpVersion.name());
                    projectProperties.save();
                    SwingUtilities.invokeLater(() -> this.showPhpVersion(component.getDocument()));
                }
            });
        }

        static {
            EditorRegistry.addPropertyChangeListener(propertyChangeEvent -> PhpVersionLabel.getInstance().updatePhpVersion());
        }
    }

    private static class MouseAdapterImpl
    extends MouseAdapter {
        private MouseAdapterImpl() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PhpVersionLabel.getInstance().showPhpVersionList();
        }
    }
}

