/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.UpdateTriggerDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateTriggerRequest
extends BmcRequest<UpdateTriggerDetails> {
    private String triggerId;
    private UpdateTriggerDetails updateTriggerDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getTriggerId() {
        return this.triggerId;
    }

    public UpdateTriggerDetails getUpdateTriggerDetails() {
        return this.updateTriggerDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateTriggerDetails getBody$() {
        return this.updateTriggerDetails;
    }

    public Builder toBuilder() {
        return new Builder().triggerId(this.triggerId).updateTriggerDetails(this.updateTriggerDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",triggerId=").append(String.valueOf(this.triggerId));
        sb.append(",updateTriggerDetails=").append(String.valueOf((Object)this.updateTriggerDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTriggerRequest)) {
            return false;
        }
        UpdateTriggerRequest other = (UpdateTriggerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.triggerId, other.triggerId) && Objects.equals((Object)this.updateTriggerDetails, (Object)other.updateTriggerDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.triggerId == null ? 43 : this.triggerId.hashCode());
        result = result * 59 + (this.updateTriggerDetails == null ? 43 : this.updateTriggerDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateTriggerRequest, UpdateTriggerDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String triggerId = null;
        private UpdateTriggerDetails updateTriggerDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public Builder updateTriggerDetails(UpdateTriggerDetails updateTriggerDetails) {
            this.updateTriggerDetails = updateTriggerDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTriggerRequest o) {
            this.triggerId(o.getTriggerId());
            this.updateTriggerDetails(o.getUpdateTriggerDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTriggerRequest build() {
            UpdateTriggerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateTriggerDetails body) {
            this.updateTriggerDetails(body);
            return this;
        }

        public UpdateTriggerRequest buildWithoutInvocationCallback() {
            UpdateTriggerRequest request = new UpdateTriggerRequest();
            request.triggerId = this.triggerId;
            request.updateTriggerDetails = this.updateTriggerDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

