/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.RestoreDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RestoreDatabaseRequest
extends BmcRequest<RestoreDatabaseDetails> {
    private String databaseId;
    private RestoreDatabaseDetails restoreDatabaseDetails;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public RestoreDatabaseDetails getRestoreDatabaseDetails() {
        return this.restoreDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public RestoreDatabaseDetails getBody$() {
        return this.restoreDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).restoreDatabaseDetails(this.restoreDatabaseDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",restoreDatabaseDetails=").append(String.valueOf((Object)this.restoreDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestoreDatabaseRequest)) {
            return false;
        }
        RestoreDatabaseRequest other = (RestoreDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.restoreDatabaseDetails, (Object)other.restoreDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.restoreDatabaseDetails == null ? 43 : this.restoreDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreDatabaseRequest, RestoreDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private RestoreDatabaseDetails restoreDatabaseDetails = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder restoreDatabaseDetails(RestoreDatabaseDetails restoreDatabaseDetails) {
            this.restoreDatabaseDetails = restoreDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.restoreDatabaseDetails(o.getRestoreDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreDatabaseRequest build() {
            RestoreDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RestoreDatabaseDetails body) {
            this.restoreDatabaseDetails(body);
            return this;
        }

        public RestoreDatabaseRequest buildWithoutInvocationCallback() {
            RestoreDatabaseRequest request = new RestoreDatabaseRequest();
            request.databaseId = this.databaseId;
            request.restoreDatabaseDetails = this.restoreDatabaseDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

