/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbIormConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbName")
    private final String dbName;
    @JsonProperty(value="share")
    private final Integer share;
    @JsonProperty(value="flashCacheLimit")
    private final String flashCacheLimit;

    @Deprecated
    @ConstructorProperties(value={"dbName", "share", "flashCacheLimit"})
    public DbIormConfig(String dbName, Integer share, String flashCacheLimit) {
        this.dbName = dbName;
        this.share = share;
        this.flashCacheLimit = flashCacheLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbName() {
        return this.dbName;
    }

    public Integer getShare() {
        return this.share;
    }

    public String getFlashCacheLimit() {
        return this.flashCacheLimit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbIormConfig(");
        sb.append("super=").append(super.toString());
        sb.append("dbName=").append(String.valueOf(this.dbName));
        sb.append(", share=").append(String.valueOf(this.share));
        sb.append(", flashCacheLimit=").append(String.valueOf(this.flashCacheLimit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbIormConfig)) {
            return false;
        }
        DbIormConfig other = (DbIormConfig)((Object)o);
        return Objects.equals(this.dbName, other.dbName) && Objects.equals(this.share, other.share) && Objects.equals(this.flashCacheLimit, other.flashCacheLimit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbName == null ? 43 : this.dbName.hashCode());
        result = result * 59 + (this.share == null ? 43 : this.share.hashCode());
        result = result * 59 + (this.flashCacheLimit == null ? 43 : this.flashCacheLimit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbName")
        private String dbName;
        @JsonProperty(value="share")
        private Integer share;
        @JsonProperty(value="flashCacheLimit")
        private String flashCacheLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            this.__explicitlySet__.add("dbName");
            return this;
        }

        public Builder share(Integer share) {
            this.share = share;
            this.__explicitlySet__.add("share");
            return this;
        }

        public Builder flashCacheLimit(String flashCacheLimit) {
            this.flashCacheLimit = flashCacheLimit;
            this.__explicitlySet__.add("flashCacheLimit");
            return this;
        }

        public DbIormConfig build() {
            DbIormConfig model = new DbIormConfig(this.dbName, this.share, this.flashCacheLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbIormConfig model) {
            if (model.wasPropertyExplicitlySet("dbName")) {
                this.dbName(model.getDbName());
            }
            if (model.wasPropertyExplicitlySet("share")) {
                this.share(model.getShare());
            }
            if (model.wasPropertyExplicitlySet("flashCacheLimit")) {
                this.flashCacheLimit(model.getFlashCacheLimit());
            }
            return this;
        }
    }
}

