/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.ds;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.javaee.wildfly.config.ResourceConfigurationHelper;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.DatasourceType;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.Datasources;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.DsSecurityType;
import org.netbeans.modules.javaee.wildfly.config.ds.gen.PoolType;
import org.netbeans.modules.javaee.wildfly.config.xml.ConfigurationParser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DatasourceSupport {
    private static final String DS_RESOURCE_NAME = "jboss-ds.xml";
    private File resourceDir;
    private Datasources datasources;
    private File datasourcesFile;
    private FileObject datasourcesFO;

    public DatasourceSupport(File resourceDir) {
        assert (resourceDir != null) : "Resource directory can't be null";
        this.resourceDir = resourceDir;
        this.datasourcesFile = new File(resourceDir, DS_RESOURCE_NAME);
        this.ensureDatasourcesFOExists();
    }

    private void ensureDatasourcesFOExists() {
        if (!this.datasourcesFile.exists()) {
            return;
        }
        if (this.datasourcesFO == null || !this.datasourcesFO.isValid()) {
            this.datasourcesFO = FileUtil.toFileObject((File)this.datasourcesFile);
            assert (this.datasourcesFO != null);
            this.datasourcesFO.addFileChangeListener((FileChangeListener)new DatasourceFileListener());
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        try {
            if (this.datasourcesFile.exists()) {
                return ConfigurationParser.INSTANCE.listDatasources(FileUtil.toFileObject((File)this.datasourcesFile));
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Wrong configuration in " + this.datasourcesFile, (Throwable)ex);
        }
        HashSet<Datasource> projectDS = new HashSet<Datasource>();
        Datasources dss = this.getDatasourcesGraph(false);
        if (dss != null) {
            DatasourceType[] ltxds = this.datasources.getDatasource();
            for (int i = 0; i < ltxds.length; ++i) {
                if (ltxds[i].getJndiName().length() <= 0) continue;
                projectDS.add(new WildflyDatasource(ltxds[i].getJndiName(), ltxds[i].getConnectionUrl(), ltxds[i].getSecurity().getUserName(), ltxds[i].getSecurity().getPassword(), ltxds[i].getDriverClass()));
            }
        }
        return projectDS;
    }

    private synchronized Datasources getDatasourcesGraph(boolean create) {
        block9: {
            try {
                if (this.datasourcesFile.exists()) {
                    try {
                        if (this.datasources == null) {
                            this.datasources = Datasources.createGraph(this.datasourcesFile);
                        }
                        break block9;
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException ioe) {}
                    break block9;
                }
                if (create) {
                    this.datasources = new Datasources();
                    ResourceConfigurationHelper.writeFile(this.datasourcesFile, this.datasources);
                    this.ensureDatasourcesFOExists();
                } else {
                    this.datasources = null;
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.datasources;
    }

    public WildflyDatasource createDatasource(String jndiName, String url, String username, String password, String driver) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException {
        WildflyDatasource ds = this.modifyDSResource(new DSResourceModifier(jndiName, url, username, password, driver){

            @Override
            WildflyDatasource modify(Datasources datasources) throws DatasourceAlreadyExistsException {
                DatasourceType[] ltxds = datasources.getDatasource();
                for (int i = 0; i < ltxds.length; ++i) {
                    String jndiName = ltxds[i].getJndiName();
                    if (!this.rawName.equals(WildflyDatasource.getRawName(jndiName))) continue;
                    WildflyDatasource ds = new WildflyDatasource(jndiName, ltxds[i].getConnectionUrl(), ltxds[i].getSecurity().getUserName(), ltxds[i].getSecurity().getPassword(), ltxds[i].getDriverClass());
                    throw new DatasourceAlreadyExistsException((Datasource)ds);
                }
                DatasourceType lds = new DatasourceType();
                lds.setJndiName(this.rawName);
                lds.setConnectionUrl(this.url);
                lds.setDriverClass(this.driver);
                DsSecurityType security = new DsSecurityType();
                security.setUserName(this.username);
                security.setPassword(this.password);
                lds.setSecurity(security);
                PoolType pool = new PoolType();
                pool.setMinPoolSize(5L);
                pool.setMaxPoolSize(20L);
                lds.setPool(pool);
                datasources.addDatasource(lds);
                return new WildflyDatasource(this.rawName, this.url, this.username, this.password, this.driver);
            }
        });
        return ds;
    }

    private WildflyDatasource modifyDSResource(DSResourceModifier modifier) throws ConfigurationException, DatasourceAlreadyExistsException {
        WildflyDatasource ds = null;
        try {
            this.ensureResourceDirExists();
            this.ensureDatasourcesFileExists();
            DataObject datasourcesDO = DataObject.find((FileObject)this.datasourcesFO);
            EditorCookie editor = (EditorCookie)datasourcesDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Datasources newDatasources = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newDatasources = Datasources.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Datasources oldDatasources = this.getDatasourcesGraph(true);
                if (oldDatasources == null) {
                    throw new ConfigurationException(NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_datasourcesXmlCannotParse", (Object)DS_RESOURCE_NAME));
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_datasourcesXmlNotValid", (Object)DS_RESOURCE_NAME), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                newDatasources = oldDatasources;
            }
            ds = modifier.modify(newDatasources);
            boolean modified = datasourcesDO.isModified();
            ResourceConfigurationHelper.replaceDocument(doc, newDatasources);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)datasourcesDO.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.datasources = newDatasources;
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(DatasourceSupport.class, (String)"MSG_CannotUpdateFile", (Object)this.datasourcesFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
        return ds;
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
    }

    private void ensureDatasourcesFileExists() {
        if (!this.datasourcesFile.exists()) {
            this.getDatasourcesGraph(true);
        }
    }

    private class DatasourceFileListener
    extends FileChangeAdapter {
        private DatasourceFileListener() {
        }

        public void fileChanged(FileEvent fe) {
            assert (fe.getSource() == DatasourceSupport.this.datasourcesFO) : fe.getSource() + ":" + DatasourceSupport.access$000(DatasourceSupport.this);
            DatasourceSupport.this.datasources = null;
        }

        public void fileDeleted(FileEvent fe) {
            assert (((FileObject)fe.getSource()).getPath().equals(DatasourceSupport.this.datasourcesFO.getPath())) : fe.getSource() + ":" + DatasourceSupport.access$000(DatasourceSupport.this);
            DatasourceSupport.this.datasources = null;
        }
    }

    private abstract class DSResourceModifier {
        String rawName;
        String url;
        String username;
        String password;
        String driver;

        DSResourceModifier(String jndiName, String url, String username, String password, String driver) {
            this.rawName = WildflyDatasource.getRawName(jndiName);
            this.url = url;
            this.username = username;
            this.password = password;
            this.driver = driver;
        }

        abstract WildflyDatasource modify(Datasources var1) throws DatasourceAlreadyExistsException;
    }
}

