/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;

public class ApplicationPropertiesGenerator {
    private static final String COMMENT_START = "# ";
    private static final String NEW_LINE = "\n";
    final PropertiesGenerator propertiesGenerator;

    public ApplicationPropertiesGenerator(PropertiesGenerator propertiesGenerator) {
        this.propertiesGenerator = propertiesGenerator;
    }

    public String getApplicationPropertiesString() {
        StringBuilder sb = new StringBuilder();
        this.appendApplicationProperties(sb);
        this.separatePropertiesSections(sb);
        this.appendBootstrapProperties(sb);
        return sb.toString();
    }

    private void separatePropertiesSections(StringBuilder sb) {
        if (!this.propertiesGenerator.getApplication().isEmpty()) {
            sb.append(NEW_LINE);
        }
    }

    private void appendApplicationProperties(StringBuilder sb) {
        this.appendComments(sb, "Generated application.properties", "Uncomment following line when running inside Oracle Cloud", "oci.config.instance-principal.enabled=true");
        this.appendDateComment(sb);
        this.appendProperties(sb, new TreeMap<String, String>(this.propertiesGenerator.getApplication()));
    }

    private void appendBootstrapProperties(StringBuilder sb) {
        this.appendComments(sb, "Generated bootstrap.properties");
        this.appendProperties(sb, new TreeMap<String, String>(this.propertiesGenerator.getBootstrap()));
    }

    private void appendComments(StringBuilder sb, String ... comments) {
        for (String comment : comments) {
            sb.append(COMMENT_START).append(comment).append(NEW_LINE);
        }
    }

    private void appendDateComment(StringBuilder sb) {
        sb.append(COMMENT_START).append(new Date()).append(NEW_LINE);
    }

    private void appendProperties(StringBuilder sb, Map<String, String> sortedProperties) {
        String groupName = null;
        for (Map.Entry<String, String> entry : sortedProperties.entrySet()) {
            if (entry.getKey() == null) continue;
            String currentGroupName = this.getCurrentPropertyGroupName(entry);
            if (!currentGroupName.equals(groupName)) {
                groupName = currentGroupName;
                sb.append(NEW_LINE);
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(NEW_LINE);
        }
    }

    private String getCurrentPropertyGroupName(Map.Entry<String, String> entry) {
        int dotIndex = entry.getKey().indexOf(46);
        return dotIndex > -1 ? entry.getKey().substring(0, dotIndex) : entry.getKey();
    }
}

