/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Collection;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.memorylint.RuleRegistry;
import org.netbeans.modules.profiler.heapwalk.memorylint.StringHelper;

public class MemoryLint {
    private BoundedRangeModel progress;
    private Heap heap;
    private HierarchicalModel globalProgress;
    private StringBuffer results = new StringBuffer();
    private StringHelper stringHelper;
    private volatile boolean interrupted;

    public MemoryLint(Heap heap) {
        this.heap = heap;
        this.globalProgress = new HierarchicalModel(1, 1000);
    }

    public BoundedRangeModel getGlobalProgress() {
        return this.globalProgress;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public boolean isInterruped() {
        return this.interrupted;
    }

    public String getResults() {
        return this.results.toString();
    }

    public String getRootIncommingString(Instance in) {
        Instance from;
        String temp = null;
        while ((from = in.getNearestGCRootPointer()) != null) {
            String rName = this.getFullName(in, from);
            if (temp == null) {
                temp = "<< " + rName;
            }
            if (!rName.startsWith("java.") && !rName.startsWith("javax.")) {
                return rName;
            }
            if (from.isGCRoot()) break;
            in = from;
        }
        return temp == null ? "unknown" : temp;
    }

    public StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = new StringHelper(this.heap);
        }
        return this.stringHelper;
    }

    public void appendResults(String s) {
        this.results.append(s).append('\n');
    }

    public static Collection<Rule> createRules() {
        return RuleRegistry.getRegisteredRules();
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void process(Collection<Rule> rules) {
        int count = rules.size();
        this.globalProgress.setSteps(count);
        for (Rule r : rules) {
            r.prepare(this);
            this.progress = this.globalProgress.getNextDelegate();
            this.results.append(r.resultsHeader());
            r.perform();
            this.results.append("<hr>");
            if (!this.isInterruped()) continue;
            break;
        }
    }

    BoundedRangeModel getProgress() {
        return this.progress;
    }

    private String getFullName(Instance to, Instance from) {
        ObjectFieldValue fv = this.getInField(to, from);
        if (fv == null) {
            return from.getJavaClass().getName();
        }
        if (fv.getField().isStatic()) {
            return fv.getField().getDeclaringClass().getName() + ";" + fv.getField().getName();
        }
        return from.getJavaClass().getName() + ":" + fv.getField().getName();
    }

    private ObjectFieldValue getInField(Instance to, Instance from) {
        List vals = from.getFieldValues();
        for (FieldValue fv : vals) {
            if (!(fv instanceof ObjectFieldValue) || !to.equals((Object)((ObjectFieldValue)fv).getInstance())) continue;
            return (ObjectFieldValue)fv;
        }
        if (from.getJavaClass().getName().equals("java.lang.Class")) {
            JavaClass cls = this.heap.getJavaClassByID(from.getInstanceId());
            vals = cls.getStaticFieldValues();
            for (FieldValue fv : vals) {
                if (!(fv instanceof ObjectFieldValue) || !to.equals((Object)((ObjectFieldValue)fv).getInstance())) continue;
                return (ObjectFieldValue)fv;
            }
        }
        return null;
    }

    private static class HierarchicalModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        BoundedRangeModel delegate = new DefaultBoundedRangeModel(0, 0, 0, 1);
        int each;
        int step = -1;

        HierarchicalModel(int steps, int each) {
            super(0, 0, 0, steps * each);
            this.each = each;
            this.delegate.addChangeListener(this);
        }

        public void setSteps(int steps) {
            this.setRangeProperties(0, 0, 0, steps * this.each, false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateValue();
        }

        BoundedRangeModel getNextDelegate() {
            ++this.step;
            this.delegate.setRangeProperties(0, 0, 0, 1, false);
            this.updateValue();
            return this.delegate;
        }

        private void updateValue() {
            int val = this.getValue();
            this.setValue(this.step * this.each + this.each * this.delegate.getValue() / this.delegate.getMaximum());
        }
    }
}

