/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.openide.util.Exceptions;

final class Utils {
    Utils() {
    }

    static String getFontName(Instance instance, Heap heap) {
        Instance font2D;
        Instance font2DHandle;
        String name = Utils.getFieldString(instance, "name");
        if (name == null && (font2DHandle = (Instance)instance.getValueOfField("font2DHandle")) != null && (font2D = (Instance)font2DHandle.getValueOfField("font2D")) != null && (name = Utils.getFieldString(instance, "fullName")) == null) {
            name = Utils.getFieldString(instance, "nativeFontName");
        }
        return name;
    }

    static String getFieldString(Instance instance, String field) {
        Object _s = instance.getValueOfField(field);
        if (_s instanceof Instance) {
            try {
                Class<?> proxy = Class.forName("org.netbeans.lib.profiler.heap.HprofProxy");
                Method method = proxy.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(proxy, _s);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    static abstract class View<T extends InstanceBuilder>
    extends DetailsProvider.View
    implements Scrollable {
        private static final int DASH_SIZE = 20;
        private final int margin;
        private final boolean pattern;
        private final boolean stretch;
        private Component component;
        private JPanel glassPane;

        View(Instance instance, Heap heap) {
            this(10, true, false, instance, heap);
        }

        View(int margin, boolean pattern, boolean stretch, Instance instance, Heap heap) {
            super(instance, heap);
            this.margin = margin;
            this.pattern = pattern;
            this.stretch = stretch;
        }

        protected T getBuilder(Instance instance, Heap heap) {
            return null;
        }

        protected Component getComponent(T builder) {
            return null;
        }

        protected void setupGlassPane(JPanel glassPane) {
        }

        @Override
        protected final void computeView(Instance instance, Heap heap) {
            T builder = this.getBuilder(instance, heap);
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ InstanceBuilder val$builder;
                final /* synthetic */ View this$0;
                {
                    this.val$builder = instanceBuilder;
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.removeAll();
                    this.this$0.component = this.val$builder == null ? null : this.this$0.getComponent(this.val$builder);
                    if (this.this$0.component != null) {
                        this.this$0.component.setVisible(true);
                        if (this.this$0.stretch) {
                            this.this$0.add(this.this$0.component, "Center");
                        } else {
                            this.this$0.glassPane = new JPanel(null){

                                @Override
                                public Point getToolTipLocation(MouseEvent event) {
                                    Point p = event.getPoint();
                                    p.translate(15, 15);
                                    return p;
                                }
                            };
                            this.this$0.glassPane.setOpaque(false);
                            this.this$0.glassPane.addMouseListener(new MouseAdapter(){});
                            this.this$0.glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
                            this.this$0.glassPane.addKeyListener(new KeyAdapter(){});
                            this.this$0.setupGlassPane(this.this$0.glassPane);
                            this.this$0.add(this.this$0.glassPane);
                            this.this$0.setLayout(null);
                            this.this$0.add(this.this$0.component);
                        }
                        if (this.this$0.component.getWidth() == 0 || this.this$0.component.getHeight() == 0) {
                            this.this$0.component.setSize(this.this$0.component.getPreferredSize());
                        }
                        Dimension d = this.this$0.component.getSize();
                        d.width += this.this$0.margin;
                        d.height += this.this$0.margin;
                        this.this$0.setPreferredSize(d);
                        this.this$0.setBackground(UIUtils.getProfilerResultsBackground());
                        this.this$0.setForeground(UIUtils.getDarker((Color)this.this$0.getBackground()));
                    } else {
                        this.this$0.component = new JLabel(Bundle.Utils_NoDetails(), 0);
                        this.this$0.component.setEnabled(false);
                        this.this$0.add(this.this$0.component, "Center");
                    }
                    this.this$0.revalidate();
                    this.this$0.doLayout();
                    this.this$0.repaint();
                }
            });
        }

        @Override
        public void doLayout() {
            if (this.getLayout() != null) {
                super.doLayout();
            } else {
                Dimension size = this.getSize();
                Dimension comp = this.component.getSize();
                int x = comp.width >= size.width ? 0 : (size.width - comp.width) / 2;
                int y = comp.height >= size.height ? 0 : (size.height - comp.height) / 2;
                this.component.move(x, y);
                this.glassPane.setBounds(this.component.getBounds());
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.pattern || this.component == null) {
                super.paintComponent(g);
            } else {
                int x = 0;
                int w = this.getWidth();
                int h = this.getHeight();
                for (int y = 0; y <= h; y += 20) {
                    boolean flag;
                    boolean bl = flag = y / 20 % 2 == 0;
                    while (x <= w) {
                        g.setColor(flag ? this.getBackground() : this.getForeground());
                        g.fillRect(x, y, 20, 20);
                        x += 20;
                        flag = !flag;
                    }
                    x = 0;
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            Container parent = this.getParent();
            if (!(parent instanceof JViewport)) {
                return 50;
            }
            return (int)((float)((JViewport)parent).getHeight() * 0.95f);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container parent = this.getParent();
            if (!(parent instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().height < ((JViewport)parent).getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = this.getParent();
            if (!(parent instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().width < ((JViewport)parent).getWidth();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }

    static abstract class InstanceBuilder<T> {
        InstanceBuilder(Instance instance, Heap heap) {
        }

        protected void setupInstance(T instance) {
        }

        protected T createInstanceImpl() {
            return null;
        }

        final T createInstance() {
            T instance = this.createInstanceImpl();
            if (instance != null) {
                this.setupInstance(instance);
            }
            return instance;
        }
    }

    static final class JPopupMenuImpl
    extends JPopupMenu {
        JPopupMenuImpl() {
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public Component add(Component comp) {
            if (comp instanceof JComponent) {
                ((JComponent)comp).setOpaque(false);
            }
            return super.add(comp);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.repaint();
                }
            });
        }
    }

    static final class PlaceholderPanel
    extends JPanel {
        private static final Color LINE = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        private final JLabel label;

        PlaceholderPanel(String className) {
            super(null);
            this.putClientProperty("className", className);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(LINE));
            this.label = new JLabel(BrowserUtils.getSimpleType(className), 0);
            this.label.setOpaque(true);
        }

        @Override
        public void doLayout() {
            Dimension s = this.getSize();
            Dimension p = this.label.getPreferredSize();
            int x = (s.width - p.width) / 2;
            int y = (s.height - p.height) / 2;
            this.label.setBounds(x, y, p.width, p.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(LINE);
            g.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
            Point p = this.label.getLocation();
            g.translate(p.x, p.y);
            this.label.paint(g);
            g.translate(-p.x, -p.y);
        }
    }

    static final class PlaceholderIcon
    implements Icon {
        private final int width;
        private final int height;

        PlaceholderIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(Color.BLACK);
            g.drawLine(x, y, x + this.width - 1, y + this.height - 1);
            g.drawLine(x, y + this.height - 1, x + this.width - 1, y);
        }
    }
}

