/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.docker.editor.lexer.DockerfileLexer;
import org.netbeans.modules.docker.editor.parser.Command;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.Parameters;

public enum DockerfileTokenId implements TokenId
{
    ERROR(null, "error"),
    WHITESPACE(null, "whitespace"),
    IDENTIFIER(null, "identifier"),
    STRING_LITERAL(null, "string"),
    NUMBER_LITERAL(null, "number"),
    LINE_COMMENT(null, "comment"),
    LBRACKET("[", "separator"),
    RBRACKET("]", "separator"),
    COMMA(",", "separator"),
    ESCAPE("\\", "separator"),
    ADD(Command.ADD),
    ARG(Command.ARG),
    CMD(Command.CMD),
    COPY(Command.COPY),
    ENTRYPOINT(Command.ENTRYPOINT),
    ENV(Command.ENV),
    EXPOSE(Command.EXPOSE),
    FROM(Command.FROM),
    LABEL(Command.LABEL),
    MAINTAINER(Command.MAINTAINER),
    ONBUILD(Command.ONBUILD),
    RUN(Command.RUN),
    STOPSIGNAL(Command.STOPSIGNAL),
    USER(Command.USER),
    VOLUME(Command.VOLUME),
    WORKDIR(Command.WORKDIR);

    private final String fixedText;
    private final String primaryCategory;
    private final boolean onBuildSupported;
    private static final Language<DockerfileTokenId> language;

    private DockerfileTokenId(String fixedText, String primaryCategory) {
        this(fixedText, primaryCategory, false);
    }

    private DockerfileTokenId(Command cmd) {
        this(cmd.getName(), "keyword", cmd.isOnBuildSupported());
    }

    private DockerfileTokenId(String fixedText, String primaryCategory, boolean onBuildSupported) {
        Parameters.notNull((CharSequence)"primaryCategory", (Object)primaryCategory);
        this.fixedText = fixedText;
        this.primaryCategory = primaryCategory;
        this.onBuildSupported = onBuildSupported;
    }

    @CheckForNull
    public String fixedText() {
        return this.fixedText;
    }

    @NonNull
    public String primaryCategory() {
        return this.primaryCategory;
    }

    public boolean isKeyword() {
        return "keyword".equals(this.primaryCategory);
    }

    boolean isOnBuildSupported() {
        return this.onBuildSupported;
    }

    @NonNull
    public static Language<DockerfileTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<DockerfileTokenId>(){

            @NonNull
            protected String mimeType() {
                return "text/x-dockerfile";
            }

            @NonNull
            protected Collection<DockerfileTokenId> createTokenIds() {
                return EnumSet.allOf(DockerfileTokenId.class);
            }

            protected Map<String, Collection<DockerfileTokenId>> createTokenCategories() {
                HashMap<String, Collection<DockerfileTokenId>> cats = new HashMap<String, Collection<DockerfileTokenId>>();
                EnumSet<DockerfileTokenId> lits = EnumSet.of(STRING_LITERAL, NUMBER_LITERAL);
                cats.put("literal", lits);
                EnumSet<DockerfileTokenId> kws = EnumSet.noneOf(DockerfileTokenId.class);
                kws.add(ADD);
                kws.add(ARG);
                kws.add(CMD);
                kws.add(COPY);
                kws.add(ENTRYPOINT);
                kws.add(ENV);
                kws.add(EXPOSE);
                kws.add(FROM);
                kws.add(LABEL);
                kws.add(MAINTAINER);
                kws.add(ONBUILD);
                kws.add(RUN);
                kws.add(STOPSIGNAL);
                kws.add(USER);
                kws.add(VOLUME);
                kws.add(WORKDIR);
                cats.put("keyword", kws);
                return cats;
            }

            protected Lexer<DockerfileTokenId> createLexer(LexerRestartInfo<DockerfileTokenId> info) {
                return new DockerfileLexer(info);
            }

            protected LanguageEmbedding<?> embedding(Token<DockerfileTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }
        }.language();
    }
}

