/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.ui.wizard.InstanceDialog;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class InstancePropertiesVisual
extends JPanel {
    private NotificationLineSupport msgs;
    private JButton addButton;
    private JCheckBox autoSyncCheckBox;
    private JLabel autoSyncLabel;
    private JSpinner autoSyncSpinner;
    private JProgressBar checkProgress;
    private JLabel nameLabel;
    private JTextField nameTxt;
    private JButton proxyButton;
    private JLabel urlLabel;
    private JTextField urlTxt;

    public InstancePropertiesVisual() {
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstancePropertiesVisual.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstancePropertiesVisual.this.check();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.nameTxt.getDocument().addDocumentListener(l);
        this.urlTxt.getDocument().addDocumentListener(l);
        this.checkProgress.setVisible(false);
    }

    void init(NotificationLineSupport msgs, JButton addButton) {
        assert (msgs != null);
        this.msgs = msgs;
        this.addButton = addButton;
        this.check();
    }

    void showChecking() {
        this.checkProgress.setVisible(true);
        this.nameTxt.setEnabled(false);
        this.urlTxt.setEnabled(false);
        this.autoSyncCheckBox.setEnabled(false);
        this.autoSyncSpinner.setEnabled(false);
        this.proxyButton.setEnabled(false);
    }

    void checkFailed(String explanation) {
        this.msgs.setErrorMessage(explanation);
        this.checkProgress.setVisible(false);
        this.nameTxt.setEnabled(true);
        this.urlTxt.setEnabled(true);
        this.autoSyncCheckBox.setEnabled(true);
        this.autoSyncSpinner.setEnabled(this.autoSyncCheckBox.isSelected());
        this.proxyButton.setEnabled(true);
        this.urlTxt.requestFocusInWindow();
    }

    String getDisplayName() {
        return this.nameTxt.getText().trim();
    }

    String getUrl() {
        return this.urlTxt.getText().trim();
    }

    int getSyncTime() {
        return this.autoSyncCheckBox.isSelected() ? (Integer)this.autoSyncSpinner.getValue() : 0;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTxt = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTxt = new JTextField();
        this.autoSyncCheckBox = new JCheckBox();
        this.autoSyncSpinner = new JSpinner();
        this.autoSyncLabel = new JLabel();
        this.proxyButton = new JButton();
        this.checkProgress = new JProgressBar();
        this.nameLabel.setLabelFor(this.nameTxt);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Name"));
        this.urlLabel.setLabelFor(this.urlTxt);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Url"));
        this.urlTxt.setText(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.urlTxt.text"));
        this.autoSyncCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoSyncCheckBox, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_AutoSync"));
        this.autoSyncCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoSyncCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePropertiesVisual.this.autoSyncCheckBoxActionPerformed(evt);
            }
        });
        this.autoSyncSpinner.setModel(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        this.autoSyncSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InstancePropertiesVisual.this.autoSyncSpinnerStateChanged(evt);
            }
        });
        this.autoSyncLabel.setLabelFor(this.autoSyncSpinner);
        Mnemonics.setLocalizedText((JLabel)this.autoSyncLabel, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_AutoSyncMinutes"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(InstancePropertiesVisual.class, (String)"LBL_Proxy"));
        this.proxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstancePropertiesVisual.this.proxyButtonActionPerformed(evt);
            }
        });
        this.checkProgress.setIndeterminate(true);
        this.checkProgress.setString(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.checkProgress.string"));
        this.checkProgress.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkProgress, -1, 439, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.autoSyncCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSyncSpinner, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSyncLabel)).addComponent(this.proxyButton).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.urlLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.urlTxt, -1, 382, Short.MAX_VALUE).addComponent(this.nameTxt, -1, 382, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoSyncCheckBox).addComponent(this.autoSyncSpinner, -2, -1, -2).addComponent(this.autoSyncLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proxyButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkProgress, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.nameTxt.AccessibleContext.accessibleDescription"));
        this.urlTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.urlTxt.AccessibleContext.accessibleDescription"));
        this.autoSyncCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.autoSyncCheckBox.AccessibleContext.accessibleDescription"));
        this.autoSyncSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.autoSyncSpinner.AccessibleContext.accessibleDescription"));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.proxyButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstancePropertiesVisual.AccessibleContext.accessibleDescription"));
    }

    private void proxyButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void autoSyncSpinnerStateChanged(ChangeEvent evt) {
        this.check();
    }

    private void autoSyncCheckBoxActionPerformed(ActionEvent evt) {
        this.autoSyncSpinner.setEnabled(this.autoSyncCheckBox.isSelected());
        this.check();
    }

    private void check() {
        this.addButton.setEnabled(false);
        String name = this.getDisplayName();
        String url = this.getUrl();
        if (name.length() == 0) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_EmptyName"));
            return;
        }
        if (HudsonManager.getInstanceByName((String)name) != null) {
            this.msgs.setErrorMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_ExistName"));
            return;
        }
        if (url.length() == 0 || url.endsWith("//")) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_EmptyUrl"));
            return;
        }
        if (!url.endsWith("/")) {
            this.msgs.setInformationMessage(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstanceDialog.end_with_slash"));
            return;
        }
        try {
            URL u = new URL(url);
            if (!u.getProtocol().matches("https?")) {
                this.msgs.setErrorMessage(NbBundle.getMessage(InstancePropertiesVisual.class, (String)"InstanceDialog.http_protocol"));
                return;
            }
        }
        catch (MalformedURLException x) {
            this.msgs.setErrorMessage(x.getLocalizedMessage());
            return;
        }
        if (HudsonManager.getInstance((String)url) != null) {
            this.msgs.setErrorMessage(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_ExistUrl"));
            return;
        }
        this.msgs.clearMessages();
        this.addButton.setEnabled(true);
    }
}

