/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.testrunner.JavaUtils;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.maven.Bundle;
import org.netbeans.modules.testng.maven.TestNGActionsProvider;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.spi.XMLSuiteSupport;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class MavenTestNGSupport
extends TestNGSupportImplementation {
    private static final Logger LOGGER = Logger.getLogger(MavenTestNGSupport.class.getName());
    private static final Set<TestNGSupport.Action> SUPPORTED_ACTIONS;

    public boolean isSupportEnabled(FileObject[] activatedFOs) {
        return JavaUtils.isSupportEnabled(NbMavenProject.class, (FileObject[])activatedFOs);
    }

    public boolean isActionSupported(TestNGSupport.Action action, Project p) {
        return p != null && p.getLookup().lookup(NbMavenProject.class) != null && SUPPORTED_ACTIONS.contains(action);
    }

    public void configureProject(FileObject createdFile) {
        ClassPath cp = ClassPath.getClassPath((FileObject)createdFile, (String)"classpath/compile");
        FileObject ng = cp.findResource("org.testng.annotations.Test");
        if (ng == null) {
            final Project p = FileOwnerQuery.getOwner((FileObject)createdFile);
            FileObject pom = p.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
                final /* synthetic */ MavenTestNGSupport this$0;
                {
                    this.this$0 = this$0;
                }

                public void performOperation(POMModel model) {
                    String groupID = "org.testng";
                    String artifactID = "testng";
                    if (!this.this$0.hasEffectiveDependency(groupID, artifactID, (NbMavenProject)p.getLookup().lookup(NbMavenProject.class))) {
                        this.this$0.fixJUnitDependency(model, (NbMavenProject)p.getLookup().lookup(NbMavenProject.class));
                        Dependency dep = ModelUtils.checkModelDependency((POMModel)model, (String)groupID, (String)artifactID, (boolean)true);
                        dep.setVersion("6.8.1");
                        dep.setScope("test");
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
            RequestProcessor RP = new RequestProcessor("Configure TestNG project task", 1, true);
            RP.post(new Runnable(){
                final /* synthetic */ MavenTestNGSupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    ((NbMavenProject)p.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(true);
                }
            });
        }
    }

    private boolean hasEffectiveDependency(String groupId, String artifactId, NbMavenProject prj) {
        MavenProject mp = prj.getMavenProject();
        ArrayList dl = new ArrayList();
        dl.addAll(mp.getDependencies());
        org.apache.maven.model.DependencyManagement dm = mp.getDependencyManagement();
        if (dm != null) {
            dl.addAll(dm.getDependencies());
        }
        for (org.apache.maven.model.Dependency d : dl) {
            if (!groupId.equals(d.getGroupId()) || !artifactId.equals(d.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private void fixJUnitDependency(POMModel model, NbMavenProject prj) {
        Dependency managed;
        String junitGroupID = "junit";
        String junitArtifactID = "junit";
        MavenProject mp = prj.getMavenProject();
        ArrayList dl = new ArrayList();
        dl.addAll(mp.getDependencies());
        dl.add(null);
        org.apache.maven.model.DependencyManagement dm = mp.getDependencyManagement();
        if (dm != null) {
            dl.addAll(dm.getDependencies());
        }
        boolean has3xJUnit = false;
        boolean hasJUnit = false;
        boolean hasManaged = false;
        boolean inManagedList = false;
        for (org.apache.maven.model.Dependency d : dl) {
            if (d == null) {
                inManagedList = true;
                continue;
            }
            if (!junitGroupID.equals(d.getGroupId()) || !junitArtifactID.equals(d.getArtifactId())) continue;
            hasJUnit = true;
            if (inManagedList) {
                hasManaged = true;
            }
            if (d.getVersion() == null || !d.getVersion().startsWith("3.")) continue;
            has3xJUnit = true;
        }
        org.netbeans.modules.maven.model.pom.Project pomProject = model.getProject();
        DependencyManagement dependencyManagement = pomProject.getDependencyManagement();
        if (hasManaged && dependencyManagement != null && (managed = dependencyManagement.findDependencyById(junitGroupID, junitArtifactID, null)) != null) {
            if (has3xJUnit) {
                LOGGER.log(Level.FINE, Bundle.remove_junit3_when_adding_testng());
                dependencyManagement.removeDependency(managed);
            } else {
                Dependency dep = pomProject.getModel().getFactory().createDependency();
                dep.setGroupId(junitGroupID);
                dep.setArtifactId(junitArtifactID);
                dep.setVersion("4.10");
                pomProject.addDependency(dep);
            }
            return;
        }
        Dependency unmanaged = pomProject.findDependencyById(junitGroupID, junitArtifactID, null);
        if (unmanaged != null) {
            if (unmanaged.getVersion() != null) {
                LOGGER.log(Level.FINE, Bundle.remove_junit3_when_adding_testng());
                pomProject.removeDependency(unmanaged);
            }
        } else if (has3xJUnit || hasManaged) {
            Dependency dep = pomProject.getModel().getFactory().createDependency();
            dep.setGroupId(junitGroupID);
            dep.setArtifactId(junitArtifactID);
            dep.setVersion("4.10");
            pomProject.addDependency(dep);
        }
    }

    public TestNGSupportImplementation.TestExecutor createExecutor(Project p) {
        return new MavenExecutor(p);
    }

    static {
        HashSet<TestNGSupport.Action> s = new HashSet<TestNGSupport.Action>();
        s.add(TestNGSupport.Action.RUN_TESTSUITE);
        s.add(TestNGSupport.Action.DEBUG_TESTSUITE);
        SUPPORTED_ACTIONS = Collections.unmodifiableSet(s);
    }

    private static class MavenExecutor
    implements TestNGSupportImplementation.TestExecutor {
        private static final String failedConfPath = "target/surefire-reports/testng-failed.xml";
        private static final String failedConfPath2 = "target/surefire-reports/testng-native-results/testng-failed.xml";
        private static final String resultsPath = "target/surefire-reports/testng-native-results/testng-results.xml";
        private Project p;

        public MavenExecutor(Project p) {
            this.p = p;
        }

        public boolean hasFailedTests() {
            return this.getFailedConfig() != null;
        }

        public void execute(TestNGSupport.Action action, TestConfig config) throws IOException {
            RunConfig rc = TestNGSupport.Action.DEBUG_TESTSUITE.equals((Object)action) || TestNGSupport.Action.DEBUG_TEST.equals((Object)action) || TestNGSupport.Action.DEBUG_TESTMETHOD.equals((Object)action) ? new TestNGActionsProvider().createConfigForDefaultAction("testng.debug", this.p, Lookups.singleton((Object)config.getTest())) : new TestNGActionsProvider().createConfigForDefaultAction("testng.test", this.p, Lookups.singleton((Object)config.getTest()));
            rc.setProperty("netbeans.testng.action", "true");
            if (config.doRerun()) {
                this.copy(this.getFailedConfig());
            } else {
                File f = null;
                f = TestNGSupport.Action.RUN_TESTSUITE.equals((Object)action) || TestNGSupport.Action.DEBUG_TESTSUITE.equals((Object)action) ? FileUtil.toFile((FileObject)config.getTest()) : XMLSuiteSupport.createSuiteforMethod((File)new File(System.getProperty("java.io.tmpdir")), (String)ProjectUtils.getInformation((Project)this.p).getDisplayName(), (String)config.getPackageName(), (String)config.getClassName(), (String)config.getMethodName());
                f = FileUtil.normalizeFile((File)f);
                this.copy(FileUtil.toFileObject((File)f));
            }
            ExecutorTask task = RunUtils.executeMaven((RunConfig)rc);
        }

        private FileObject getFailedConfig() {
            FileObject fo = this.p.getProjectDirectory();
            FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)fo)});
            FileObject cfg = fo.getFileObject(failedConfPath);
            if (cfg == null || !cfg.isValid()) {
                cfg = fo.getFileObject(failedConfPath2);
            }
            return cfg;
        }

        private FileObject copy(FileObject source) throws IOException {
            FileObject fo = this.p.getProjectDirectory();
            FileObject folder = FileUtil.createFolder((FileObject)fo, (String)"target/nb-private");
            FileObject cfg = folder.getFileObject("testng-suite", "xml");
            if (cfg != null) {
                cfg.delete();
            }
            return FileUtil.copyFile((FileObject)source, (FileObject)folder, (String)"testng-suite");
        }
    }
}

