/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.visitor.PositionFinderVisitor;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XDMUtil {
    static Document fDoc;
    static Document sDoc;
    public static final String NS_PREFIX = "xmlns";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    public static final String XML_PROLOG = "<?xml version=\"1.0\"?>\n";

    public String prettyPrintXML(String doc, String indentation) throws UnsupportedEncodingException, IOException, BadLocationException {
        BaseDocument sd1 = new BaseDocument(true, "text/xml");
        XDMModel m1 = this.createXDMModel((javax.swing.text.Document)sd1, doc);
        Document root1 = m1.getDocument();
        BaseDocument sd2 = new BaseDocument(true, "text/xml");
        XDMModel m2 = this.createXDMModel((javax.swing.text.Document)sd2);
        m2.setPretty(true);
        m2.setIndentation(indentation);
        m2.sync();
        Node root2 = m2.getDocument();
        root2 = this.doPrettyPrint(m2, root2, root1);
        m2.flush();
        int firstChildPos1 = -1;
        Node firstChild1 = (Node)root1.getChildNodes().item(0);
        if (firstChild1 != null) {
            firstChildPos1 = new PositionFinderVisitor().findPosition(m1.getDocument(), firstChild1);
        }
        int firstChildPos2 = -1;
        Node firstChild2 = (Node)root2.getChildNodes().item(0);
        if (firstChild2 != null) {
            firstChildPos2 = new PositionFinderVisitor().findPosition(m2.getDocument(), firstChild2);
        }
        return firstChildPos1 == -1 ? doc : sd1.getText(0, firstChildPos1) + sd2.getText(firstChildPos2, sd2.getLength() - firstChildPos2);
    }

    public List<Difference> compareXML(String xml1, String xml2, ComparisonCriteria criteria) throws Exception {
        return this.compareXML(xml1, xml2, criteria, true);
    }

    public List<Difference> compareXML(String firstDoc, String secondDoc, ComparisonCriteria type, boolean filterWhiteSpace) throws BadLocationException, IOException {
        BaseDocument sd1 = new BaseDocument(true, "text/xml");
        XDMModel m1 = this.createXDMModel((javax.swing.text.Document)sd1);
        sd1.remove(0, XML_PROLOG.length());
        sd1.insertString(0, firstDoc, null);
        m1.sync();
        fDoc = m1.getDocument();
        BaseDocument sd2 = new BaseDocument(true, "text/xml");
        sd2.getText(0, sd2.getLength());
        XDMModel m2 = this.createXDMModel((javax.swing.text.Document)sd2);
        sd2.remove(0, XML_PROLOG.length());
        sd2.insertString(0, secondDoc, null);
        m2.setPretty(true);
        m2.sync();
        sDoc = m2.getDocument();
        XDUDiffFinder dif = new XDUDiffFinder(this.createElementIdentity());
        List<Difference> diffs = dif.findDiff(m1.getDocument(), m2.getDocument());
        if (filterWhiteSpace) {
            diffs = XDUDiffFinder.filterWhitespace(diffs);
        }
        if (type == ComparisonCriteria.EQUAL) {
            ArrayList<Difference> filteredDiffs = new ArrayList<Difference>();
            for (Difference d : diffs) {
                if (d instanceof Change) {
                    Change c = (Change)d;
                    if (c.isPositionChanged() && !c.isTokenChanged() && !c.isAttributeChanged()) continue;
                    if (c.isAttributeChanged() && !c.isTokenChanged()) {
                        int i;
                        ArrayList<Change.AttributeChange> removeList = new ArrayList<Change.AttributeChange>();
                        List<Change.AttributeDiff> attrChanges = c.getAttrChanges();
                        for (i = 0; i < attrChanges.size(); ++i) {
                            Change.AttributeChange ac;
                            if (!(attrChanges.get(i) instanceof Change.AttributeChange) || !(ac = (Change.AttributeChange)attrChanges.get(i)).isPositionChanged() || ac.isTokenChanged()) continue;
                            removeList.add(ac);
                        }
                        for (i = 0; i < removeList.size(); ++i) {
                            c.removeAttrChanges((Change.AttributeDiff)removeList.get(i));
                        }
                        if (c.getAttrChanges().size() == 0) continue;
                    }
                    filteredDiffs.add(d);
                    continue;
                }
                filteredDiffs.add(d);
            }
            return filteredDiffs;
        }
        XDMUtil.removePseudoAttrPosChanges(diffs);
        XDMUtil.filterSchemaLocationDiffs(diffs);
        return diffs;
    }

    private ElementIdentity createElementIdentity() {
        XDElementIdentity eID = new XDElementIdentity();
        eID.addIdentifier("id");
        eID.addIdentifier("name");
        eID.addIdentifier("ref");
        return eID;
    }

    private XDMModel createXDMModel(javax.swing.text.Document sd) throws BadLocationException, IOException {
        return this.createXDMModel(sd, "");
    }

    private XDMModel createXDMModel(javax.swing.text.Document sd, String content) throws BadLocationException, IOException {
        boolean foundXMLProlog = true;
        if (content.indexOf("<?xml") == -1) {
            sd.insertString(0, XML_PROLOG + content, null);
        } else {
            sd.insertString(0, content, null);
        }
        Lookup lookup = Lookups.singleton((Object)sd);
        ModelSource ms = new ModelSource(lookup, true);
        XDMModel model = new XDMModel(ms);
        model.sync();
        return model;
    }

    private Node doPrettyPrint(XDMModel m2, Node n2, Node n1) {
        Node newNode = null;
        NodeList childs1 = n1.getChildNodes();
        int count = 0;
        for (int i = 0; i < childs1.getLength(); ++i) {
            n1 = (NodeImpl)childs1.item(i);
            newNode = ((NodeImpl)n1).cloneNode(true, false);
            List<Node> ancestors = m2.add(n2, newNode, count++);
            n2 = ancestors.get(0);
        }
        ArrayList<Node> ancestors = new ArrayList<Node>();
        this.fixPrettyText(m2, n2, ancestors, "");
        n2 = (Node)ancestors.get(0);
        return n2;
    }

    private void fixPrettyText(XDMModel m, Node n, List<Node> ancestors, String indent) {
        int i;
        Node parent = n;
        int index = m.getIndentation().length();
        NodeList childs = parent.getChildNodes();
        ArrayList<Node> visitList = new ArrayList<Node>();
        for (i = 0; i < childs.getLength(); ++i) {
            Node child = (Node)childs.item(i);
            if (XDMUtil.checkPrettyText(child)) {
                Text txt = (Text)((NodeImpl)child).cloneNode(true);
                if (i < childs.getLength() - 1 || ancestors.size() == 0) {
                    txt.setText("\n" + indent);
                } else {
                    String lastTextIndent = "\n";
                    if (m.getIndentation().length() < indent.length()) {
                        lastTextIndent = lastTextIndent + indent.substring(m.getIndentation().length());
                    }
                    txt.setText(lastTextIndent);
                }
                List<Node> ancestors2 = m.modify(child, txt);
                parent = ancestors2.get(0);
                continue;
            }
            if (!(childs.item(i) instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
            visitList.add((Node)childs.item(i));
        }
        ancestors.add(parent);
        for (i = 0; i < visitList.size(); ++i) {
            this.fixPrettyText(m, (Node)visitList.get(i), ancestors, indent + m.getIndentation());
        }
        visitList.clear();
    }

    public static boolean checkPrettyText(Node txt) {
        return txt instanceof Text && ((NodeImpl)txt).getTokens().size() == 1 && XDMUtil.isWhitespaceOnly(((NodeImpl)txt).getTokens().get(0).getValue());
    }

    public static boolean isWhitespaceOnly(String tn) {
        return XDUDiffFinder.isPossibleWhiteSpace(tn) && tn.trim().length() == 0;
    }

    public static int findPosition(Node n) {
        return new PositionFinderVisitor().findPosition((Node)((Object)n.getOwnerDocument()), n);
    }

    public static void removePseudoAttrPosChanges(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            int delCount = 0;
            int addCount = 0;
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (attrdif instanceof Change.AttributeDelete) {
                    ++delCount;
                    continue;
                }
                if (attrdif instanceof Change.AttributeAdd) {
                    ++addCount;
                    continue;
                }
                if (!(attrdif instanceof Change.AttributeChange) || !(attrChange = (Change.AttributeChange)attrdif).isPositionChanged() || attrChange.isTokenChanged() || attrChange.getOldAttributePosition() - delCount + addCount != attrChange.getNewAttributePosition()) continue;
                removeAttrs.add(attrdif);
            }
            for (Change.AttributeDiff attrdif : removeAttrs) {
                c.removeAttrChanges(attrdif);
            }
            if (size <= 0 || c.getAttrChanges().size() != 0) continue;
            removeDiffs.add(dif);
        }
        diffs.removeAll(removeDiffs);
    }

    public static void filterAttributeOrderChange(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged()) continue;
            List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
            int size = attrdiffs.size();
            ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
            for (Change.AttributeDiff attrdif : attrdiffs) {
                Change.AttributeChange attrChange;
                if (!(attrdif instanceof Change.AttributeChange) || !(attrChange = (Change.AttributeChange)attrdif).isPositionChanged() || attrChange.isTokenChanged()) continue;
                removeAttrs.add(attrdif);
            }
            for (Change.AttributeDiff attrdif : removeAttrs) {
                c.removeAttrChanges(attrdif);
            }
            if (size <= 0 || c.getAttrChanges().size() != 0) continue;
            removeDiffs.add(dif);
        }
        diffs.removeAll(removeDiffs);
    }

    public static void filterSchemaLocationDiffs(List<Difference> diffs) {
        ArrayList<Difference> removeDiffs = new ArrayList<Difference>();
        for (Difference dif : diffs) {
            Change c;
            if (!(dif instanceof Change) || !(c = (Change)dif).isAttributeChanged() || c.isPositionChanged() || c.isTokenChanged() || !XDMUtil.removeSchemaLocationAttrDiffs(c)) continue;
            removeDiffs.add(dif);
        }
        diffs.removeAll(removeDiffs);
    }

    public static boolean removeSchemaLocationAttrDiffs(Change c) {
        List<Change.AttributeDiff> attrdiffs = c.getAttrChanges();
        int size = attrdiffs.size();
        ArrayList<Change.AttributeDiff> removeAttrs = new ArrayList<Change.AttributeDiff>();
        for (Change.AttributeDiff attrdif : attrdiffs) {
            Attribute oldAttr = attrdif.getOldAttribute();
            Attribute newAttr = attrdif.getNewAttribute();
            if (oldAttr != null && oldAttr.getName().endsWith(SCHEMA_LOCATION)) {
                removeAttrs.add(attrdif);
                continue;
            }
            if (newAttr == null || !newAttr.getName().endsWith(SCHEMA_LOCATION)) continue;
            removeAttrs.add(attrdif);
        }
        for (Change.AttributeDiff attrdif : removeAttrs) {
            c.removeAttrChanges(attrdif);
        }
        return size > 0 && attrdiffs.size() == 0;
    }

    public static enum ComparisonCriteria {
        EQUAL,
        IDENTICAL;

    }

    public class XDUDiffFinder
    extends DiffFinder {
        public XDUDiffFinder(ElementIdentity eID) {
            super(eID);
        }

        @Override
        public List<Change.Type> checkChange(Node p1, Node p2) {
            ArrayList<Change.Type> changes = new ArrayList<Change.Type>();
            if (p1 instanceof org.netbeans.modules.xml.xdm.nodes.Element && p2 instanceof org.netbeans.modules.xml.xdm.nodes.Element && !this.checkAttributesEqual((org.netbeans.modules.xml.xdm.nodes.Element)p1, (org.netbeans.modules.xml.xdm.nodes.Element)p2)) {
                changes.add(Change.Type.ATTRIBUTE);
            }
            return changes;
        }

        @Override
        protected boolean checkAttributesEqual(org.netbeans.modules.xml.xdm.nodes.Element p1, org.netbeans.modules.xml.xdm.nodes.Element p2) {
            if (p1 == null || p2 == null) {
                return false;
            }
            NamedNodeMap nm1 = p1.getAttributes();
            NamedNodeMap nm2 = p2.getAttributes();
            for (int i = 0; i < nm1.getLength(); ++i) {
                Node attr1 = (Node)nm1.item(i);
                if (attr1.getNodeName().startsWith(XDMUtil.NS_PREFIX)) continue;
                Node attr2 = (Node)nm2.getNamedItem(attr1.getNodeName());
                if (attr2 == null) {
                    return false;
                }
                if (nm2.item(i) != attr2) {
                    return false;
                }
                if (attr1.getNodeValue().equals(attr2.getNodeValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean compareTextByValue(Text n1, Text n2) {
            return n1.getNodeValue().equals(n2.getNodeValue());
        }
    }

    public class XDElementIdentity
    extends DefaultElementIdentity {
        @Override
        protected boolean compareElement(Element n1, Element n2, org.w3c.dom.Node parent1, org.w3c.dom.Document doc1, org.w3c.dom.Document doc2) {
            String qName1 = n1.getLocalName();
            String qName2 = n2.getLocalName();
            String ns1 = ((Node)((Object)n1)).getNamespaceURI((Document)doc1);
            String ns2 = ((Node)((Object)n2)).getNamespaceURI((Document)doc2);
            if (qName1.intern() != qName2.intern()) {
                return false;
            }
            if (!((ns1 == null || ns1.equals("")) && (ns2 == null || ns2.equals("")) || ns1 == null && ns2 == null || ns1 != null && ns2 != null && ns1.intern() == ns2.intern())) {
                return false;
            }
            if (parent1 == doc1) {
                return true;
            }
            return this.compareAttr(n1, n2);
        }
    }
}

