/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectLoader;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.Bundle;
import org.netbeans.modules.gradle.loaders.BundleProjectLoader;
import org.netbeans.modules.gradle.loaders.DiskCacheProjectLoader;
import org.netbeans.modules.gradle.loaders.FallbackProjectLoader;
import org.netbeans.modules.gradle.loaders.LegacyProjectLoader;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;

public class GradleProjectLoaderImpl
implements GradleProjectLoader {
    final Project project;
    private static final Logger LOGGER = Logger.getLogger(GradleProjectLoaderImpl.class.getName());

    public GradleProjectLoaderImpl(Project project) {
        this.project = project;
    }

    @Override
    public GradleProject loadProject(NbGradleProject.LoadOptions options, String ... args) {
        LOGGER.info("Load aiming " + String.valueOf((Object)options.getAim()) + " for " + String.valueOf(this.project));
        GradleCommandLine cmd = new GradleCommandLine(args);
        AbstractProjectLoader.ReloadContext ctx = new AbstractProjectLoader.ReloadContext((NbGradleProjectImpl)this.project, options, cmd);
        LOGGER.log(Level.FINER, "Load context: project = {0}, prev = {1}, aim = {2}, args = {3}", new Object[]{this.project, ctx.previous, options.getAim(), cmd});
        LinkedList<AbstractProjectLoader> loaders = new LinkedList<AbstractProjectLoader>();
        if (!options.isIgnoreCache()) {
            loaders.add(new DiskCacheProjectLoader(ctx));
        }
        if (GradleExperimentalSettings.getDefault().isBundledLoading()) {
            loaders.add(new BundleProjectLoader(ctx));
            loaders.add(new DiskCacheProjectLoader(ctx));
        }
        loaders.add(new LegacyProjectLoader(ctx));
        loaders.add(new FallbackProjectLoader(ctx));
        Boolean trust = null;
        GradleProject best = null;
        GradleProject ret = null;
        for (AbstractProjectLoader loader : loaders) {
            if (loader.isEnabled()) {
                if (loader.needsTrust()) {
                    if (trust == null) {
                        trust = RunUtils.isProjectTrusted(ctx.project, options.isInteractive());
                    }
                    if (trust.booleanValue()) {
                        ret = loader.load();
                        LOGGER.log(Level.FINER, "Loaded with trusted loader {0} -> {1}", new Object[]{loader, ret});
                    } else {
                        ret = ctx.getPrevious();
                        if (ret != null) {
                            ret = ret.invalidate(Bundle.ERR_ProjectNotTrusted());
                        }
                        LOGGER.log(Level.FINER, "Execution not allowed, invalidated {0}", ret);
                    }
                } else {
                    ret = loader.load();
                    LOGGER.log(Level.FINER, "Loaded with loader {0} -> {1}", new Object[]{loader, ret});
                }
                if (ret == null) continue;
                if (best == null || best.getQuality().notBetterThan(ret.getQuality())) {
                    best = ret;
                }
                if (!ret.getQuality().atLeast(options.getAim())) continue;
                break;
            }
            LOGGER.log(Level.FINER, "Loaded disabled: {0}", loader);
        }
        return best;
    }
}

