/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.tooling.ConfigurableLauncher;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.Lookup;

public final class GradleExecConfiguration
implements ProjectConfiguration {
    public static final String DEFAULT = "%%DEFAULT%%";
    public static final String ACTIVE = "%%ACTIVE%%";
    @NonNull
    private final String id;
    private String displayName;
    private Map<String, String> projectProperties;
    private String commandLineArgs;

    GradleExecConfiguration(@NonNull String id) {
        this.id = id;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.displayName;
    }

    @NonNull
    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public String getCommandLineArgs() {
        return this.commandLineArgs;
    }

    @NonNull
    public String getDisplayName() {
        if (this.displayName != null && !this.displayName.isEmpty()) {
            return this.displayName;
        }
        return this.id;
    }

    void setDisplayName(String displayName) {
        this.displayName = displayName == null || "".equals(displayName.trim()) ? null : displayName.trim();
    }

    void setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = projectProperties;
    }

    void setCommandLineArgs(String commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradleExecConfiguration other = (GradleExecConfiguration)obj;
        return Objects.equals(this.id, other.id);
    }

    public boolean isDefault() {
        return DEFAULT.equals(this.getId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Config[").append(this.id).append("]{");
        if (this.displayName != null) {
            sb.append('\"').append(this.displayName).append(", ");
        }
        if (this.projectProperties != null && !this.projectProperties.isEmpty()) {
            sb.append("props=").append(this.projectProperties.keySet());
            sb.append(", ");
        }
        if (this.commandLineArgs != null & !this.commandLineArgs.isEmpty()) {
            sb.append(", cmd=").append(this.commandLineArgs);
        }
        sb.append('}');
        return sb.toString();
    }

    @NonNull
    public static GradleExecConfiguration findEffectiveConfiguration(@NonNull Project prj, @NullAllowed Lookup context) {
        GradleExecConfiguration cfg = ProjectConfigurationSupport.getEffectiveConfiguration(prj, context == null ? Lookup.EMPTY : context);
        return cfg != null ? cfg : GradleExecAccessor.createDefault();
    }

    static {
        GradleExecAccessor.setInstance(new GradleExecAccessor(){

            @Override
            public GradleExecConfiguration create(String id, String dispName, Map<String, String> projectProps, String cmdline) {
                GradleExecConfiguration cfg = new GradleExecConfiguration(id);
                cfg.setDisplayName(dispName == null || dispName.trim().isEmpty() ? null : dispName.trim());
                cfg.setCommandLineArgs(cmdline == null || cmdline.trim().isEmpty() ? "" : cmdline.trim());
                cfg.setProjectProperties(new LinkedHashMap<String, String>(projectProps == null ? Collections.emptyMap() : projectProps));
                return cfg;
            }

            @Override
            public GradleExecConfiguration update(GradleExecConfiguration conf, String dispName, Map<String, String> projectProps, String cmdline) {
                conf.setDisplayName(dispName == null || dispName.trim().isEmpty() ? null : dispName.trim());
                conf.setCommandLineArgs(cmdline == null || cmdline.trim().isEmpty() ? "" : cmdline.trim());
                conf.setProjectProperties(new LinkedHashMap<String, String>(projectProps == null ? Collections.emptyMap() : projectProps));
                return conf;
            }

            @Override
            public ConfigurableLauncher configureGradleHome(ConfigurableLauncher cfgL) {
                ConfigurableLauncher<?> r = GradleCommandLine.configureGradleHome(cfgL);
                return r;
            }
        });
    }
}

