/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.netbeans.junit.Filter;
import org.netbeans.junit.NbTest;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.RandomlyFails;

public class NbTestSuite
extends TestSuite
implements NbTest {
    private Filter fFilter;

    static boolean ignoreRandomFailures() {
        return Boolean.getBoolean("ignore.random.failures");
    }

    public NbTestSuite() {
    }

    public NbTestSuite(Class<? extends TestCase> theClass) {
        super(NbTestSuite.testCaseClassOrDummy(theClass));
    }

    private static Class<? extends TestCase> testCaseClassOrDummy(Class<? extends TestCase> testClass) {
        if (NbTestSuite.ignoreRandomFailures() && testClass.isAnnotationPresent(RandomlyFails.class)) {
            System.err.println("Skipping " + testClass.getName());
            return APIJail.Dummy.class;
        }
        return testClass;
    }

    public NbTestSuite(String name) {
        super(name);
    }

    void addTests(Class<? extends TestCase> clazz, String ... names) throws Exception {
        Constructor<? extends TestCase> cnt = clazz.getConstructor(String.class);
        for (String n : names) {
            Test t = (Test)cnt.newInstance(n);
            this.addTest(t);
        }
    }

    public void addTest(Test test) {
        if (test instanceof NbTest) {
            ((NbTest)test).setFilter(this.fFilter);
        }
        super.addTest(test);
    }

    public void addTestSuite(Class<? extends TestCase> testClass) {
        if (NbTestSuite.ignoreRandomFailures() && testClass.isAnnotationPresent(RandomlyFails.class)) {
            System.err.println("Skipping " + testClass.getName());
            return;
        }
        NbTestSuite t = new NbTestSuite(testClass);
        t.setFilter(this.fFilter);
        this.addTest(t);
    }

    @Override
    public void setFilter(Filter filter) {
        this.fFilter = filter;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Object test = e.nextElement();
            if (!(test instanceof NbTest)) continue;
            ((NbTest)test).setFilter(filter);
        }
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    public String getExpectedFail() {
        return null;
    }

    public static NbTestSuite speedSuite(Class<? extends TestCase> clazz, int slowness, int repeat) {
        if (NbTestSuite.ignoreRandomFailures()) {
            System.err.println("Skipping " + clazz.getName());
            return new NbTestSuite("skipping");
        }
        return new SpeedSuite(clazz, repeat, slowness, 0);
    }

    public static NbTestSuite linearSpeedSuite(Class<? extends TestCase> clazz, int slowness, int repeat) {
        if (NbTestSuite.ignoreRandomFailures()) {
            System.err.println("Skipping " + clazz.getName());
            return new NbTestSuite("skipping");
        }
        return new SpeedSuite(clazz, repeat, slowness, 1);
    }

    private static class APIJail {
        private APIJail() {
        }

        public static class Dummy
        extends TestCase {
            public Dummy(String name) {
                super(name);
            }

            public void testNothing() {
            }
        }
    }

    private static final class SpeedSuite
    extends NbTestSuite {
        public static final int CONSTANT = 0;
        public static final int LINEAR = 1;
        private int repeat;
        private int slowness;
        private int type;

        public SpeedSuite(Class<? extends TestCase> clazz, int repeat, int slowness, int type) {
            super(clazz);
            this.repeat = repeat;
            this.slowness = slowness;
            this.type = type;
        }

        public void run(TestResult result) {
            StringBuffer error = new StringBuffer();
            for (int i = 0; i < this.repeat; ++i) {
                super.run(result);
                error.setLength(0);
                if (!result.wasSuccessful()) {
                    return;
                }
                Enumeration en = this.tests();
                while (en.hasMoreElements()) {
                    Object t = en.nextElement();
                    if (t instanceof NbTestCase) {
                        NbTestCase test = (NbTestCase)t;
                        error.append("Test ");
                        error.append(test.getName());
                        error.append(" took ");
                        error.append(test.getExecutionTime() / 1000000L);
                        error.append(" ms\n");
                        continue;
                    }
                    error.append("Test ");
                    error.append(t);
                    error.append(" is not NbTestCase");
                }
                double min = 9.223372036854776E18;
                double max = -9.223372036854776E18;
                Enumeration en2 = this.tests();
                while (en2.hasMoreElements()) {
                    Object t = en2.nextElement();
                    if (!(t instanceof NbTestCase)) continue;
                    double l = ((NbTestCase)t).getExecutionTime();
                    if (this.type == 1) {
                        l /= (double)((NbTestCase)t).getTestNumber();
                    }
                    if (l > max) {
                        max = l;
                    }
                    if (!(l < min)) continue;
                    min = l;
                }
                System.err.println(error.toString());
                if (!(max <= min * (double)this.slowness)) continue;
                return;
            }
            result.addFailure((Test)this, new AssertionFailedError("Execution times of tests differ too much;\nthe results are supposed to be " + this.typeName() + ":\n" + error.toString()));
        }

        private String typeName() {
            switch (this.type) {
                case 0: {
                    return "constant";
                }
                case 1: {
                    return "linear";
                }
            }
            NbTestCase.fail((String)("This is not supported type: " + this.type));
            return null;
        }
    }
}

