/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.util.Exceptions;

public class ScriptEmbeddingProvider
extends EmbeddingProvider {
    private static final String JAVASCRIPT_MIME = "text/javascript";
    private static final String JAVASCRIPT_LANG = "javascript";

    public List<Embedding> getEmbeddings(final Snapshot snapshot) {
        if (!"text/x-fxml+xml".equals(snapshot.getMimeType())) {
            return Collections.emptyList();
        }
        final ScriptFinder f = new ScriptFinder(snapshot);
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(this){
                final /* synthetic */ ScriptEmbeddingProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    final FxmlParserResult res = FxmlParserResult.get(resultIterator.getParserResult());
                    if (res == null || res.getSourceModel().getLanguage() == null || !ScriptEmbeddingProvider.JAVASCRIPT_LANG.equals(res.getSourceModel().getLanguage().getLanguage())) {
                        return;
                    }
                    Document doc = snapshot.getSource().getDocument(false);
                    if (doc != null) {
                        doc.render(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                f.setFxResult(res);
                                res.getSourceModel().accept(f);
                            }
                        });
                    } else {
                        f.setFxResult(res);
                        res.getSourceModel().accept(f);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return f.embeddings;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    private class ScriptFinder
    extends FxNodeVisitor.ModelTreeTraversal {
        private FxmlParserResult fxResult;
        private List<Embedding> embeddings = new ArrayList<Embedding>();
        private Snapshot snapshot;
        private Document doc;
        private TokenSequence<XMLTokenId> ts;

        public ScriptFinder(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public void setFxResult(FxmlParserResult fxResult) {
            this.fxResult = fxResult;
            this.doc = this.snapshot.getSource().getDocument(false);
            this.ts = this.doc == null ? fxResult.getTokenHierarchy().tokenSequence() : TokenHierarchy.get((Document)this.doc).tokenSequence();
        }

        @Override
        public void visitScript(FxScriptFragment script) {
            TextPositions pos = this.fxResult.getTreeUtilities().positions(script);
            this.createEmbedding(pos);
            super.visitScript(script);
        }

        private void createEmbedding(TextPositions pos) {
            int skip = this.ts.move(pos.getContentStart());
            if (skip != 0) {
                System.err.println("");
            }
            LinkedList<Embedding> content = new LinkedList<Embedding>();
            while (this.ts.moveNext() && this.ts.offset() < pos.getContentEnd()) {
                Token token = this.ts.token();
                XMLTokenId id = (XMLTokenId)token.id();
                switch (id) {
                    case CHARACTER: 
                    case TEXT: {
                        content.add(this.snapshot.create(this.ts.offset(), token.length(), ScriptEmbeddingProvider.JAVASCRIPT_MIME));
                        if (this.doc == null) break;
                        this.ts.createEmbedding(Language.find((String)ScriptEmbeddingProvider.JAVASCRIPT_MIME), 0, 0, true);
                        break;
                    }
                    case CDATA_SECTION: {
                        int start = this.ts.offset();
                        int startPad = 0;
                        int endPad = 0;
                        int len = token.length();
                        CharSequence text = token.text();
                        if (len > 9 && text.subSequence(0, 9).toString().equals("<![CDATA[")) {
                            startPad = 9;
                        }
                        if (len > 3 && text.subSequence(len - 3, len).toString().equals("]]>")) {
                            endPad = 3;
                        }
                        content.add(this.snapshot.create(start + startPad, len - startPad - endPad, ScriptEmbeddingProvider.JAVASCRIPT_MIME));
                        if (this.doc == null) break;
                        this.ts.createEmbedding(Language.find((String)ScriptEmbeddingProvider.JAVASCRIPT_MIME), startPad, endPad);
                        break;
                    }
                }
                skip = 0;
            }
            if (content.isEmpty()) {
                return;
            }
            if (content.size() == 1) {
                this.embeddings.add((Embedding)content.get(0));
            } else {
                this.embeddings.add(Embedding.create(content));
            }
        }

        @Override
        public void visitEvent(EventHandler eh) {
            if (!eh.isScript() || !eh.hasContent()) {
                return;
            }
            TextPositions pos = this.fxResult.getTreeUtilities().positions(eh);
            boolean attribute = this.fxResult.getTreeUtilities().isAttribute(eh);
            if (attribute) {
                this.embeddings.add(this.snapshot.create(pos.getContentStart(), pos.getContentEnd() - pos.getContentStart(), ScriptEmbeddingProvider.JAVASCRIPT_MIME));
                if (this.doc != null) {
                    int skip = this.ts.move(pos.getContentStart());
                    this.ts.moveNext();
                    this.ts.createEmbedding(Language.find((String)ScriptEmbeddingProvider.JAVASCRIPT_MIME), skip, skip, true);
                }
            } else {
                this.createEmbedding(pos);
            }
        }
    }

    public static class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            if (Language.find((String)ScriptEmbeddingProvider.JAVASCRIPT_MIME) == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(new ScriptEmbeddingProvider());
        }
    }
}

