/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class LazyOperationDescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private static final String HEAD = "OperationDescriptionStep_Header_Head";
    private static final String CONTENT = "OperationDescriptionStep_Header_Content";
    private static final String TABLE_TITLE_INSTALL = "OperationDescriptionStep_TableInstall_Title";
    private static final String TABLE_TITLE_UPDATE = "OperationDescriptionStep_TableUpdate_Title";
    private PanelBodyContainer component;
    private Collection<LazyInstallUnitWizardIterator.LazyUnit> installModel = null;
    private boolean hasUpdates = false;
    private OperationWizardModel.OperationType operationType = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RequestProcessor.Task checkRealUpdatesTask = null;
    private WizardDescriptor wd = null;
    private boolean forceReload;
    private boolean canClose = false;

    public LazyOperationDescriptionStep(Collection<LazyInstallUnitWizardIterator.LazyUnit> model, OperationWizardModel.OperationType doOperation, boolean forceReload) {
        this.installModel = model;
        this.operationType = doOperation;
        this.hasUpdates = this.installModel != null && !this.installModel.isEmpty();
        this.forceReload = forceReload;
    }

    public Component getComponent() {
        if (this.component == null) {
            String content;
            String head;
            String tableTitle;
            switch (this.operationType) {
                case INSTALL: {
                    tableTitle = this.getBundle(TABLE_TITLE_INSTALL, new Object[0]);
                    head = this.getBundle(HEAD, new Object[0]);
                    content = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case UPDATE: {
                    tableTitle = this.getBundle(TABLE_TITLE_UPDATE, new Object[0]);
                    head = this.getBundle(HEAD, new Object[0]);
                    content = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                default: {
                    assert (false) : "Unexcepted operationType " + (Object)((Object)this.operationType);
                    return null;
                }
            }
            if (!this.hasUpdates) {
                tableTitle = this.getBundle("LazyOperationDescriptionStep_FindUpdates_Title", new Object[0]);
            }
            OperationDescriptionPanel body = new OperationDescriptionPanel(tableTitle, this.preparePluginsForShow(this.installModel, this.operationType), "", "", false);
            this.component = new PanelBodyContainer(head, content, body);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
            long estimatedTime = Utilities.getTimeOfInitialization();
            if (this.forceReload) {
                long refreshTime = Utilities.getTimeOfRefreshUpdateCenters();
                estimatedTime = estimatedTime > 0L || refreshTime > 0L ? estimatedTime + refreshTime : 0L;
            }
            this.component.setWaitingState(true, estimatedTime);
            this.checkRealUpdates();
        }
        return this.component;
    }

    private void checkRealUpdates() {
        final ArrayList problems = new ArrayList();
        final ArrayList notifications = new ArrayList();
        this.checkRealUpdatesTask = Installer.RP.post(new Runnable(){
            final /* synthetic */ LazyOperationDescriptionStep this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final HashSet<UpdateElement> updateElementsForStore = new HashSet<UpdateElement>();
                Collection<UpdateElement> updates = AutoupdateCheckScheduler.checkUpdateElements(this.this$0.operationType, problems, this.this$0.forceReload, updateElementsForStore);
                this.this$0.hasUpdates = updates != null && !updates.isEmpty();
                if (this.this$0.hasUpdates) {
                    UpdateUnit uu;
                    assert (this.this$0.wd != null) : "WizardDescriptor must found!";
                    OperationContainer oc = OperationWizardModel.OperationType.UPDATE == this.this$0.operationType ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                    boolean allOk = true;
                    InstallUnitWizardModel model = new InstallUnitWizardModel(this.this$0.operationType, (OperationContainer<InstallSupport>)oc);
                    for (UpdateElement el : updates) {
                        uu = el.getUpdateUnit();
                        if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == uu.getType()) {
                            allOk &= model.getCustomHandledContainer().canBeAdded(uu, el);
                            continue;
                        }
                        allOk &= oc.canBeAdded(uu, el);
                    }
                    this.this$0.hasUpdates = this.this$0.hasUpdates && allOk;
                    if (allOk) {
                        for (UpdateElement el : updates) {
                            uu = el.getUpdateUnit();
                            if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == uu.getType()) {
                                model.getCustomHandledContainer().add(el);
                                continue;
                            }
                            oc.add(el);
                        }
                        model.getBaseContainer().listAll();
                        final InstallUnitWizardIterator panels = new InstallUnitWizardIterator(model, true);
                        panels.hasNext();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.wd.setPanelsAndSettings(panels, (Object)this.this$1.this$0.wd);
                                this.this$1.this$0.fireChange();
                                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(this.this$1.this$0.operationType, updateElementsForStore);
                            }
                        });
                    }
                } else {
                    for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                        String desc = p.getDescription();
                        if (desc == null || !desc.contains("<a name=\"autoupdate_catalog_parser\"")) continue;
                        notifications.add(desc);
                    }
                }
            }
        });
        class TLAndR
        implements TaskListener,
        Runnable {
            final /* synthetic */ LazyOperationDescriptionStep this$0;

            TLAndR() {
                this.this$0 = this$0;
            }

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                if (!this.this$0.hasUpdates) {
                    this.this$0.installModel = Collections.EMPTY_SET;
                    new InstallUnitWizardModel(null, null).modifyOptionsForDoClose(this.this$0.wd);
                    this.this$0.canClose = true;
                    LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(this.this$0.operationType, this.this$0.installModel);
                    EventQueue.invokeLater(this);
                }
            }

            @Override
            public void run() {
                OperationDescriptionPanel body;
                if (problems.isEmpty()) {
                    if (notifications.isEmpty()) {
                        body = new OperationDescriptionPanel(this.this$0.getBundle("LazyOperationDescriptionStep_NoUpdates_Title", new Object[0]), this.this$0.getBundle("LazyOperationDescriptionStep_NoUpdates", new Object[0]), "", "", false);
                    } else {
                        String content = notifications.stream().collect(Collectors.joining("<br><br>"));
                        body = new OperationDescriptionPanel(this.this$0.getBundle("LazyOperationDescriptionStep_Notifications_Title", new Object[0]), content, "", "", false);
                    }
                } else {
                    body = new OperationDescriptionPanel(this.this$0.getBundle("LazyOperationDescriptionStep_NoUpdatesWithProblems_Title", new Object[0]), this.this$0.getBundle("LazyOperationDescriptionStep_NoUpdatesWithProblems", new Object[0]), "", "", false);
                }
                this.this$0.component.setBody(body);
                this.this$0.component.setWaitingState(false);
                this.this$0.fireChange();
            }
        }
        this.checkRealUpdatesTask.addTaskListener((TaskListener)new TLAndR());
    }

    private String preparePluginsForShow(Collection<LazyInstallUnitWizardIterator.LazyUnit> units, OperationWizardModel.OperationType type) {
        String s = new String();
        ArrayList<String> names = new ArrayList<String>();
        if (units != null && !units.isEmpty()) {
            for (LazyInstallUnitWizardIterator.LazyUnit u : units) {
                String updatename = "<b>" + u.getDisplayName() + "</b> ";
                updatename = OperationWizardModel.OperationType.UPDATE == type ? updatename + this.getBundle("OperationDescriptionStep_UpdatePluginVersionFormat", u.getOldVersion(), u.getNewVersion()) : updatename + this.getBundle("OperationDescriptionStep_PluginVersionFormat", u.getNewVersion());
                updatename = updatename + "<br>";
                String notification = u.getNotification();
                if (notification != null && notification.length() > 0) {
                    updatename = updatename + "<font color=\"red\">" + notification + "</font><br><br>";
                }
                names.add(updatename);
            }
            Collections.sort(names);
            for (String name : names) {
                s = s + name;
            }
        }
        return s.trim();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
    }

    public void storeSettings(WizardDescriptor wd) {
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            if (this.checkRealUpdatesTask != null && !this.checkRealUpdatesTask.isFinished()) {
                this.checkRealUpdatesTask.cancel();
            }
            AutoupdateCheckScheduler.notifyAvailable(this.installModel, this.operationType);
        }
    }

    public boolean isValid() {
        return this.canClose;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        LazyOperationDescriptionStep lazyOperationDescriptionStep = this;
        synchronized (lazyOperationDescriptionStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(OperationDescriptionPanel.class, (String)key, (Object[])params);
    }
}

