/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.javascript2.editor.CompletionContextFinder;
import org.netbeans.modules.javascript2.editor.EditorExtender;
import org.netbeans.modules.javascript2.editor.FileUtils;
import org.netbeans.modules.javascript2.editor.JsCompletionItem;
import org.netbeans.modules.javascript2.editor.JsKeywords;
import org.netbeans.modules.javascript2.editor.doc.JsDocumentationCodeCompletion;
import org.netbeans.modules.javascript2.editor.options.OptionsUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.editor.spi.CompletionProviderEx;
import org.netbeans.modules.javascript2.editor.spi.ElementDocumentation;
import org.netbeans.modules.javascript2.editor.spi.ProposalRequest;
import org.netbeans.modules.javascript2.lexer.api.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.Identifier;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class JsCodeCompletion
implements CodeCompletionHandler2 {
    private static final Logger LOGGER = Logger.getLogger(JsCodeCompletion.class.getName());
    private static final List<String> WINDOW_EXPRESSION_CHAIN = Arrays.asList("window", "@pro");
    private boolean caseSensitive;
    private static final String CHARS_NO_AUTO_COMPLETE = ";,/+-\\:={}[]()";
    private int checkRecursion;

    JsCodeCompletion() {
    }

    public CodeCompletionResult complete(CodeCompletionContext ccContext) {
        CancelSupport cancelSupport = CancelSupport.getDefault();
        if (cancelSupport.isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        long start = System.currentTimeMillis();
        BaseDocument doc = (BaseDocument)ccContext.getParserResult().getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return CodeCompletionResult.NONE;
        }
        this.caseSensitive = ccContext.isCaseSensitive();
        ParserResult info = ccContext.getParserResult();
        int caretOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(ccContext.getCaretOffset());
        FileObject fileObject = ccContext.getParserResult().getSnapshot().getSource().getFileObject();
        JsParserResult jsParserResult = (JsParserResult)info;
        CompletionContext context = CompletionContextFinder.findCompletionContext(info, caretOffset);
        LOGGER.log(Level.FINE, String.format("CC context: %s", context.toString()));
        JsCompletionItem.CompletionRequest request = new JsCompletionItem.CompletionRequest();
        String pref = ccContext.getPrefix();
        request.anchor = pref == null ? caretOffset : caretOffset - pref.length();
        request.result = jsParserResult;
        request.info = info;
        request.prefix = pref;
        request.completionContext = context;
        request.addHtmlTagAttributes = false;
        request.cancelSupport = cancelSupport;
        Model.getModel((ParserResult)jsParserResult, (boolean)false).resolve();
        ArrayList<CompletionProposal> resultList = new ArrayList<CompletionProposal>();
        HashMap<String, List<JsElement>> added = new HashMap<String, List<JsElement>>();
        if (cancelSupport.isCancelled()) {
            return CodeCompletionResult.NONE;
        }
        if (ccContext.getQueryType() == CodeCompletionHandler.QueryType.ALL_COMPLETION) {
            switch (context) {
                case GLOBAL: {
                    this.addGlobalObjectsFromIndex(request, added);
                    break;
                }
                case EXPRESSION: {
                    this.completeKeywords(request, resultList);
                    this.completeExpression(request, added);
                    break;
                }
                case OBJECT_PROPERTY: {
                    this.completeObjectProperty(request, added);
                    break;
                }
                case OBJECT_MEMBERS: {
                    this.completeObjectMember(request, added);
                    break;
                }
            }
            if (cancelSupport.isCancelled()) {
                return CodeCompletionResult.NONE;
            }
            if (!(context != CompletionContext.EXPRESSION && context != CompletionContext.OBJECT_MEMBERS && context != CompletionContext.OBJECT_PROPERTY || request.prefix.isEmpty())) {
                Collection indexResults = Index.get((FileObject)fileObject).query("bn", request.prefix, QuerySupport.Kind.PREFIX, Index.TERMS_BASIC_INFO);
                for (IndexResult indexResult : indexResults) {
                    IndexedElement indexElement = IndexedElement.create((IndexResult)indexResult);
                    this.addPropertyToMap(request, added, (JsElement)indexElement);
                }
            }
        } else {
            switch (context) {
                case IN_STRING: {
                    if (request.prefix.startsWith(".")) {
                        request.prefix = request.prefix.substring(1);
                        ++request.anchor;
                    }
                    List<String> expression = this.resolveExpressionChainFromString(request);
                    Map<String, List<JsElement>> toAdd = this.getCompletionFromExpressionChain(request, expression);
                    JsCompletionItem.Factory.create(toAdd, request, resultList);
                    break;
                }
                case IMPORT_EXPORT_SPECIAL_TOKENS: {
                    this.addImportExportKeywords(request, resultList);
                    break;
                }
                case IMPORT_EXPORT_MODULE: {
                    this.completeJsModuleNames(request, resultList);
                    break;
                }
                case GLOBAL: {
                    HashMap<String, List<JsElement>> addedProperties = new HashMap<String, List<JsElement>>();
                    addedProperties.putAll(this.getDomCompletionResults(request));
                    for (JsObject libGlobal : ModelUtils.getExtendingGlobalObjects((FileObject)fileObject)) {
                        for (JsObject object : libGlobal.getProperties().values()) {
                            this.addPropertyToMap(request, addedProperties, (JsElement)object);
                        }
                    }
                    for (JsObject object : Model.getModel((ParserResult)request.result, (boolean)false).getVariables(caretOffset)) {
                        if (object instanceof JsFunction && ((JsFunction)object).isAnonymous()) continue;
                        this.addPropertyToMap(request, addedProperties, (JsElement)object);
                    }
                    this.completeKeywords(request, resultList);
                    if (cancelSupport.isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    this.addGlobalObjectsFromIndex(request, addedProperties);
                    if (cancelSupport.isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    this.completeInWith(request, addedProperties);
                    JsCompletionItem.Factory.create(addedProperties, request, resultList);
                    break;
                }
                case CALL_ARGUMENT: {
                    this.completeCallArguments(request, resultList);
                }
                case EXPRESSION: {
                    this.completeKeywords(request, resultList);
                    this.completeExpression(request, added);
                    if (cancelSupport.isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    this.completeObjectProperty(request, added);
                    if (cancelSupport.isCancelled()) {
                        return CodeCompletionResult.NONE;
                    }
                    this.completeInWith(request, added);
                    added.remove("prototype");
                    break;
                }
                case OBJECT_PROPERTY: {
                    this.completeObjectProperty(request, added);
                    break;
                }
                case OBJECT_MEMBERS: {
                    this.completeObjectMember(request, added);
                    break;
                }
                case DOCUMENTATION: {
                    JsDocumentationCodeCompletion.complete(request, resultList);
                    break;
                }
                case OBJECT_PROPERTY_NAME: {
                    this.completeObjectPropertyName(request, added);
                    break;
                }
                case NUMBER: {
                    this.completeNumberProperties(request, added);
                    break;
                }
                case STRING: {
                    this.completeStringProperties(request, added);
                    break;
                }
                case REGEXP: {
                    this.completeRegExpProperties(request, added);
                    break;
                }
            }
        }
        JsCompletionItem.Factory.create(added, request, resultList);
        long end = System.currentTimeMillis();
        ProposalRequest propReq = null;
        for (CompletionProvider interceptor : EditorExtender.getDefault().getCompletionProviders()) {
            List<CompletionProposal> proposals;
            if (interceptor instanceof CompletionProviderEx) {
                if (propReq == null) {
                    propReq = new ProposalRequest(ccContext, context, request.fqnTypes, request.anchor);
                }
                proposals = ((CompletionProviderEx)interceptor).complete(propReq);
            } else {
                proposals = interceptor.complete(ccContext, context, pref);
            }
            if (proposals == null) continue;
            resultList.addAll(proposals);
        }
        LOGGER.log(Level.FINE, "Counting JS CC took {0}ms ", end - start);
        if (!resultList.isEmpty()) {
            return new DefaultCompletionResult(resultList, false);
        }
        return CodeCompletionResult.NONE;
    }

    private void addGlobalObjectsFromIndex(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedProperties) {
        FileObject fileObject = request.result.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            Index jsIndex = Index.get((FileObject)fileObject);
            Collection fromIndex = jsIndex.getGlobalVar(request.prefix);
            for (IndexedElement indexElement : fromIndex) {
                this.addPropertyToMap(request, addedProperties, (JsElement)indexElement);
            }
            fromIndex = jsIndex.getPropertiesWithPrefix("window", request.prefix);
            for (IndexedElement indexElement : fromIndex) {
                this.addPropertyToMap(request, addedProperties, (JsElement)indexElement);
            }
        }
    }

    public String document(ParserResult info, ElementHandle element) {
        Documentation doc = this.documentElement(info, element, () -> false);
        if (doc != null) {
            return doc.getContent();
        }
        return null;
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        JsObject jsObject;
        if (element == null) {
            return null;
        }
        if (element instanceof IndexedElement) {
            final Documentation[] result = new Documentation[1];
            final IndexedElement indexedElement = (IndexedElement)element;
            FileObject nextFo = indexedElement.getFileObject();
            if (nextFo != null) {
                try {
                    ParserManager.parse(Collections.singleton(Source.create((FileObject)nextFo)), (UserTask)new UserTask(this){
                        final /* synthetic */ JsCodeCompletion this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result parserResult = resultIterator.getParserResult();
                            if (parserResult instanceof JsParserResult) {
                                JsParserResult jsInfo = (JsParserResult)parserResult;
                                String fqn = indexedElement.getFQN();
                                JsObject jsObjectGlobal = Model.getModel((ParserResult)jsInfo, (boolean)false).getGlobalObject();
                                JsObject property = ModelUtils.findJsObjectByName((JsObject)jsObjectGlobal, (String)fqn);
                                if (property != null) {
                                    Documentation doc;
                                    result[0] = doc = property.getDocumentation();
                                }
                            } else {
                                LOGGER.log(Level.INFO, "Not instance of JsParserResult: {0}", parserResult);
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
            if (result[0] != null) {
                return result[0];
            }
        } else if (element instanceof JsObject && (jsObject = (JsObject)element).getDocumentation() != null) {
            return jsObject.getDocumentation();
        }
        for (CompletionProvider interceptor : EditorExtender.getDefault().getCompletionProviders()) {
            String doc = interceptor.getHelpDocumentation(info, element);
            if (doc == null || doc.isEmpty()) continue;
            return Documentation.create((String)doc);
        }
        if (element instanceof ElementDocumentation) {
            return ((ElementDocumentation)element).getDocumentation();
        }
        if (OffsetRange.NONE.equals((Object)element.getOffsetRange(info))) {
            return Documentation.create((String)NbBundle.getMessage(JsCodeCompletion.class, (String)"MSG_ItemFromUsageDoc"));
        }
        return Documentation.create((String)NbBundle.getMessage(JsCodeCompletion.class, (String)"MSG_DocNotAvailable"));
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Token token;
        String prefix = "";
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return null;
        }
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)info.getSnapshot(), (int)caretOffset);
        if (ts == null) {
            return null;
        }
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) != null && token.id() != JsTokenId.EOL) {
            int end;
            JsTokenId id = (JsTokenId)token.id();
            if (id == JsTokenId.STRING_END && ts.movePrevious()) {
                if (ts.token().id() == JsTokenId.STRING_BEGIN) {
                    return "";
                }
                ts.moveNext();
            }
            if (id == JsTokenId.STRING) {
                prefix = token.text().toString();
                if (upToOffset) {
                    end = offset - ts.offset();
                    int prefixIndex = JsCodeCompletion.getPrefixIndexFromSequence(prefix.substring(0, end));
                    prefix = prefix.substring(prefixIndex, end);
                }
            }
            if (id == JsTokenId.IDENTIFIER || id == JsTokenId.PRIVATE_IDENTIFIER || id.isKeyword()) {
                prefix = token.text().toString();
                if (upToOffset && (end = offset - ts.offset()) >= 0) {
                    prefix = prefix.substring(0, Math.min(end, prefix.length()));
                }
            }
            if (id == JsTokenId.DOC_COMMENT) {
                TokenSequence docTokenSeq = LexUtilities.getJsDocumentationTokenSequence((Snapshot)info.getSnapshot(), (int)offset);
                if (docTokenSeq == null) {
                    return null;
                }
                docTokenSeq.move(offset);
                if (!docTokenSeq.moveNext() && !docTokenSeq.movePrevious()) {
                    return null;
                }
                if (docTokenSeq.token().id() == JsDocumentationTokenId.KEYWORD) {
                    prefix = docTokenSeq.token().text().toString();
                    if (upToOffset) {
                        prefix = prefix.substring(0, offset - docTokenSeq.offset());
                    }
                } else {
                    docTokenSeq.movePrevious();
                    prefix = docTokenSeq.token().text().toString();
                }
            }
            if (id.isError()) {
                prefix = token.text().toString();
                prefix = prefix.substring(0, offset - ts.offset());
            }
        }
        LOGGER.log(Level.FINE, String.format("Prefix for cc: %s", prefix));
        return prefix;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        if (typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int offset = component.getCaretPosition();
        TokenSequence ts = LexUtilities.getJsTokenSequence((Document)component.getDocument(), (int)offset);
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (diff == 0 && ts.movePrevious() || ts.moveNext()) {
                currentTokenId = ts.token().id();
            }
            char lastChar = typedText.charAt(typedText.length() - 1);
            if (currentTokenId == JsTokenId.BLOCK_COMMENT || currentTokenId == JsTokenId.DOC_COMMENT || currentTokenId == JsTokenId.LINE_COMMENT) {
                if (lastChar == '@') {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
            } else {
                if (currentTokenId == JsTokenId.STRING && lastChar == '/') {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
                switch (lastChar) {
                    case '.': {
                        if (!OptionsUtils.forLanguage((Language<JsTokenId>)JsTokenId.javascriptLanguage()).autoCompletionAfterDot()) break;
                        return CodeCompletionHandler.QueryType.COMPLETION;
                    }
                    default: {
                        if (OptionsUtils.forLanguage((Language<JsTokenId>)JsTokenId.javascriptLanguage()).autoCompletionFull() && !Character.isWhitespace(lastChar) && CHARS_NO_AUTO_COMPLETE.indexOf(lastChar) == -1) {
                            return CodeCompletionHandler.QueryType.COMPLETION;
                        }
                        return CodeCompletionHandler.QueryType.NONE;
                    }
                }
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private void completeExpression(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedItems) {
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        addedItems.putAll(this.getDomCompletionResults(request));
        Index index = Index.get((FileObject)fo);
        Collection fromIndex = index.getGlobalVar(request.prefix);
        for (IndexedElement indexedElement : fromIndex) {
            this.addPropertyToMap(request, addedItems, (JsElement)indexedElement);
        }
        for (JsObject libGlobal : ModelUtils.getExtendingGlobalObjects((FileObject)fo)) {
            for (JsObject object : libGlobal.getProperties().values()) {
                this.addPropertyToMap(request, addedItems, (JsElement)object);
            }
        }
        for (JsObject object : Model.getModel((ParserResult)request.result, (boolean)false).getVariables(request.anchor)) {
            if (object instanceof JsFunction && ((JsFunction)object).isAnonymous()) continue;
            this.addPropertyToMap(request, addedItems, (JsElement)object);
        }
    }

    private void completeObjectProperty(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        List expChain = ModelUtils.resolveExpressionChain((Snapshot)request.result.getSnapshot(), (int)request.anchor, (boolean)false);
        if (!expChain.isEmpty()) {
            Map<String, List<JsElement>> toAdd = this.getCompletionFromExpressionChain(request, expChain);
            if (request.cancelSupport.isCancelled()) {
                return;
            }
            FileObject fo = request.result.getSnapshot().getSource().getFileObject();
            if (fo != null) {
                long start = System.currentTimeMillis();
                Collection fromUsages = Index.get((FileObject)request.result.getSnapshot().getSource().getFileObject()).getUsagesFromExpression(expChain);
                for (IndexedElement indexedElement : fromUsages) {
                    if (fo.equals(indexedElement.getFileObject()) && indexedElement.getName().equals(request.prefix)) continue;
                    this.addPropertyToMap(request, addedItems, (JsElement)indexedElement);
                }
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, String.format("Counting cc based on usages took: %dms", end - start));
            }
            addedItems.putAll(toAdd);
        }
    }

    private Map<String, List<JsElement>> getCompletionFromExpressionChain(JsCompletionItem.CompletionRequest request, List<String> expChain) {
        boolean bl;
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        Index jsIndex = Index.get((FileObject)fo);
        Collection<TypeUsage> resolveTypeFromExpression = new ArrayList();
        HashMap<String, List<JsElement>> addedProperties = new HashMap<String, List<JsElement>>();
        resolveTypeFromExpression.addAll(ModelUtils.resolveTypeFromExpression((Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, expChain, (int)request.anchor, (boolean)true));
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        resolveTypeFromExpression = ModelUtils.resolveTypes(resolveTypeFromExpression, (Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, (boolean)true);
        ArrayList<CallSite> windowProp = new ArrayList<CallSite>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            if (!typeUsage.isResolved() || typeUsage.getType().startsWith("window")) continue;
            windowProp.add((CallSite)((Object)("window." + typeUsage.getType())));
        }
        ArrayList prototypeChain = new ArrayList();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            prototypeChain.addAll(ModelUtils.findPrototypeChain((String)typeUsage.getType(), (Index)jsIndex));
        }
        for (String string : windowProp) {
            resolveTypeFromExpression.add(new TypeUsage(string));
        }
        for (String string : prototypeChain) {
            resolveTypeFromExpression.add(new TypeUsage(string));
        }
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        boolean bl2 = false;
        ArrayList<JsObject> arrayList = new ArrayList<JsObject>();
        for (TypeUsage typeUsage : resolveTypeFromExpression) {
            boolean bl3;
            this.checkRecursion = 0;
            boolean addFunctionProp = this.processTypeInModel(request, Model.getModel((ParserResult)request.result, (boolean)false), typeUsage, arrayList, expChain.get(1).equals("@pro"), jsIndex, addedProperties);
            boolean bl4 = bl3 = bl3 || addFunctionProp;
            if (!typeUsage.isResolved()) continue;
            this.addObjectPropertiesFromIndex(typeUsage.getType(), jsIndex, request, addedProperties, true);
        }
        boolean isPublic = arrayList.isEmpty();
        for (JsObject resolved : arrayList) {
            if (!bl && resolved.getJSKind().isFunction()) {
                bl = true;
            }
            this.addObjectPropertiesToCC(resolved, request, addedProperties);
            if (!resolved.isDeclared()) {
                this.addObjectPropertiesFromIndex(resolved.getFullyQualifiedName(), jsIndex, request, addedProperties, true);
                isPublic = true;
                continue;
            }
            if (resolved.getModifiers().contains(Modifier.PRIVATE)) continue;
            isPublic = true;
        }
        if (bl) {
            this.addObjectPropertiesFromIndex("Function", jsIndex, request, addedProperties, true);
        }
        if (request.cancelSupport.isCancelled()) {
            return addedProperties;
        }
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedProperties, true);
        if (isPublic) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = expChain.size() - 1; i > -1; --i) {
                stringBuilder.append(expChain.get(--i));
                stringBuilder.append('.');
            }
            if (stringBuilder.length() > 0) {
                Collection indexResults = jsIndex.getPropertiesWithPrefix(stringBuilder.toString().substring(0, stringBuilder.length() - 1), request.prefix);
                for (IndexedElement indexedElement : indexResults) {
                    if (indexedElement.isAnonymous() || !indexedElement.getModifiers().contains(Modifier.PUBLIC)) continue;
                    this.addPropertyToMap(request, addedProperties, (JsElement)indexedElement);
                }
            }
        }
        return addedProperties;
    }

    private Identifier findNameOfFunctionCall(JsCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.result.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return null;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return null;
        }
        ts.move(request.anchor);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        int curlyDeep = 0;
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        while (ts.movePrevious() && tokenId != JsTokenId.BRACKET_LEFT_PAREN && tokenId != JsTokenId.OPERATOR_SEMICOLON) {
            if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                ++curlyDeep;
            }
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (tokenId == JsTokenId.BRACKET_LEFT_PAREN && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER)) {
            String functionName = token.text().toString();
            return new Identifier(functionName, new OffsetRange(ts.offset(), ts.offset() + functionName.length()));
        }
        return null;
    }

    private List<IndexedElement.FunctionIndexedElement> findFunctionInIndex(Identifier functionName, JsCompletionItem.CompletionRequest request) {
        ArrayList<IndexedElement.FunctionIndexedElement> result;
        block5: {
            result = new ArrayList<IndexedElement.FunctionIndexedElement>();
            List expChain = ModelUtils.resolveExpressionChain((Snapshot)request.result.getSnapshot(), (int)(functionName.getOffsetRange().getStart() - 1), (boolean)false);
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            if (fo == null) break block5;
            Index jsIndex = Index.get((FileObject)fo);
            if (expChain.isEmpty()) {
                Collection globalVars = jsIndex.getGlobalVar(functionName.getName());
                for (IndexedElement globalVar : globalVars) {
                    if (!globalVar.getName().equals(functionName.getName()) || !globalVar.getJSKind().isFunction()) continue;
                    result.add((IndexedElement.FunctionIndexedElement)globalVar);
                }
            } else {
                Collection types = ModelUtils.resolveTypeFromExpression((Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, (List)expChain, (int)request.anchor, (boolean)false);
                for (TypeUsage type : types) {
                    Collection properties = jsIndex.getPropertiesWithPrefix(type.getType(), functionName.getName());
                    properties.addAll(jsIndex.getPropertiesWithPrefix(type.getType() + ".prototype", functionName.getName()));
                    for (IndexedElement property : properties) {
                        if (!property.getName().equals(functionName.getName()) || !property.getJSKind().isFunction()) continue;
                        IndexedElement.FunctionIndexedElement function = (IndexedElement.FunctionIndexedElement)property;
                        result.add(function);
                    }
                }
            }
        }
        return result;
    }

    private List<TypeUsage> findPossibleCallArgTypes(JsCompletionItem.CompletionRequest request) {
        Identifier functionName = this.findNameOfFunctionCall(request);
        if (functionName == null) {
            return null;
        }
        ArrayList<TypeUsage> result = new ArrayList<TypeUsage>();
        List<IndexedElement.FunctionIndexedElement> functions = this.findFunctionInIndex(functionName, request);
        for (IndexedElement.FunctionIndexedElement function : functions) {
            LinkedHashMap parameters = function.getParameters();
            for (Collection assignments : parameters.values()) {
                if (assignments.isEmpty()) continue;
                for (String assignment : assignments) {
                    result.add(new TypeUsage(assignment));
                }
            }
        }
        return result;
    }

    private void completeObjectPropertyName(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        TokenHierarchy th = request.result.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return;
        }
        ts.move(request.anchor);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return;
        }
        int curlyDeep = 0;
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        while (ts.movePrevious() && tokenId != JsTokenId.BRACKET_LEFT_PAREN && tokenId != JsTokenId.OPERATOR_SEMICOLON) {
            if (tokenId == JsTokenId.BRACKET_LEFT_CURLY) {
                ++curlyDeep;
            }
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (curlyDeep == 1 && tokenId == JsTokenId.BRACKET_LEFT_PAREN && (token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)) != null && (token.id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER)) {
            String functionName = token.text().toString();
            List expChain = ModelUtils.resolveExpressionChain((Snapshot)request.result.getSnapshot(), (int)(ts.offset() - 1), (boolean)false);
            ArrayList<TypeUsage> possibleTypes = new ArrayList<TypeUsage>();
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            Index jsIndex = Index.get((FileObject)fo);
            if (expChain.isEmpty()) {
                Object variable2;
                Collection variables = ModelUtils.getVariables((Model)Model.getModel((ParserResult)request.result, (boolean)false), (int)request.anchor);
                for (Object variable2 : variables) {
                    if (!variable2.getName().equals(functionName) || !variable2.getJSKind().isFunction()) continue;
                    JsFunction function = (JsFunction)variable2;
                    Collection parameters = function.getParameters();
                    for (Object parameter : parameters) {
                        if (parameter.getAssignments().isEmpty()) continue;
                        possibleTypes.addAll(parameter.getAssignments());
                    }
                }
                Collection globalVars = jsIndex.getGlobalVar(functionName);
                variable2 = globalVars.iterator();
                while (variable2.hasNext()) {
                    IndexedElement globalVar = (IndexedElement)variable2.next();
                    if (!globalVar.getName().equals(functionName) || !globalVar.getJSKind().isFunction()) continue;
                    IndexedElement.FunctionIndexedElement function = (IndexedElement.FunctionIndexedElement)globalVar;
                    LinkedHashMap parameters = function.getParameters();
                    for (Collection assignments : parameters.values()) {
                        if (assignments.isEmpty()) continue;
                        for (String type : assignments) {
                            possibleTypes.add(new TypeUsage(type));
                        }
                    }
                }
            } else {
                Collection types = ModelUtils.resolveTypeFromExpression((Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, (List)expChain, (int)request.anchor, (boolean)false);
                for (TypeUsage type : types) {
                    Collection properties = jsIndex.getPropertiesWithPrefix(type.getType(), functionName);
                    properties.addAll(jsIndex.getPropertiesWithPrefix(type.getType() + ".prototype", functionName));
                    for (IndexedElement property : properties) {
                        if (!property.getName().equals(functionName) || !property.getJSKind().isFunction()) continue;
                        IndexedElement.FunctionIndexedElement function = (IndexedElement.FunctionIndexedElement)property;
                        LinkedHashMap parameters = function.getParameters();
                        for (Collection assignments : parameters.values()) {
                            if (assignments.isEmpty()) continue;
                            for (String assignment : assignments) {
                                possibleTypes.add(new TypeUsage(assignment));
                            }
                        }
                    }
                }
            }
            if (!possibleTypes.isEmpty()) {
                for (TypeUsage type : possibleTypes) {
                    this.addObjectPropertiesFromIndex(type.getType(), jsIndex, request, addedItems, true);
                }
            }
        }
    }

    private void completeNumberProperties(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        Index jsIndex = Index.get((FileObject)fo);
        this.addObjectPropertiesFromIndex("Number", jsIndex, request, addedItems, false);
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedItems, false);
    }

    private void completeStringProperties(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        Index jsIndex = Index.get((FileObject)fo);
        this.addObjectPropertiesFromIndex("String", jsIndex, request, addedItems, false);
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedItems, false);
    }

    private void completeRegExpProperties(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        Index jsIndex = Index.get((FileObject)fo);
        this.addObjectPropertiesFromIndex("RegExp", jsIndex, request, addedItems, false);
        this.addObjectPropertiesFromIndex("Object", jsIndex, request, addedItems, false);
    }

    private List<String> resolveExpressionChainFromString(JsCompletionItem.CompletionRequest request) {
        TokenHierarchy th = request.info.getSnapshot().getTokenHierarchy();
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)request.anchor);
        if (ts == null) {
            return Collections.emptyList();
        }
        int offset = request.info.getSnapshot().getEmbeddedOffset(request.anchor);
        ts.move(offset);
        String text = null;
        if (ts.moveNext()) {
            if (ts.token().id() == JsTokenId.STRING_END) {
                if (ts.movePrevious() && ts.token().id() == JsTokenId.STRING) {
                    text = ts.token().text().toString();
                }
            } else if (ts.token().id() == JsTokenId.STRING) {
                text = ts.token().text().toString().substring(0, offset - ts.offset());
            }
        }
        if (text != null && !text.isEmpty()) {
            int index = text.length() - 1;
            ArrayList<String> exp = new ArrayList<String>();
            int parenBalancer = 0;
            boolean methodCall = false;
            char ch = text.charAt(index);
            Object part = "";
            while (index > -1 && ch != ' ' && ch != '\n' && ch != ';' && ch != '}' && ch != '{' && ch != '(' && ch != '=' && ch != '+' && ch != '[') {
                if (ch == '.') {
                    if (!((String)part).isEmpty()) {
                        exp.add((String)part);
                        part = "";
                        if (methodCall) {
                            exp.add("@mtd");
                            methodCall = false;
                        } else {
                            exp.add("@pro");
                        }
                    }
                } else if (ch == ')') {
                    ++parenBalancer;
                    methodCall = true;
                    while (parenBalancer > 0 && --index > -1) {
                        ch = text.charAt(index);
                        if (ch == ')') {
                            ++parenBalancer;
                            continue;
                        }
                        if (ch != '(') continue;
                        --parenBalancer;
                    }
                } else {
                    part = ch + (String)part;
                }
                if (--index <= -1) continue;
                ch = text.charAt(index);
            }
            if (!((String)part).isEmpty()) {
                exp.add((String)part);
                if (methodCall) {
                    exp.add("@mtd");
                } else {
                    exp.add("@pro");
                }
            }
            return exp;
        }
        return Collections.emptyList();
    }

    private void completeObjectMember(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedItems) {
        boolean startThis;
        JsParserResult result = (JsParserResult)request.info;
        JsObject jsObject = (JsObject)ModelUtils.getDeclarationScope((Model)Model.getModel((ParserResult)result, (boolean)false), (int)request.anchor);
        if (jsObject.getJSKind() == JsElement.Kind.METHOD) {
            jsObject = jsObject.getParent();
        }
        this.completeObjectMembers(jsObject, request, addedItems, !(startThis = this.startWithThis(request)));
        if ("prototype".equals(jsObject.getName())) {
            this.completeObjectMembers(jsObject.getParent(), request, addedItems, !startThis);
        }
    }

    private void addFqn(JsCompletionItem.CompletionRequest request, String fqn) {
        if (fqn == null) {
            return;
        }
        if (fqn.indexOf(64) >= 0 || fqn.indexOf(35) >= 0) {
            return;
        }
        request.fqnTypes.add(fqn);
    }

    private void completeObjectMembers(JsObject jsObject, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> properties, boolean includePrivate) {
        if (jsObject.getJSKind() == JsElement.Kind.OBJECT || jsObject.getJSKind() == JsElement.Kind.CONSTRUCTOR || jsObject.getJSKind() == JsElement.Kind.OBJECT_LITERAL || jsObject.getJSKind() == JsElement.Kind.CLASS) {
            for (JsObject property : jsObject.getProperties().values()) {
                if (request.completionContext == CompletionContext.OBJECT_MEMBERS && property.getModifiers().contains(Modifier.PRIVATE) && !includePrivate && property.getModifiers().size() == 1 || property.isAnonymous()) continue;
                this.addPropertyToMap(request, properties, (JsElement)property);
            }
        }
        String fqn = jsObject.getFullyQualifiedName();
        FileObject fo = request.info.getSnapshot().getSource().getFileObject();
        Collection indexedProperties = Index.get((FileObject)fo).getProperties(fqn);
        for (IndexedElement indexedElement : indexedProperties) {
            this.addPropertyToMap(request, properties, (JsElement)indexedElement);
        }
    }

    private boolean startWithThis(JsCompletionItem.CompletionRequest request) {
        Token token;
        boolean result = false;
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)request.info.getSnapshot(), (int)request.anchor);
        if (ts == null) {
            return result;
        }
        ts.move(request.info.getSnapshot().getEmbeddedOffset(request.anchor));
        if (ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.PRIVATE_IDENTIFIER, JsTokenId.IDENTIFIER, JsTokenId.OPERATOR_DOT, JsTokenId.OPERATOR_OPTIONAL_ACCESS))) != null && JsTokenId.KEYWORD_THIS == token.id()) {
            result = true;
        }
        return result;
    }

    private void completeInWith(JsCompletionItem.CompletionRequest request, HashMap<String, List<JsElement>> addedItems) {
        int offset = request.anchor;
        Collection typesFromWith = ModelUtils.getTypeFromWith((Model)Model.getModel((ParserResult)request.result, (boolean)false), (int)offset);
        if (!typesFromWith.isEmpty()) {
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            Index jsIndex = Index.get((FileObject)fo);
            Collection resolveTypes = ModelUtils.resolveTypes((Collection)typesFromWith, (Model)Model.getModel((ParserResult)request.result, (boolean)false), (Index)jsIndex, (boolean)true);
            for (TypeUsage type : resolveTypes) {
                JsObject localObject = ModelUtils.findJsObjectByName((Model)Model.getModel((ParserResult)request.result, (boolean)false), (String)type.getType());
                if (localObject != null) {
                    this.addObjectPropertiesToCC(localObject, request, addedItems);
                }
                this.addObjectPropertiesFromIndex(type.getType(), jsIndex, request, addedItems, true);
            }
        }
    }

    private void completeCallArguments(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        List<TypeUsage> types = this.findPossibleCallArgTypes(request);
        FileObject fo = request.result.getSnapshot().getSource().getFileObject();
        if (types != null && fo != null && !types.isEmpty()) {
            Index jsIndex = Index.get((FileObject)fo);
            for (TypeUsage type : types) {
                Collection fromIndex = jsIndex.findByFqn(type.getType(), Index.TERMS_BASIC_INFO);
                for (IndexResult indexResult : fromIndex) {
                    IndexedElement indexElement = IndexedElement.create((IndexResult)indexResult);
                    if (indexElement.getJSKind() != JsElement.Kind.CALLBACK) continue;
                    resultList.add(new JsCompletionItem.JsCallbackCompletionItem((IndexedElement.FunctionIndexedElement)indexElement, request));
                }
            }
        }
    }

    private void completeKeywords(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (Map.Entry<String, JsKeywords.CompletionDescription> entry : JsKeywords.KEYWORDS.entrySet()) {
            if (!this.startsWith(entry.getKey(), request.prefix)) continue;
            resultList.add(new JsCompletionItem.KeywordItem(entry.getKey(), entry.getValue(), request));
        }
    }

    private void addImportExportKeywords(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        for (Map.Entry<String, JsKeywords.CompletionDescription> entry : JsKeywords.SPECIAL_KEYWORDS_IMPORTEXPORT.entrySet()) {
            if (!this.startsWith(entry.getKey(), request.prefix)) continue;
            resultList.add(new JsCompletionItem.KeywordItem(entry.getKey(), entry.getValue(), request));
        }
    }

    private void completeJsModuleNames(JsCompletionItem.CompletionRequest request, List<CompletionProposal> resultList) {
        Snapshot snapshot = request.info.getSnapshot();
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)request.anchor);
        if (ts == null) {
            return;
        }
        int offset = snapshot.getEmbeddedOffset(request.anchor);
        ts.move(offset);
        String prefix = request.prefix;
        String writtenPath = request.prefix;
        if (ts.moveNext() && (ts.token().id() == JsTokenId.STRING_END || ts.token().id() == JsTokenId.STRING)) {
            if (ts.token().id() == JsTokenId.STRING_END) {
                ts.movePrevious();
            }
            if (ts.token().id() == JsTokenId.STRING) {
                String text = ts.token().text().toString();
                writtenPath = text.substring(0, offset - ts.offset());
            }
        }
        FileObject fo = snapshot.getSource().getFileObject();
        try {
            List<CompletionProposal> relativeFiles = FileUtils.computeRelativeItems(Collections.singletonList(fo), writtenPath, offset, false, false, file -> file.isFolder() || "js".equalsIgnoreCase(file.getExt()) && file.getName().startsWith(prefix));
            resultList.addAll(relativeFiles);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, ex, null);
        }
    }

    private boolean startsWith(String theString, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean processTypeInModel(JsCompletionItem.CompletionRequest request, Model model, TypeUsage type, List<JsObject> lastResolvedObjects, boolean prop, Index index, Map<String, List<JsElement>> addedProperties) {
        ++this.checkRecursion;
        if (this.checkRecursion > 10) {
            return false;
        }
        boolean isFunction = false;
        JsObject jsObject = ModelUtils.findJsObjectByName((Model)model, (String)type.getType());
        if (jsObject != null) {
            lastResolvedObjects.add(jsObject);
        }
        for (JsObject libGlobal : ModelUtils.getExtendingGlobalObjects((FileObject)request.result.getSnapshot().getSource().getFileObject())) {
            JsObject found = ModelUtils.findJsObjectByName((JsObject)libGlobal, (String)type.getType());
            if (found == null || found == libGlobal) continue;
            jsObject = found;
            lastResolvedObjects.add(jsObject);
            break;
        }
        if (jsObject == null || !jsObject.isDeclared()) {
            boolean isObject = type.getType().equals("Object");
            if (prop && !isObject) {
                for (IndexResult indexResult : index.findByFqn(type.getType(), new String[]{"flag"})) {
                    JsElement.Kind kind = IndexedElement.Flag.getJsKind((int)Integer.parseInt(indexResult.getValue("flag")));
                    if (!kind.isFunction()) continue;
                    isFunction = true;
                }
            }
            if (!isObject) {
                this.addObjectPropertiesFromIndex(type.getType(), index, request, addedProperties, true);
            }
        } else if (jsObject.getDeclarationName() != null) {
            Collection assignments = jsObject.getAssignmentForOffset(jsObject.getDeclarationName().getOffsetRange().getEnd());
            for (TypeUsage assignment : assignments) {
                boolean isFun = this.processTypeInModel(request, model, assignment, lastResolvedObjects, prop, index, addedProperties);
                isFunction = isFunction ? true : isFun;
            }
        }
        return isFunction;
    }

    private void addObjectPropertiesToCC(JsObject jsObject, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties) {
        JsObject prototype = jsObject.getProperty("prototype");
        if (prototype != null) {
            this.addObjectPropertiesToCC(prototype, request, addedProperties);
        }
        for (JsObject property : jsObject.getProperties().values()) {
            if (property instanceof JsFunction && ((JsFunction)property).isAnonymous() || ModelUtils.getDisplayName((String)property.getName()).isEmpty() || property.getModifiers().contains(Modifier.PRIVATE) || property.getJSKind().isPropertyGetterSetter()) continue;
            this.addPropertyToMap(request, addedProperties, (JsElement)property);
        }
    }

    private void addObjectPropertiesFromIndex(String fqn, Index jsIndex, JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties, boolean includeStatic) {
        Collection properties = jsIndex.getProperties(fqn);
        for (IndexedElement indexedElement : properties) {
            if (!includeStatic && (includeStatic || indexedElement.getModifiers().contains(Modifier.STATIC))) continue;
            this.addPropertyToMap(request, addedProperties, (JsElement)indexedElement);
            if (!"prototype".equals(indexedElement.getName())) continue;
            Collection protoProperties = jsIndex.getProperties(indexedElement.getFQN());
            for (IndexedElement protoProperty : protoProperties) {
                this.addPropertyToMap(request, addedProperties, (JsElement)protoProperty);
            }
        }
        this.addFqn(request, fqn);
    }

    private void addPropertyToMap(JsCompletionItem.CompletionRequest request, Map<String, List<JsElement>> addedProperties, JsElement property) {
        String name = property.getName();
        if (this.startsWith(name, request.prefix) && !ModelUtils.getDisplayName((String)property.getName()).isEmpty() && property.getJSKind() != JsElement.Kind.CALLBACK && (!name.equals(request.prefix) || property.isDeclared() || request.anchor != property.getOffset())) {
            List<JsElement> elements = addedProperties.get(name);
            if (!"prototype".equals(name)) {
                if (elements == null || elements.isEmpty()) {
                    ArrayList<JsElement> properties = new ArrayList<JsElement>(1);
                    if (this.isPrivateInClass(property)) {
                        if (((JsObject)property).getParent().getOffsetRange().containsInclusive(request.anchor)) {
                            properties.add(property);
                            addedProperties.put(name, properties);
                        }
                    } else {
                        properties.add(property);
                        addedProperties.put(name, properties);
                    }
                } else if (property.isDeclared()) {
                    boolean addAsNew = true;
                    if (!elements.isEmpty()) {
                        for (int i = 0; i < elements.size(); ++i) {
                            JsElement element = elements.get(i);
                            FileObject fo = element.getFileObject();
                            if (!element.isDeclared() || fo != null && fo.equals(property.getFileObject())) {
                                if (!element.isDeclared() || element.getOffsetRange() == OffsetRange.NONE && property.getOffsetRange() != OffsetRange.NONE) {
                                    elements.remove(i);
                                    elements.add(property);
                                    addAsNew = false;
                                    break;
                                }
                                if (fo == null || !fo.equals(property.getFileObject())) continue;
                                addAsNew = false;
                                break;
                            }
                            if (!element.isPlatform() || !property.isPlatform()) continue;
                            addAsNew = false;
                            break;
                        }
                    }
                    if (addAsNew) {
                        elements.add(property);
                    }
                }
            } else if (elements == null && property.isPlatform()) {
                ArrayList<JsElement> properties = new ArrayList<JsElement>(1);
                properties.add(property);
                addedProperties.put(name, properties);
            }
        }
    }

    private boolean isPrivateInClass(JsElement element) {
        if (element instanceof JsObject) {
            JsObject eo = (JsObject)element;
            if (eo.getParent().getJSKind() != JsElement.Kind.CLASS) {
                return false;
            }
            return element.getModifiers().contains(Modifier.PRIVATE) || element.getModifiers().contains(Modifier.PROTECTED);
        }
        return false;
    }

    private Map<String, List<JsElement>> getDomCompletionResults(JsCompletionItem.CompletionRequest request) {
        HashMap<String, List<JsElement>> result = new HashMap<String, List<JsElement>>(1);
        result.putAll(this.getCompletionFromExpressionChain(request, WINDOW_EXPRESSION_CHAIN));
        return result;
    }

    private static int getPrefixIndexFromSequence(String prefix) {
        int spaceIndex = prefix.lastIndexOf(" ") + 1;
        int dotIndex = prefix.lastIndexOf(".") + 1;
        int hashIndex = prefix.lastIndexOf("#") + 1;
        int bracketIndex = prefix.lastIndexOf("[") + 1;
        int columnIndex = prefix.lastIndexOf(":") + 1;
        int parenIndex = prefix.lastIndexOf("(") + 1;
        int slashIndex = prefix.lastIndexOf(47) + 1;
        return Math.max(0, Math.max(hashIndex, Math.max(dotIndex, Math.max(parenIndex, Math.max(columnIndex, Math.max(bracketIndex, Math.max(spaceIndex, slashIndex)))))));
    }
}

