/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LayerUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.ui.DeveloperToolbar;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class HtmlPreviewElement
implements MultiViewElement {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLayer<JPanel> layer;
    private final DeveloperToolbar toolbar = DeveloperToolbar.create();
    private HtmlBrowser.Impl browser = null;
    private final EditorCookie.Observable editorCookie;
    private final DocumentListener documentListener;
    private final PropertyChangeListener editorListener;
    private final Lookup lookup;
    private Method methodSetBrowserContent;
    private Timer refreshTimer;
    private static final Logger LOG = Logger.getLogger(HtmlPreviewElement.class.getName());

    public HtmlPreviewElement(Lookup lkp) {
        this.editorCookie = (EditorCookie.Observable)lkp.lookup(EditorCookie.Observable.class);
        this.layer = new JLayer<JPanel>(this.panel, new NoLeftClickLayerUI());
        this.layer.setLayerEventMask(16L);
        this.lookup = lkp;
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HtmlPreviewElement.this.scheduleReload();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HtmlPreviewElement.this.scheduleReload();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HtmlPreviewElement.this.scheduleReload();
            }
        };
        this.editorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("openedPanes".equals(evt.getPropertyName())) {
                    HtmlPreviewElement.this.dettach();
                    HtmlPreviewElement.this.attach();
                } else if ("modified".equals(evt.getPropertyName()) && !HtmlPreviewElement.this.editorCookie.isModified()) {
                    HtmlPreviewElement.this.reloadFromFile();
                }
            }
        };
    }

    static MultiViewDescription createMultiViewDescription(Map map) {
        if (Boolean.getBoolean("nb.html.preview.enabled")) {
            try {
                Method m = MultiViewFactory.class.getDeclaredMethod("createMultiViewDescription", Map.class);
                m.setAccessible(true);
                return (MultiViewDescription)m.invoke(null, map);
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Cannot create multiview description.", e);
            }
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this.panel;
    }

    public JComponent getToolbarRepresentation() {
        return (JComponent)this.toolbar.getComponent();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public Action[] getActions() {
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        this.panel.removeAll();
        this.browser = null;
        this.methodSetBrowserContent = null;
        this.dettach();
    }

    public void componentShowing() {
        this.initBrowser();
        this.attach();
    }

    public void componentHidden() {
        this.dettach();
    }

    public void componentActivated() {
        if (null != this.browser) {
            this.browser.reloadDocument();
        }
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    private void initBrowser() {
        if (null != this.browser) {
            return;
        }
        WebBrowser web = WebBrowsers.getInstance().getPreferred();
        if (null != web && !web.isEmbedded()) {
            for (WebBrowser wb : WebBrowsers.getInstance().getAll(false, false, false)) {
                if (!wb.isEmbedded()) continue;
                web = wb;
                break;
            }
        }
        this.panel.removeAll();
        if (null == web || !web.isEmbedded()) {
            this.panel.add((Component)new JLabel("No embedded browser available"), "Center");
        } else {
            this.browser = web.getHtmlBrowserFactory().createHtmlBrowserImpl();
            this.toolbar.intialize(this.browser.getLookup());
            this.panel.add(this.browser.getComponent(), "Center");
            this.methodSetBrowserContent = null;
            try {
                this.methodSetBrowserContent = this.browser.getClass().getDeclaredMethod("setContent", String.class);
            }
            catch (Exception e) {
                LOG.log(Level.INFO, null, e);
            }
        }
    }

    private void attach() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPreviewElement.this.attach();
                }
            });
            return;
        }
        if (null != this.editorCookie) {
            StyledDocument doc;
            this.editorCookie.addPropertyChangeListener(this.editorListener);
            JEditorPane[] panes = this.editorCookie.getOpenedPanes();
            if (null != panes && panes.length > 0) {
                panes[0].getDocument();
            }
            if (null != (doc = this.editorCookie.getDocument())) {
                doc.addDocumentListener(this.documentListener);
            }
        }
        this.reloadFromDocument();
    }

    private void scheduleReload() {
        if (null == this.refreshTimer) {
            this.refreshTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlPreviewElement.this.reloadFromDocument();
                }
            });
            this.refreshTimer.setRepeats(false);
            this.refreshTimer.start();
        } else {
            this.refreshTimer.restart();
        }
    }

    private void reloadFromDocument() {
        if (null == this.editorCookie) {
            return;
        }
        StyledDocument doc = this.editorCookie.getDocument();
        this.refresh(doc);
    }

    private void reloadFromFile() {
        if (null == this.browser) {
            return;
        }
        FileObject fileObject = (FileObject)this.lookup.lookup(FileObject.class);
        if (fileObject != null) {
            URL url = fileObject.toURL();
            this.browser.setURL(url);
        }
    }

    private void dettach() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPreviewElement.this.dettach();
                }
            });
            return;
        }
        if (null != this.refreshTimer) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        if (null != this.editorCookie) {
            this.editorCookie.removePropertyChangeListener(this.editorListener);
            StyledDocument doc = this.editorCookie.getDocument();
            if (null != doc) {
                doc.removeDocumentListener(this.documentListener);
            }
        }
    }

    private void refresh(Document doc) {
        if (null == doc) {
            return;
        }
        try {
            String text = doc.getText(0, doc.getLength());
            if (null != this.browser && null != this.methodSetBrowserContent) {
                try {
                    this.methodSetBrowserContent.invoke((Object)this.browser, text);
                }
                catch (Exception ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    class NoLeftClickLayerUI
    extends LayerUI<JPanel> {
        NoLeftClickLayerUI() {
        }

        @Override
        protected void processMouseEvent(MouseEvent e, JLayer<? extends JPanel> panel) {
            super.processMouseEvent(e, panel);
            if (e.getButton() == 1) {
                e.consume();
            }
        }
    }
}

