/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.CodeAction;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.ApiAccessor;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

public class GsfErrorProvider
implements ErrorProvider {
    public List<? extends Diagnostic> computeErrors(final ErrorProvider.Context context) {
        final ArrayList hints = new ArrayList();
        final ArrayList errors = new ArrayList();
        try {
            ParserManager.parse(Collections.singletonList(Source.create((FileObject)context.file())), (UserTask)new UserTask(this){
                final /* synthetic */ GsfErrorProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(context.getOffset());
                    if (result instanceof ParserResult) {
                        GsfHintsManager hintsManager;
                        RuleContext ruleContext;
                        HintsProvider hintsProvider;
                        ParserResult parserResult = (ParserResult)result;
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                        if (language != null && (hintsProvider = language.getHintsProvider()) != null && (ruleContext = (hintsManager = language.getHintsManager()).createRuleContext(parserResult, language, context.getOffset(), -1, -1)) != null) {
                            switch (context.errorKind()) {
                                case ERRORS: {
                                    hintsProvider.computeErrors(hintsManager, ruleContext, hints, errors);
                                    break;
                                }
                                case HINTS: {
                                    hintsProvider.computeHints(hintsManager, ruleContext, hints);
                                    hintsProvider.computeSuggestions(hintsManager, ruleContext, hints, context.getOffset());
                                }
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StyledDocument doc = DataLoadersBridge.getDefault().getDocument(context.file());
        LineDocument lineDocument = doc != null ? (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class) : null;
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(hints.size() + errors.size());
        int idx = 0;
        for (Hint hint : hints) {
            diagnostics.add(this.hint2Diagnostic(hint, ++idx));
        }
        for (Error error : errors) {
            diagnostics.add(this.error2Diagnostic(error, lineDocument, ++idx));
        }
        return diagnostics;
    }

    private Diagnostic error2Diagnostic(Error error, LineDocument lineDocument, int idx) {
        Diagnostic.Builder diagBuilder = Diagnostic.Builder.create(() -> {
            if (lineDocument != null && error.getStartPosition() >= error.getEndPosition()) {
                try {
                    return LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)lineDocument, (int)error.getStartPosition());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return error.getStartPosition();
        }, () -> {
            if (lineDocument != null && error.getStartPosition() >= error.getEndPosition()) {
                try {
                    return LineDocumentUtils.getLineLastNonWhitespace((LineDocument)lineDocument, (int)error.getEndPosition());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return error.getEndPosition();
        }, (String)(error.getDescription() != null ? error.getDescription() : error.getDisplayName()));
        switch (error.getSeverity()) {
            case FATAL: 
            case ERROR: {
                diagBuilder.setSeverity(Diagnostic.Severity.Error);
                break;
            }
            case WARNING: {
                diagBuilder.setSeverity(Diagnostic.Severity.Warning);
                break;
            }
            case INFO: {
                diagBuilder.setSeverity(Diagnostic.Severity.Information);
            }
        }
        String id = "errors:" + idx + "-" + error.getKey();
        diagBuilder.setCode(id);
        return diagBuilder.build();
    }

    private Diagnostic hint2Diagnostic(Hint hint, int idx) {
        OffsetRange range = hint.getRange();
        Diagnostic.Builder diagBuilder = Diagnostic.Builder.create(() -> range.getStart(), () -> range.getEnd(), (String)hint.getDescription());
        switch (hint.getRule().getDefaultSeverity()) {
            case ERROR: {
                diagBuilder.setSeverity(Diagnostic.Severity.Error);
                break;
            }
            case CURRENT_LINE_WARNING: 
            case WARNING: {
                diagBuilder.setSeverity(Diagnostic.Severity.Warning);
                break;
            }
            case INFO: {
                diagBuilder.setSeverity(Diagnostic.Severity.Information);
            }
        }
        String id = "hints:" + idx + "-" + hint.getRule().getDisplayName();
        diagBuilder.setCode(id);
        diagBuilder.addActions(errorReporter -> GsfErrorProvider.convertFixes(hint, errorReporter));
        return diagBuilder.build();
    }

    private static List<CodeAction> convertFixes(Hint hint, Consumer<Exception> errorReporter) {
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        for (HintFix fix : hint.getFixes()) {
            if (!(fix instanceof PreviewableFix)) continue;
            try {
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                for (EditList.Edit edit : ApiAccessor.getInstance().getEdits(((PreviewableFix)fix).getEditList())) {
                    String newText = edit.getInsertText();
                    edits.add(new TextEdit(edit.getOffset(), edit.getOffset() + edit.getRemoveLen(), newText != null ? newText : ""));
                }
                TextDocumentEdit te = new TextDocumentEdit(hint.getFile().toURI().toString(), edits);
                result.add(new CodeAction(fix.getDescription(), new WorkspaceEdit(Collections.singletonList(Union2.createFirst((Object)te)))));
            }
            catch (Exception ex) {
                errorReporter.accept(ex);
            }
        }
        return result;
    }
}

