/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.java.queries.DependencyText;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.openide.util.BaseUtilities;

public class TextDependencyScanner {
    private Set<String> configurationNames = new HashSet<String>();
    private final Map<GradleDependency, String> origins = new HashMap<GradleDependency, String>();
    private final Map<GradleDependency, Map<String, SourceLocation>> locations = new HashMap<GradleDependency, Map<String, SourceLocation>>();
    private final boolean matchScopes;
    private List<DependencyText> dependencies = new ArrayList<DependencyText>();
    private int lastPos;
    private int pos;
    private String contents;
    private DependencyText dep;
    private int tokenStart;
    private String tokenText;
    private Token tokenType;
    int newLinePos;
    private int groupItemsEnd;
    private int groupStartPos;
    private int groupItemCount;
    private int dependencyBlockStart = -1;
    private int dependencyBlockEnd;

    public void addDependencyOrigin(GradleDependency dep, String originConfig) {
        this.origins.put(dep, originConfig);
    }

    public List<DependencyText> getDependencies() {
        return this.dependencies;
    }

    public TextDependencyScanner(boolean matchScopes) {
        this.matchScopes = matchScopes;
    }

    private void backChar() {
        --this.pos;
        --this.lastPos;
    }

    private int nextChar() {
        if (this.pos == this.contents.length()) {
            ++this.pos;
            return -1;
        }
        if (this.pos < this.contents.length()) {
            this.lastPos = this.pos;
            char c = this.contents.charAt(this.pos++);
            return c;
        }
        throw new EndInputException();
    }

    private String readQuotedString(int q) {
        int c;
        int s = this.lastPos;
        do {
            if ((c = this.nextChar()) != 92) continue;
            this.nextChar();
        } while (c != q);
        this.newLinePos = -1;
        String r = this.contents.substring(s, this.lastPos + 1);
        String[] args = BaseUtilities.parseParameters((String)r);
        return args.length == 1 ? args[0] : r;
    }

    private void finishDependency() {
        if (this.dep == null) {
            return;
        }
        ++this.groupItemCount;
        this.dependencies.add(this.dep);
        this.dep = null;
    }

    private int nextToken() {
        this.skipWhitespace();
        int c = this.nextChar();
        if (c == 34 || c == 39) {
            this.tokenText = this.readQuotedString(c);
            this.tokenType = Token.QUOTED;
            return c;
        }
        int s = this.lastPos;
        if (Character.isJavaIdentifierStart(c)) {
            int c2;
            while (Character.isJavaIdentifierPart(c2 = this.nextChar())) {
            }
            this.tokenText = this.contents.substring(s, this.lastPos);
            this.tokenType = Token.IDENTIFIER;
            this.tokenStart = s;
            this.backChar();
        } else {
            this.tokenType = Token.OTHER;
        }
        return c;
    }

    private void skipNestedBlock(int brace) {
        int c;
        block5: while ((c = this.nextToken()) != -1) {
            if (this.tokenType != Token.OTHER) continue;
            switch (c) {
                case 123: {
                    this.skipNestedBlock(125);
                    continue block5;
                }
                case 40: {
                    this.skipNestedBlock(41);
                    continue block5;
                }
                case 91: {
                    this.skipNestedBlock(93);
                    continue block5;
                }
            }
            if (c != brace) continue;
            this.newLinePos = -1;
            return;
        }
    }

    boolean wasEndOfLine() {
        return this.newLinePos != -1;
    }

    private int skipWhitespace() {
        Token skipMode = Token.NONE;
        this.newLinePos = -1;
        block4: while (this.pos < this.contents.length()) {
            char c = this.contents.charAt(this.pos);
            switch (skipMode.ordinal()) {
                case 1: {
                    if (c == '\n') {
                        this.newLinePos = -1;
                        skipMode = Token.NONE;
                        break;
                    }
                    ++this.pos;
                    continue block4;
                }
                case 2: {
                    if (c == '*' && this.pos + 1 < this.contents.length()) {
                        if (this.contents.charAt(this.pos + 1) == '/') {
                            skipMode = Token.NONE;
                            this.newLinePos = -1;
                        }
                        ++this.pos;
                    }
                    ++this.pos;
                    continue block4;
                }
            }
            if (c == '/' && this.pos + 1 < this.contents.length()) {
                c = this.contents.charAt(this.pos + 1);
                if (c == '/') {
                    skipMode = Token.LINECOMMENT;
                    this.newLinePos = -1;
                    this.pos += 2;
                    continue;
                }
                if (c == '*') {
                    skipMode = Token.BLOCKCOMMENT;
                    this.newLinePos = -1;
                    this.pos += 2;
                    continue;
                }
            }
            if (!Character.isWhitespace((int)c)) {
                return c;
            }
            if (c == '\n') {
                this.newLinePos = this.pos;
            }
            ++this.pos;
        }
        return -1;
    }

    private void scanDepdendencyContainer(String container) {
        int braceLevel = 0;
        int kPos = -1;
        int startKpos = -1;
        String kwd = null;
        boolean singleStatement = true;
        boolean continuation = false;
        DependencyText.Part openPart = null;
        StringBuilder typedProjects = null;
        this.groupItemsEnd = -1;
        block12: while (true) {
            if (kPos < 0) {
                int e = this.pos;
                this.skipWhitespace();
                if (braceLevel == 0 && singleStatement && !continuation && this.wasEndOfLine()) {
                    if (this.dep != null) {
                        if (typedProjects != null) {
                            if (kwd != null) {
                                typedProjects.append(':').append(kwd);
                            }
                            this.dep.contents = typedProjects.toString();
                        }
                        this.dep.endPos = e;
                    }
                    return;
                }
                this.newLinePos = -1;
            }
            int c = this.nextChar();
            if (kPos >= 0) {
                if (Character.isJavaIdentifierPart(c)) {
                    this.newLinePos = -1;
                    continue;
                }
                startKpos = kPos;
                kwd = this.contents.substring(kPos, this.lastPos);
                kPos = -1;
                if (openPart != null) {
                    openPart.value = kwd;
                    openPart.endPos = this.lastPos;
                    openPart = null;
                    kwd = null;
                }
            }
            if (braceLevel == 0 && singleStatement && !continuation && (c == 10 || c == 59)) {
                if (this.dep != null) {
                    if (typedProjects != null) {
                        if (kwd != null) {
                            typedProjects.append(':').append(kwd);
                        }
                        this.dep.contents = typedProjects.toString();
                    }
                    this.dep.endPos = c == 10 ? this.lastPos : this.pos;
                }
                return;
            }
            if (Character.isJavaIdentifierStart(c)) {
                kPos = this.lastPos;
                continue;
            }
            continuation = false;
            switch (c) {
                case 46: {
                    if (braceLevel != 0) break;
                    if (this.dep == null) {
                        if (!"projects".equals(kwd)) break;
                        this.dep = new DependencyText(container, startKpos);
                        this.dep.keyword = "project";
                        kwd = null;
                        typedProjects = new StringBuilder();
                        break;
                    }
                    if (typedProjects == null) break;
                    typedProjects.append(':').append(kwd);
                    kwd = null;
                    break;
                }
                case 123: {
                    this.skipNestedBlock(125);
                    if (braceLevel != 0) break;
                    this.groupItemsEnd = this.pos;
                    return;
                }
                case 125: {
                    if (braceLevel == 0) {
                        this.groupItemsEnd = this.pos;
                        return;
                    }
                    --braceLevel;
                    break;
                }
                case 44: {
                    if (braceLevel != 0) break;
                    continuation = true;
                    break;
                }
                case 40: {
                    if (braceLevel > 0) {
                        this.skipNestedBlock(41);
                        break;
                    }
                    if (kwd != null) {
                        if (this.dep == null) {
                            this.dep = new DependencyText(container, this.groupStartPos);
                        }
                        this.dep.keyword = kwd;
                        kwd = null;
                        break;
                    }
                    if (this.dep != null) break;
                    singleStatement = false;
                    break;
                }
                case 41: {
                    if (braceLevel == 0) {
                        this.groupItemsEnd = this.pos;
                        singleStatement = true;
                        int x = this.skipWhitespace();
                        if ((this.wasEndOfLine() || x == 59) && this.dep != null) {
                            this.dep.endPos = this.newLinePos;
                            return;
                        }
                        if (x == 123) continue block12;
                        if (this.dep != null) {
                            this.dep.endPos = this.groupItemsEnd;
                        }
                        return;
                    }
                    if (--braceLevel != 0 || this.dep == null) continue block12;
                    this.dep.endPos = this.pos;
                    this.finishDependency();
                    openPart = null;
                    break;
                }
                case 91: {
                    if (braceLevel > 0) {
                        ++braceLevel;
                        break;
                    }
                    this.dep = new DependencyText(container, this.lastPos);
                    break;
                }
                case 93: {
                    if (braceLevel == 0 && this.dep != null) {
                        this.dep.endPos = this.pos;
                        this.finishDependency();
                        break;
                    }
                    --braceLevel;
                    break;
                }
                case 58: {
                    if (braceLevel > 0) continue block12;
                    if (this.dep == null) {
                        this.dep = new DependencyText(container, this.groupStartPos);
                        s = startKpos;
                    } else {
                        s = startKpos;
                    }
                    openPart = new DependencyText.Part();
                    openPart.startPos = startKpos;
                    openPart.partId = kwd;
                    this.dep.partList.add(openPart);
                    kwd = null;
                    break;
                }
                case 34: 
                case 39: {
                    String qval;
                    CharSequence[] parts;
                    String v;
                    if (this.dep == null) {
                        this.dep = new DependencyText(container, this.lastPos);
                    }
                    if (braceLevel > 0 && openPart == null) {
                        openPart = new DependencyText.Part();
                        openPart.startPos = this.lastPos;
                        this.dep.partList.add(openPart);
                    }
                    if ((v = String.join((CharSequence)" ", parts = BaseUtilities.parseParameters((String)(qval = this.readQuotedString(c))))).trim().isEmpty()) break;
                    if (openPart != null) {
                        openPart.value = v;
                        openPart.endPos = this.pos;
                        openPart = null;
                        break;
                    }
                    if (this.dep == null) break;
                    this.dep.contents = qval;
                    this.dep.endPos = this.pos;
                    this.finishDependency();
                }
            }
        }
    }

    private void buildDependencies() {
        int c;
        boolean onlyAfterNewline = false;
        while ((c = this.nextToken()) != 125) {
            if ((!onlyAfterNewline || this.wasEndOfLine()) && this.tokenType == Token.IDENTIFIER) {
                if (this.configurationNames.contains(this.tokenText)) {
                    String saveToken = this.tokenText;
                    this.groupStartPos = this.tokenStart;
                    this.groupItemCount = 0;
                    this.scanDepdendencyContainer(this.tokenText);
                    this.finishDependency();
                    if (this.groupItemCount == 1) {
                        DependencyText last = this.dependencies.get(this.dependencies.size() - 1);
                        last.startPos = this.groupStartPos;
                        if (this.groupItemsEnd != -1) {
                            last.endPos = this.groupItemsEnd;
                        }
                    } else {
                        DependencyText.Part containerPart = new DependencyText.Part();
                        containerPart.partId = saveToken;
                        containerPart.startPos = this.groupStartPos;
                        containerPart.endPos = this.groupItemsEnd;
                        containerPart.quoted = 0;
                        ArrayList<DependencyText> items = new ArrayList<DependencyText>(this.dependencies.subList(this.dependencies.size() - this.groupItemCount, this.dependencies.size()));
                        DependencyText.Container nc = new DependencyText.Container(items, containerPart);
                        items.forEach(i -> {
                            i.container = nc;
                        });
                    }
                    onlyAfterNewline = false;
                    continue;
                }
                onlyAfterNewline = true;
                continue;
            }
            if (c == 59) {
                onlyAfterNewline = false;
                continue;
            }
            this.skipNestedBlocks(c);
        }
    }

    public TextDependencyScanner withConfigurations(Collection<String> configNames) {
        this.configurationNames.addAll(configNames);
        return this;
    }

    public List<DependencyText> parseDependencyList(String contents) {
        this.contents = contents;
        try {
            this.findDependencyBlock();
            this.buildDependencies();
            this.dependencyBlockEnd = this.pos;
            this.computeGAV();
        }
        catch (EndInputException endInputException) {
            // empty catch block
        }
        return this.dependencies;
    }

    private void skipNestedBlocks(int c) {
        switch (c) {
            case 34: 
            case 39: {
                this.readQuotedString(c);
                break;
            }
            case 40: {
                this.skipNestedBlock(41);
                break;
            }
            case 123: {
                this.skipNestedBlock(125);
                break;
            }
            case 91: {
                this.skipNestedBlock(93);
            }
        }
    }

    private void findDependencyBlock() {
        for (int i = 0; i < this.contents.length(); ++i) {
            int c = this.nextToken();
            if (this.tokenType == Token.IDENTIFIER) {
                if (!"dependencies".equals(this.tokenText)) continue;
                this.dependencyBlockStart = this.tokenStart;
                c = this.skipWhitespace();
                if (c != 123) continue;
                this.nextChar();
                return;
            }
            if (this.tokenType == Token.QUOTED) continue;
            this.skipNestedBlocks(c);
        }
    }

    private void computeGAV() {
        for (DependencyText text : this.dependencies) {
            if (text.contents != null) {
                String[] split = text.contents.split(":");
                text.group = split[0];
                text.name = split[1];
                if (split.length > 2) {
                    text.version = split[2];
                    continue;
                }
                text.version = "";
                continue;
            }
            for (DependencyText.Part p : text.partList) {
                switch (p.partId) {
                    case "group": {
                        text.group = p.value;
                        break;
                    }
                    case "name": {
                        text.name = p.value;
                        break;
                    }
                    case "version": {
                        text.version = p.value;
                    }
                }
            }
            if (text.group != null && text.name != null) continue;
        }
    }

    private boolean scopeMatches(Dependency d, DependencyText t) {
        if (!this.matchScopes) {
            return true;
        }
        if (d.getScope() == null || t.configuration == null) {
            return true;
        }
        return d.getScope().name().equals(t.configuration);
    }

    private DependencyText findDependency(Dependency d) {
        String projectName = null;
        String gav = null;
        String groupAndName = null;
        if (d.getProject() != null) {
            projectName = d.getProject().getProjectId();
        } else {
            StringBuilder sb = new StringBuilder();
            ArtifactSpec as = d.getArtifact();
            if (as == null) {
                return null;
            }
            sb.append(as.getGroupId()).append(":").append(as.getArtifactId());
            groupAndName = sb.toString();
            if (as.getVersionSpec() != null) {
                sb.append(":").append(as.getVersionSpec());
            }
            gav = sb.toString();
        }
        for (DependencyText t : this.dependencies) {
            if ("project".equals(t.keyword) && t.contents.equals(projectName)) {
                return t;
            }
            if (t.keyword != null || !DependencyText.stripStrict(t.getContentsOrGav()).equals(gav) || !this.scopeMatches(d, t)) continue;
            return t;
        }
        for (DependencyText t : this.dependencies) {
            if (t.keyword != null || t.contents == null || !DependencyText.stripStrict(t.contents).equals(groupAndName) || !this.scopeMatches(d, t)) continue;
            return t;
        }
        return null;
    }

    public DependencyText.Mapping mapDependencies(Collection<Dependency> rootDeps) {
        DependencyText.Part containerPart;
        HashMap<Dependency, DependencyText> result = new HashMap<Dependency, DependencyText>();
        for (Dependency d : rootDeps) {
            DependencyText found = this.findDependency(d);
            if (found == null) continue;
            result.put(d, found);
        }
        if (this.dependencyBlockStart != -1) {
            containerPart = new DependencyText.Part();
            containerPart.partId = "container";
            containerPart.startPos = this.dependencyBlockStart;
            containerPart.endPos = this.dependencyBlockEnd;
            containerPart.value = "";
        } else {
            containerPart = null;
        }
        return new DependencyText.Mapping(result, containerPart);
    }

    private static final class EndInputException
    extends RuntimeException {
        private EndInputException() {
        }
    }

    private static enum Token {
        NONE,
        LINECOMMENT,
        BLOCKCOMMENT,
        QUOTED,
        IDENTIFIER,
        SYMBOL,
        OTHER;

    }
}

