/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.templates.TemplateRegistration;
import org.netbeans.api.templates.TemplateRegistrations;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbCollections;

public class TemplateHinter
implements Hinter {
    @Override
    public void process(final Hinter.Context ctx) throws Exception {
        Object basename;
        FileObject file = ctx.file();
        if (!file.isData()) {
            return;
        }
        Object iterator = file.getAttribute("literal:instantiatingIterator");
        if (iterator == null) {
            iterator = file.getAttribute("literal:templateWizardIterator");
        }
        if (iterator == null) {
            if (Boolean.TRUE.equals(file.getAttribute("template"))) {
                ctx.addHint(Severity.WARNING, Bundle.TemplateHinter_content_file(), new Fix[0]);
            }
            return;
        }
        final String url = (String)file.getAttribute("WritableXMLFileSystem.url");
        if (url == null && file.getSize() > 0L) {
            ctx.addHint(Severity.WARNING, Bundle.TemplateHinter_content_file(), new Fix[0]);
            return;
        }
        if (url != null && !((String)(basename = TemplateHinter.basename(url))).equals(file.getNameExt())) {
            ctx.addHint(Severity.WARNING, Bundle.TemplateHinter_basename_mismatch(file.getNameExt(), basename), new Fix[0]);
            return;
        }
        for (String attr : NbCollections.iterable((Enumeration)file.getAttributes())) {
            if (attr.matches("instantiatingIterator|templateWizardIterator|template|displayName|iconBase|position|instantiatingWizardURL|templateWizardURL|templateCategory|javax[.]script[.]ScriptEngine")) continue;
            ctx.addHint(Severity.WARNING, Bundle.TemplateHinter_unrecognized_attr(attr), new Fix[0]);
            return;
        }
        final Object _iterator = iterator;
        ctx.addStandardAnnotationHint(new Callable<Void>(){
            final /* synthetic */ TemplateHinter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void call() throws Exception {
                if (!this.this$0.annotationsAvailable(ctx)) {
                    return null;
                }
                ctx.findAndModifyDeclaration(_iterator, new Hinter.Context.ModifyDeclarationTask(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
                        String category;
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        FileObject file = ctx.file();
                        params.put("folder", FileUtil.getRelativePath((FileObject)file.getFileSystem().findResource("Templates"), (FileObject)file.getParent()));
                        params.put("position", file.getAttribute("position"));
                        if (url != null) {
                            URI u = new URI(url);
                            if (!u.isAbsolute()) {
                                ClassPath src;
                                String path;
                                URL[] layers = (URL[])file.getAttribute("layers");
                                assert (layers != null && layers.length == 1);
                                FileObject layer = URLMapper.findFileObject((URL)layers[0]);
                                if (layer != null && (path = (src = ClassPath.getClassPath((FileObject)layer, (String)"classpath/source")).getResourceName(layer)) != null) {
                                    u = new URI("nbres", "/" + path, null).resolve(u);
                                }
                            }
                            if (u.getScheme() != null && u.getScheme().matches("nbres(loc)?")) {
                                params.put("content", u.getPath());
                            }
                        }
                        params.put("scriptEngine", file.getAttribute("javax.script.ScriptEngine"));
                        params.put("displayName", ctx.bundlevalue(file.getAttribute("literal:displayName"), declaration));
                        params.put("iconBase", file.getAttribute("iconBase"));
                        URL desc = (URL)file.getAttribute("instantiatingWizardURL");
                        if (desc == null) {
                            desc = (URL)file.getAttribute("templateWizardURL");
                        }
                        if (desc != null) {
                            params.put("description", desc.getPath());
                        }
                        if ((category = (String)file.getAttribute("templateCategory")) != null) {
                            params.put("category", category.split(", ?"));
                        }
                        params.put("requireProject", file.getAttribute("requireProject"));
                        ModifiersTree nue = ctx.addAnnotation(wc, modifiers, TemplateRegistration.class.getName(), TemplateRegistrations.class.getName(), params);
                        ctx.delete(file);
                        wc.rewrite((Tree)modifiers, GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)nue));
                    }
                });
                return null;
            }
        });
    }

    private boolean annotationsAvailable(Hinter.Context ctx) {
        if (ctx.canAccess(TemplateRegistration.class.getName())) {
            return true;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TemplateHinter_missing_dep(), 2));
        return false;
    }

    private static String basename(String relativeResource) {
        return relativeResource.replaceFirst(".+/", "").replaceFirst("[.]template$", "");
    }
}

