/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class SystemFileSystemAttrHinter
implements Hinter {
    @Override
    public void process(final Hinter.Context ctx) throws Exception {
        Object icon;
        final FileObject file = ctx.file();
        final String locBundle = (String)file.getAttribute("SystemFileSystem.localizingBundle");
        if (locBundle != null) {
            if (file.getAttribute("displayName") != null) {
                ctx.addHint(Severity.WARNING, Bundle.both_locBundle_and_displayName(), new Fix[0]);
            } else {
                ctx.addHint(Severity.WARNING, Bundle.using_locBundle(), new Fix(){
                    final /* synthetic */ SystemFileSystemAttrHinter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String getText() {
                        return Bundle.use_displayName();
                    }

                    public ChangeInfo implement() throws Exception {
                        file.setAttribute("SystemFileSystem.localizingBundle", null);
                        file.setAttribute("displayName", (Object)("bundlevalue:" + locBundle + "#" + file.getPath()));
                        ctx.saveLayer();
                        return null;
                    }
                });
            }
        }
        if ((icon = file.getAttribute("literal:SystemFileSystem.icon")) != null) {
            if (file.getAttribute("iconBase") != null) {
                ctx.addHint(Severity.WARNING, Bundle.both_icon_and_iconBase(), new Fix[0]);
            } else {
                Matcher m = Pattern.compile("nbres(loc)?:/(.+)").matcher(icon.toString());
                if (m.matches()) {
                    final String iconBase = m.group(2);
                    ctx.addHint(Severity.WARNING, Bundle.using_icon(), new Fix(){
                        final /* synthetic */ SystemFileSystemAttrHinter this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public String getText() {
                            return Bundle.use_iconBase();
                        }

                        public ChangeInfo implement() throws Exception {
                            file.setAttribute("SystemFileSystem.icon", null);
                            file.setAttribute("iconBase", (Object)iconBase);
                            ctx.saveLayer();
                            return null;
                        }
                    });
                } else {
                    ctx.addHint(Severity.WARNING, Bundle.using_icon(), new Fix[0]);
                }
            }
        }
        if (file.getAttribute("literal:SystemFileSystem.icon32") != null) {
            ctx.addHint(Severity.WARNING, Bundle.avoid_SystemFileSystem_icon32(), new Fix[0]);
        }
    }
}

