/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.netbeans.modules.properties.BundleNodeCustomizer;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class PropertiesDataNode
extends DataNode {
    private final transient PropertyChangeListener dataObjectListener;
    private boolean multiLocale;
    static final String PROPERTY_ENCODING = "projectEncoding";

    PropertiesDataNode(PropertiesDataObject propDO, Lookup lookup) {
        this((DataObject)propDO, PropertiesDataNode.createChildren(propDO), lookup);
        this.multiLocale = propDO.isMultiLocale();
    }

    public PropertiesDataNode(DataObject dataObject, Children children, Lookup lookup) {
        super(dataObject, children, lookup);
        this.setIconBaseWithExtension("org/netbeans/modules/properties/propertiesObject.png");
        this.dataObjectListener = new NameUpdater();
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dataObjectListener, (Object)dataObject));
    }

    private static Children createChildren(PropertiesDataObject propDO) {
        return ((PropertiesFileEntry)propDO.getPrimaryEntry()).getChildren();
    }

    public NewType[] getNewTypes() {
        PropertiesDataObject propDO = (PropertiesDataObject)this.getDataObject();
        if (propDO.isMultiLocale()) {
            return new NewType[]{new NewLocaleType()};
        }
        PropertiesFileEntry pfEntry = (PropertiesFileEntry)propDO.getPrimaryEntry();
        return new NewType[]{new NewLocaleType(), new PropertiesLocaleNode.NewPropertyType(pfEntry)};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new BundleNodeCustomizer((PropertiesDataObject)this.getDataObject());
    }

    public void createPasteTypes(Transferable transferable, List<PasteType> types) {
        super.createPasteTypes(transferable, types);
        Node node = NodeTransfer.node((Transferable)transferable, (int)6);
        if (node != null && node.canDestroy()) {
            Element.ItemElem item = (Element.ItemElem)node.getCookie(Element.ItemElem.class);
            if (item == null) {
                return;
            }
            Node itemNode = this.getChildren().findChild(item.getKey());
            if (node.equals((Object)itemNode)) {
                return;
            }
            types.add(new EntryPasteType(item, node));
        } else {
            Element.ItemElem item = (Element.ItemElem)NodeTransfer.cookie((Transferable)transferable, (int)1, Element.ItemElem.class);
            if (item != null) {
                types.add(new EntryPasteType(item, null));
            }
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("encoding");
        set.setDisplayName(NbBundle.getMessage(PropertiesDataNode.class, (String)"ENCODING_SET_Name"));
        if (set == null) {
            set = Sheet.createPropertiesSet();
            sheet.put(set);
        }
        set.put((Node.Property)new ProjectEncodingProperty());
        sheet.put(set);
        return sheet;
    }

    private PropertiesDataObject getPropertiesDataObject() {
        return (PropertiesDataObject)this.getDataObject();
    }

    private PropertiesFileEntry getPropertiesFileEntry() {
        return (PropertiesFileEntry)this.getPropertiesDataObject().getPrimaryEntry();
    }

    private PropertiesStructure getPropertiesStructure() {
        return this.getPropertiesFileEntry().getHandler().getStructure();
    }

    private static boolean containsLocale(PropertiesDataObject propertiesDataObject, Locale locale) {
        FileObject file = propertiesDataObject.getBundleStructure().getNthEntry(0).getFile();
        String newName = file.getName() + '_' + locale;
        BundleStructure structure = propertiesDataObject.getBundleStructure();
        for (int i = 0; i < structure.getEntryCount(); ++i) {
            FileObject f = structure.getNthEntry(i).getFile();
            if (!newName.startsWith(f.getName()) || f.getName().length() <= file.getName().length()) continue;
            file = f;
        }
        return file.getName().equals(newName);
    }

    final class NameUpdater
    implements PropertyChangeListener {
        NameUpdater() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("files".equals(e.getPropertyName())) {
                PropertiesDataObject propDO = (PropertiesDataObject)PropertiesDataNode.this.getDataObject();
                propDO.fireNameChange();
                boolean newMultiLocale = propDO.isMultiLocale();
                if (newMultiLocale != PropertiesDataNode.this.multiLocale) {
                    PropertiesDataNode.this.multiLocale = newMultiLocale;
                    PropertiesDataNode.this.setChildren(PropertiesDataNode.createChildren(propDO));
                }
            }
        }
    }

    private class NewLocaleType
    extends NewType {
        private NewLocaleType() {
        }

        public String getName() {
            return NbBundle.getBundle(PropertiesDataNode.class).getString("LAB_NewLocaleAction");
        }

        public void create() throws IOException {
            final PropertiesDataObject propertiesDataObject = (PropertiesDataObject)PropertiesDataNode.this.getCookie(DataObject.class);
            final Dialog[] dialog = new Dialog[1];
            final LocalePanel panel = new LocalePanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getBundle(PropertiesDataNode.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){
                final /* synthetic */ NewLocaleType this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                        if (PropertiesDataNode.containsLocale(propertiesDataObject, panel.getLocale())) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(PropertiesDataNode.class).getString("MSG_LangExists"), panel.getLocale()), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        } else {
                            Util.createLocaleFile(propertiesDataObject, panel.getLocale().toString(), true);
                            dialog[0].setVisible(false);
                            dialog[0].dispose();
                        }
                    }
                }
            });
            dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            dialog[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog[0].setVisible(true);
        }
    }

    private class EntryPasteType
    extends PasteType {
        private final Element.ItemElem item;
        private final Node node;

        public EntryPasteType(Element.ItemElem item, Node node) {
            this.item = item;
            this.node = node;
        }

        public Transferable paste() throws IOException {
            PropertiesStructure ps = PropertiesDataNode.this.getPropertiesStructure();
            Element.ItemElem storedItem = ps.getItem(this.item.getKey());
            if (storedItem == null) {
                ps.addItem(this.item);
            } else {
                storedItem.setValue(this.item.getValue());
                storedItem.setComment(this.item.getComment());
            }
            if (this.node != null) {
                this.node.destroy();
            }
            return null;
        }
    }

    private final class ProjectEncodingProperty
    extends PropertySupport {
        public ProjectEncodingProperty() {
            super(PropertiesDataNode.PROPERTY_ENCODING, Boolean.class, NbBundle.getMessage(PropertiesDataNode.class, (String)"PROP_ENCODING_Name"), NbBundle.getMessage(PropertiesDataNode.class, (String)"PROP_ENCODING_Hint"), true, true);
        }

        public Object getValue() throws InvocationTargetException {
            Object attribute = PropertiesDataNode.this.getDataObject().getPrimaryFile().getAttribute(PropertiesDataNode.PROPERTY_ENCODING);
            if (attribute == null) {
                return false;
            }
            return attribute;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                PropertiesDataNode.this.getDataObject().getPrimaryFile().setAttribute(PropertiesDataNode.PROPERTY_ENCODING, val);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            PropertiesEditorSupport propertiesEditor = PropertiesDataNode.this.getPropertiesFileEntry().getPropertiesEditor();
            propertiesEditor.resetCharset();
            if (propertiesEditor.hasOpenedEditorComponent()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PropertiesDataNode.class, (String)"PROP_ENCODING_Warning", (Object)PropertiesDataNode.this.getDisplayName()), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                propertiesEditor.close();
            }
        }
    }
}

