/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjar.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbNodesFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class EjbContainerChildren
extends Children.Keys<Key>
implements PropertyChangeListener {
    private final EjbJar ejbModule;
    private final EjbNodesFactory nodeFactory;
    private final Project project;
    private final Map<Key, Node> nodesHash = Collections.synchronizedMap(new HashMap());
    private RequestProcessor.Task updateTask = null;
    private static final RequestProcessor rp = new RequestProcessor();
    private AtomicBoolean listenerInitialized = new AtomicBoolean();

    public EjbContainerChildren(EjbJar ejbModule, EjbNodesFactory nodeFactory, Project project) {
        this.ejbModule = ejbModule;
        this.nodeFactory = nodeFactory;
        this.project = project;
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(new Key[]{Key.SCANNING});
        this.updateKeys();
    }

    private synchronized void updateKeys() {
        if (this.updateTask != null) {
            this.updateTask.schedule(100);
            return;
        }
        this.updateTask = rp.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Future future = EjbContainerChildren.this.ejbModule.getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, List<Key>>(){

                        public List<Key> run(EjbJarMetadata metadata) throws Exception {
                            EnterpriseBeans beans = metadata.getRoot().getEnterpriseBeans();
                            if (beans != null) {
                                if (EjbContainerChildren.this.listenerInitialized.compareAndSet(false, true)) {
                                    beans.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)EjbContainerChildren.this, (Object)beans));
                                }
                                Key[] sessionBeans = Key.createArray((Ejb[])beans.getSession());
                                Key[] entityBeans = Key.createArray((Ejb[])beans.getEntity());
                                Key[] messageBeans = Key.createArray((Ejb[])beans.getMessageDriven());
                                Comparator<Key> ejbComparator = new Comparator<Key>(){

                                    @Override
                                    public int compare(Key key1, Key key2) {
                                        return this.getEjbDisplayName(key1).compareTo(this.getEjbDisplayName(key2));
                                    }

                                    private String getEjbDisplayName(Key ejb) {
                                        String name = ejb.defaultDisplayName;
                                        if (name == null) {
                                            name = ejb.ejbName;
                                        }
                                        if (name == null) {
                                            name = "";
                                        }
                                        return name;
                                    }
                                };
                                Arrays.sort(sessionBeans, ejbComparator);
                                Arrays.sort(entityBeans, ejbComparator);
                                Arrays.sort(messageBeans, ejbComparator);
                                ArrayList<Key> keys = new ArrayList<Key>(sessionBeans.length + entityBeans.length + messageBeans.length);
                                keys.addAll(Arrays.asList(sessionBeans));
                                keys.addAll(Arrays.asList(messageBeans));
                                keys.addAll(Arrays.asList(entityBeans));
                                return keys;
                            }
                            return Collections.emptyList();
                        }
                    });
                    ArrayList result = new ArrayList();
                    try {
                        result.addAll((Collection)future.get());
                    }
                    catch (InterruptedException ie) {
                        Exceptions.printStackTrace((Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        Exceptions.printStackTrace((Throwable)ee);
                    }
                    EjbContainerChildren.this.createNodesForKeys(result);
                    EjbContainerChildren.this.setKeys(result);
                }
                catch (MetadataModelException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, 100);
    }

    private void createNodesForKeys(List<Key> keys) {
        this.nodesHash.clear();
        for (Key key : keys) {
            this.createNodes(key);
        }
    }

    protected void removeNotify() {
        this.nodesHash.clear();
        super.removeNotify();
    }

    protected Node[] createNodes(Key key) {
        Node[] nodeArray;
        Node node = this.nodesHash.get(key);
        if (!this.nodesHash.containsKey(key)) {
            node = null;
            if (key.ejbType == Key.EjbType.SESSION && !key.isWebService && this.nodeFactory != null) {
                node = this.nodeFactory.createSessionNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key.ejbType == Key.EjbType.ENTITY && this.nodeFactory != null) {
                node = this.nodeFactory.createEntityNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key.ejbType == Key.EjbType.MESSAGE_DRIVEN && this.nodeFactory != null) {
                node = this.nodeFactory.createMessageNode(key.ejbClass, this.ejbModule, this.project);
            }
            if (key == Key.SCANNING) {
                node = new AbstractNode(Children.LEAF);
                node.setDisplayName(NbBundle.getMessage(EjbContainerChildren.class, (String)"MSG_Scanning_EJBs"));
                ((AbstractNode)node).setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbjar/project/ui/wait.gif");
            }
            this.nodesHash.put(key, node);
        }
        if (node == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        return nodeArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }

    static final class Key {
        public static final Key SCANNING = new Key(null, null, null, null, false);
        private final EjbType ejbType;
        private final String ejbClass;
        private final String defaultDisplayName;
        private final String ejbName;
        private final boolean isWebService;

        private Key(EjbType ejbType, String ejbClass, String defaultDisplayName, String ejbName, boolean isWebService) {
            this.ejbType = ejbType;
            this.ejbClass = ejbClass;
            this.defaultDisplayName = defaultDisplayName;
            this.ejbName = ejbName;
            this.isWebService = isWebService;
        }

        public static Key[] createArray(Ejb[] ejbs) {
            Key[] keys = new Key[ejbs.length];
            for (int i = 0; i < ejbs.length; ++i) {
                Ejb ejb = ejbs[i];
                EjbType ejbType = null;
                boolean isWebService = false;
                if (ejb instanceof Session) {
                    ejbType = EjbType.SESSION;
                    try {
                        isWebService = ((Session)ejb).getServiceEndpoint() != null;
                    }
                    catch (VersionNotSupportedException versionNotSupportedException) {}
                } else if (ejb instanceof Entity) {
                    ejbType = EjbType.ENTITY;
                } else if (ejb instanceof MessageDriven) {
                    ejbType = EjbType.MESSAGE_DRIVEN;
                }
                keys[i] = new Key(ejbType, ejb.getEjbClass(), ejb.getDefaultDisplayName(), ejb.getEjbName(), isWebService);
            }
            return keys;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!(this.ejbClass == other.ejbClass || this.ejbClass != null && this.ejbClass.equals(other.ejbClass))) {
                return false;
            }
            return this.defaultDisplayName == other.defaultDisplayName || this.defaultDisplayName != null && this.defaultDisplayName.equals(other.defaultDisplayName);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.ejbClass != null ? this.ejbClass.hashCode() : 0);
            return hash;
        }

        private static enum EjbType {
            SESSION,
            ENTITY,
            MESSAGE_DRIVEN;

        }
    }
}

