/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.action.ShortcutEnterPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class GUIRegistrationPanel
extends BasicWizardIterator.Panel {
    private final RequestProcessor SFS_RP = new RequestProcessor(GUIRegistrationPanel.class.getName());
    private static final String ACTIONS_DIR = "Actions";
    private FileSystem sfs;
    private DataModel data;
    private final JComponent[] gmiGroup;
    private final JComponent[] toolbarGroup;
    private final JComponent[] shortcutGroup;
    private final JComponent[] fileTypeGroup;
    private final JComponent[] editorGroup;
    private JPanel alwaysEnabledPanel;
    private JComboBox category;
    private JLabel categoryTxt;
    private JPanel contextSensitivePanel;
    private JComboBox edContentType;
    private JLabel edContentTypeTxt;
    private JComboBox edPosition;
    private JLabel edPositionTxt;
    private JCheckBox edSeparatorAfter;
    private JCheckBox edSeparatorBefore;
    private JPanel edSeparatorPanel;
    JCheckBox editorContext;
    JCheckBox fileTypeContext;
    private JComboBox ftContentType;
    private JLabel ftContentTypeTxt;
    private JComboBox ftPosition;
    private JLabel ftPositionTxt;
    private JCheckBox ftSeparatorAfter;
    private JCheckBox ftSeparatorBefore;
    private JPanel ftSeparatorPanel;
    private JCheckBox globalKeyboardShortcut;
    JCheckBox globalMenuItem;
    JCheckBox globalToolbarButton;
    private JScrollPane jScrollPane1;
    private JButton keyStrokeChange;
    private JButton keyStrokeRemove;
    private JLabel keyStrokeTxt;
    private JComboBox menu;
    private JComboBox menuPosition;
    private JLabel menuPositionTxt;
    private JCheckBox menuSeparatorAfter;
    private JCheckBox menuSeparatorBefore;
    private JLabel menuTxt;
    private JList shortcutsList;
    private JComboBox toolbar;
    private JComboBox toolbarPosition;
    private JLabel toolbarPositionTxt;
    private JLabel toolbarTxt;

    public GUIRegistrationPanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", GUIRegistrationPanel.getMessage("LBL_ActionWizardTitle"));
        this.menu.addPopupMenuListener(new PML(this.menu, this.menuPosition));
        this.toolbar.addPopupMenuListener(new PML(this.toolbar, this.toolbarPosition));
        this.ftContentType.addPopupMenuListener(new PML(this.ftContentType, this.ftPosition));
        this.edContentType.addPopupMenuListener(new PML(this.edContentType, this.edPosition));
        this.gmiGroup = new JComponent[]{this.menu, this.menuTxt, this.menuPosition, this.menuPositionTxt, this.menuSeparatorAfter, this.menuSeparatorBefore};
        this.toolbarGroup = new JComponent[]{this.toolbar, this.toolbarTxt, this.toolbarPosition, this.toolbarPositionTxt};
        this.shortcutGroup = new JComponent[]{this.shortcutsList, this.keyStrokeTxt, this.keyStrokeChange, this.keyStrokeRemove};
        this.fileTypeGroup = new JComponent[]{this.ftContentType, this.ftContentTypeTxt, this.ftPosition, this.ftPositionTxt, this.ftSeparatorAfter, this.ftSeparatorBefore};
        this.editorGroup = new JComponent[]{this.edContentType, this.edContentTypeTxt, this.edPosition, this.edPositionTxt, this.edSeparatorAfter, this.edSeparatorBefore};
        this.readSFS();
    }

    private void setEditable(final JComboBox combo) {
        combo.setEditable(true);
        if (combo.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField txt = (JTextField)combo.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(this){
                final /* synthetic */ GUIRegistrationPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void insertUpdate(DocumentEvent e) {
                    if (!UIUtil.isWaitModel(combo.getModel())) {
                        this.this$0.checkValidity();
                    }
                }
            });
        }
    }

    @Override
    protected String getPanelName() {
        return GUIRegistrationPanel.getMessage("LBL_GUIRegistration_Title");
    }

    private String getCategoryPath() {
        String path = WizardUtils.getSFSPath(this.category, ACTIONS_DIR);
        return path == null ? "Actions/Tools" : path;
    }

    @Override
    protected void storeToDataModel() {
        if (!this.checkValidity()) {
            return;
        }
        this.data.setCategory(this.getCategoryPath());
        this.data.setGlobalMenuItemEnabled(this.globalMenuItem.isSelected());
        if (this.globalMenuItem.isSelected()) {
            this.data.setGMIParentMenu(GUIRegistrationPanel.getSelectedLayerPresenter(this.menu).getFullPath());
            this.data.setGMIPosition((DataModel.Position)this.menuPosition.getSelectedItem());
            this.data.setGMISeparatorAfter(this.menuSeparatorAfter.isSelected());
            this.data.setGMISeparatorBefore(this.menuSeparatorBefore.isSelected());
        }
        this.data.setToolbarEnabled(this.globalToolbarButton.isSelected());
        if (this.globalToolbarButton.isSelected()) {
            this.data.setToolbar(GUIRegistrationPanel.getSelectedLayerPresenter(this.toolbar).getFullPath());
            this.data.setToolbarPosition((DataModel.Position)this.toolbarPosition.getSelectedItem());
        }
        this.data.setKeyboardShortcutEnabled(this.globalKeyboardShortcut.isSelected());
        this.data.setFileTypeContextEnabled(this.fileTypeContext.isSelected());
        if (this.fileTypeContext.isSelected()) {
            this.data.setFTContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.ftContentType).getFullPath());
            this.data.setFTContextPosition((DataModel.Position)this.ftPosition.getSelectedItem());
            this.data.setFTContextSeparatorBefore(this.ftSeparatorBefore.isSelected());
            this.data.setFTContextSeparatorAfter(this.ftSeparatorAfter.isSelected());
        }
        this.data.setEditorContextEnabled(this.editorContext.isSelected());
        if (this.editorContext.isSelected()) {
            this.data.setEdContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.edContentType).getFullPath());
            this.data.setEdContextPosition((DataModel.Position)this.edPosition.getSelectedItem());
            this.data.setEdContextSeparatorBefore(this.edSeparatorBefore.isSelected());
            this.data.setEdContextSeparatorAfter(this.edSeparatorAfter.isSelected());
        }
    }

    @Override
    protected void readFromDataModel() {
        this.initializeGlobalAction();
        this.checkValidity();
    }

    private void initializeGlobalAction() {
        this.globalMenuItem.setSelected(true);
        this.globalMenuItem.setEnabled(true);
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.globalToolbarButton.setEnabled(true);
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        boolean alwaysEnabled = this.data.isAlwaysEnabled();
        this.globalKeyboardShortcut.setEnabled(alwaysEnabled);
        this.setShortcutGroupEnabled();
        if (alwaysEnabled) {
            this.fileTypeContext.setSelected(false);
            this.editorContext.setSelected(false);
        }
        this.fileTypeContext.setEnabled(!alwaysEnabled);
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.editorContext.setEnabled(!alwaysEnabled);
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
        this.alwaysEnabledPanel.setVisible(alwaysEnabled);
        this.contextSensitivePanel.setVisible(!alwaysEnabled);
    }

    boolean checkValidity() {
        boolean result = false;
        if (this.globalKeyboardShortcut.isSelected() && ((DefaultListModel)this.shortcutsList.getModel()).isEmpty()) {
            this.setError(GUIRegistrationPanel.getMessage("MSG_YouMustSpecifyShortcut"));
        } else if (!(this.check(this.globalMenuItem, this.menu, this.menuPosition) && this.check(this.globalToolbarButton, this.toolbar, this.toolbarPosition) && this.check(this.fileTypeContext, this.ftContentType, this.ftPosition) && this.check(this.editorContext, this.edContentType, this.edPosition))) {
            this.markInvalid();
        } else if (!WizardUtils.isValidSFSPath(this.getCategoryPath())) {
            this.setError(GUIRegistrationPanel.getMessage("ERR_Category_Invalid"));
        } else {
            this.markValid();
            result = true;
        }
        return result;
    }

    private boolean check(JCheckBox groupCheckBox, JComboBox menu, JComboBox position) {
        boolean result = !groupCheckBox.isSelected() || GUIRegistrationPanel.getSelectedItem(menu) != null && GUIRegistrationPanel.getSelectedItem(position) != null;
        return result;
    }

    private void setGroupEnabled(JComponent[] group, boolean enabled) {
        for (int i = 0; i < group.length; ++i) {
            if (group[i] == null) continue;
            group[i].setEnabled(enabled && !this.isEmptyCombo(group[i]));
        }
    }

    private void setShortcutGroupEnabled() {
        boolean isEnabled = this.globalKeyboardShortcut.isSelected();
        this.setGroupEnabled(this.shortcutGroup, isEnabled);
        isEnabled = isEnabled && this.shortcutsList.getSelectedValues().length > 0;
        this.keyStrokeRemove.setEnabled(isEnabled);
    }

    private boolean isEmptyCombo(JComponent c) {
        return c instanceof JComboBox && UIUtil.hasOnlyValue(((JComboBox)c).getModel(), (Object)WizardUtils.EMPTY_VALUE);
    }

    private void readSFS() {
        this.markInvalid();
        this.loadComboAndPositions(ACTIONS_DIR, this.category, null, null, true);
        this.loadComboAndPositions("Menu", this.menu, this.menuPosition, null);
        this.loadComboAndPositions("Toolbars", this.toolbar, this.toolbarPosition, null);
        this.loadComboAndPositions("Loaders", this.ftContentType, this.ftPosition, ACTIONS_DIR);
        this.loadComboAndPositions("Editors", this.edContentType, this.edPosition, "Popup");
    }

    private void loadComboAndPositions(String startFolder, JComboBox combo, JComboBox comboPositions, String subFolderName) {
        this.loadComboAndPositions(startFolder, combo, comboPositions, subFolderName, false);
    }

    private void loadComboAndPositions(final String startFolder, final JComboBox combo, final JComboBox comboPositions, final String subFolderName, final boolean editable) {
        combo.setModel(UIUtil.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){
            final /* synthetic */ GUIRegistrationPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                DataFolder parentDF;
                Util.err.log("Loading " + startFolder + " from SFS....");
                FileSystem sfs = this.this$0.getSFS();
                this.this$0.data.setSFS(sfs);
                final FileObject parent = sfs.getRoot().getFileObject(startFolder);
                DataFolder dataFolder = parentDF = parent != null ? DataFolder.findFolder((FileObject)parent) : null;
                if (parentDF == null) {
                    Util.err.log("Could not find " + startFolder);
                    this.this$0.setEmptyModel(combo);
                    this.this$0.setEmptyModel(comboPositions);
                    return;
                }
                final List folders = subFolderName == null ? GUIRegistrationPanel.getFolders(parentDF) : this.this$0.getFoldersByName(parentDF, subFolderName);
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        LinkedHashSet<WizardUtils.LayerItemPresenter> sorted = new LinkedHashSet<WizardUtils.LayerItemPresenter>();
                        for (DataFolder folder : folders) {
                            sorted.add(new WizardUtils.LayerItemPresenter(folder.getPrimaryFile(), parent, subFolderName != null));
                        }
                        if (sorted.size() == 0) {
                            this.this$1.this$0.setEmptyModel(combo);
                            this.this$1.this$0.setEmptyModel(comboPositions);
                        } else {
                            DefaultComboBoxModel model = new DefaultComboBoxModel();
                            Iterator it = sorted.iterator();
                            while (it.hasNext()) {
                                model.addElement(it.next());
                            }
                            combo.setModel(model);
                            if (editable) {
                                this.this$1.this$0.setEditable(combo);
                            }
                            if (comboPositions != null) {
                                this.this$1.this$0.loadPositionsCombo((WizardUtils.LayerItemPresenter)combo.getSelectedItem(), comboPositions);
                            }
                        }
                    }
                });
            }
        });
    }

    private void loadPositionsCombo(final WizardUtils.LayerItemPresenter parent, final JComboBox positionsCombo) {
        assert (parent != null);
        assert (positionsCombo != null);
        positionsCombo.setModel(UIUtil.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){
            final /* synthetic */ GUIRegistrationPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                DataObject[] kids = DataFolder.findFolder((FileObject)parent.getFileObject()).getChildren();
                final FileObject[] files = new FileObject[kids.length];
                for (int i = 0; i < kids.length; ++i) {
                    files[i] = kids[i].getPrimaryFile();
                }
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.createPositionModel(positionsCombo, files, parent);
                    }
                });
            }
        });
    }

    private void createPositionModel(JComboBox positionsCombo, FileObject[] files, WizardUtils.LayerItemPresenter parent) {
        DefaultComboBoxModel<DataModel.Position> newModel = new DefaultComboBoxModel<DataModel.Position>();
        WizardUtils.LayerItemPresenter previous = null;
        for (FileObject file : files) {
            if (file.getNameExt().endsWith("_hidden")) continue;
            WizardUtils.LayerItemPresenter current = new WizardUtils.LayerItemPresenter(file, parent.getFileObject());
            newModel.addElement(GUIRegistrationPanel.createPosition(previous, current));
            previous = current;
        }
        newModel.addElement(GUIRegistrationPanel.createPosition(previous, null));
        positionsCombo.setModel(newModel);
        this.checkValidity();
    }

    private static Object getSelectedItem(JComboBox combo) {
        Object item = combo.getSelectedItem();
        return item == UIUtil.WAIT_VALUE || item == WizardUtils.EMPTY_VALUE ? null : item;
    }

    private static WizardUtils.LayerItemPresenter getSelectedLayerPresenter(JComboBox combo) {
        return (WizardUtils.LayerItemPresenter)GUIRegistrationPanel.getSelectedItem(combo);
    }

    private static DataModel.Position createPosition(WizardUtils.LayerItemPresenter first, WizardUtils.LayerItemPresenter second) {
        return new DataModel.Position(first == null ? null : first.getFileObject().getNameExt(), second == null ? null : second.getFileObject().getNameExt(), first == null ? null : first.getDisplayName(), second == null ? null : second.getDisplayName());
    }

    private void setEmptyModel(JComboBox combo) {
        if (combo != null) {
            combo.setModel(WizardUtils.createComboEmptyModel());
            combo.setEnabled(false);
            combo.setEditable(false);
            this.checkValidity();
        }
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(GUIRegistrationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(GUIRegistrationPanel.class, (String)key);
    }

    private void initComponents() {
        this.categoryTxt = new JLabel();
        this.category = new JComboBox();
        this.globalMenuItem = new JCheckBox();
        this.menuTxt = new JLabel();
        this.menu = new JComboBox();
        this.menuPositionTxt = new JLabel();
        this.menuPosition = new JComboBox();
        this.menuSeparatorBefore = new JCheckBox();
        this.menuSeparatorAfter = new JCheckBox();
        this.globalToolbarButton = new JCheckBox();
        this.toolbarTxt = new JLabel();
        this.toolbar = new JComboBox();
        this.toolbarPositionTxt = new JLabel();
        this.toolbarPosition = new JComboBox();
        this.alwaysEnabledPanel = new JPanel();
        this.globalKeyboardShortcut = new JCheckBox();
        this.keyStrokeTxt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.shortcutsList = new JList(new DefaultListModel());
        this.keyStrokeChange = new JButton();
        this.keyStrokeRemove = new JButton();
        this.contextSensitivePanel = new JPanel();
        this.fileTypeContext = new JCheckBox();
        this.ftContentTypeTxt = new JLabel();
        this.ftContentType = new JComboBox();
        this.ftPositionTxt = new JLabel();
        this.ftPosition = new JComboBox();
        this.ftSeparatorPanel = new JPanel();
        this.ftSeparatorBefore = new JCheckBox();
        this.ftSeparatorAfter = new JCheckBox();
        this.editorContext = new JCheckBox();
        this.edContentTypeTxt = new JLabel();
        this.edContentType = new JComboBox();
        this.edPositionTxt = new JLabel();
        this.edPosition = new JComboBox();
        this.edSeparatorPanel = new JPanel();
        this.edSeparatorBefore = new JCheckBox();
        this.edSeparatorAfter = new JCheckBox();
        this.categoryTxt.setLabelFor(this.category);
        Mnemonics.setLocalizedText((JLabel)this.categoryTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Category"));
        this.category.setPrototypeDisplayValue("Window | Debug");
        Mnemonics.setLocalizedText((AbstractButton)this.globalMenuItem, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalMenuItem"));
        this.globalMenuItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalMenuItemActionPerformed(evt);
            }
        });
        this.menuTxt.setLabelFor(this.menu);
        Mnemonics.setLocalizedText((JLabel)this.menuTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Menu"));
        this.menu.setPrototypeDisplayValue("Profile | Advanced");
        this.menuPositionTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.menuPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        this.menuPosition.setPrototypeDisplayValue(DataModel.Position.PROTOTYPE);
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.menuSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.globalToolbarButton, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalToolbarButton"));
        this.globalToolbarButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalToolbarButtonActionPerformed(evt);
            }
        });
        this.toolbarTxt.setLabelFor(this.toolbar);
        Mnemonics.setLocalizedText((JLabel)this.toolbarTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Toolbar"));
        this.toolbar.setPrototypeDisplayValue("Quick Search");
        this.toolbarPositionTxt.setLabelFor(this.toolbarPosition);
        Mnemonics.setLocalizedText((JLabel)this.toolbarPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        this.toolbarPosition.setPrototypeDisplayValue(DataModel.Position.PROTOTYPE);
        Mnemonics.setLocalizedText((AbstractButton)this.globalKeyboardShortcut, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalKeyboardShortcut"));
        this.globalKeyboardShortcut.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalKeyboardShortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.globalKeyboardShortcutActionPerformed(evt);
            }
        });
        this.keyStrokeTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.keyStrokeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_KeyStroke"));
        this.shortcutsList.setVisibleRowCount(3);
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GUIRegistrationPanel.this.shortcutsListChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.shortcutsList);
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeList"));
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeChange, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"CTL_Change"));
        this.keyStrokeChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.keyStrokeChangeActionPerformed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/action/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeRemove, (String)bundle.getString("CTL_Remove"));
        this.keyStrokeRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.keyStrokeRemoveActionPerformed(evt);
            }
        });
        GroupLayout alwaysEnabledPanelLayout = new GroupLayout(this.alwaysEnabledPanel);
        this.alwaysEnabledPanel.setLayout(alwaysEnabledPanelLayout);
        alwaysEnabledPanelLayout.setHorizontalGroup(alwaysEnabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.globalKeyboardShortcut).addGroup(alwaysEnabledPanelLayout.createSequentialGroup().addComponent(this.keyStrokeTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(alwaysEnabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.keyStrokeRemove, -1, 114, Short.MAX_VALUE).addComponent(this.keyStrokeChange, -1, 114, Short.MAX_VALUE)).addContainerGap()));
        alwaysEnabledPanelLayout.setVerticalGroup(alwaysEnabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(alwaysEnabledPanelLayout.createSequentialGroup().addComponent(this.globalKeyboardShortcut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(alwaysEnabledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyStrokeTxt).addGroup(alwaysEnabledPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, alwaysEnabledPanelLayout.createSequentialGroup().addComponent(this.keyStrokeChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.keyStrokeRemove)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 56, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.globalKeyboardShortcut.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalKeyboardShortcut"));
        this.keyStrokeTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeDef"));
        this.keyStrokeChange.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeChange"));
        this.keyStrokeRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeRemove"));
        Mnemonics.setLocalizedText((AbstractButton)this.fileTypeContext, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_FileTypeContextMenuItem"));
        this.fileTypeContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.fileTypeContextActionPerformed(evt);
            }
        });
        this.ftContentTypeTxt.setLabelFor(this.ftContentType);
        Mnemonics.setLocalizedText((JLabel)this.ftContentTypeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        this.ftContentType.setPrototypeDisplayValue("text/xhtml+xml");
        this.ftPositionTxt.setLabelFor(this.ftPosition);
        Mnemonics.setLocalizedText((JLabel)this.ftPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        this.ftPosition.setPrototypeDisplayValue(DataModel.Position.PROTOTYPE);
        this.ftSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.ftSeparatorPanel.add(this.ftSeparatorBefore);
        this.ftSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftSeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.ftSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorAfter);
        this.ftSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftSeparatorAfter"));
        Mnemonics.setLocalizedText((AbstractButton)this.editorContext, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_EditorContextMenuItem"));
        this.editorContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.editorContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIRegistrationPanel.this.editorContextActionPerformed(evt);
            }
        });
        this.edContentTypeTxt.setLabelFor(this.edContentType);
        Mnemonics.setLocalizedText((JLabel)this.edContentTypeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        this.edContentType.setPrototypeDisplayValue("text/xhtml+xml");
        this.edPositionTxt.setLabelFor(this.edPosition);
        Mnemonics.setLocalizedText((JLabel)this.edPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        this.edPosition.setPrototypeDisplayValue(DataModel.Position.PROTOTYPE);
        this.edSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.edSeparatorPanel.add(this.edSeparatorBefore);
        this.edSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edSeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.edSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorAfter);
        this.edSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edSeparatorAfter"));
        GroupLayout contextSensitivePanelLayout = new GroupLayout(this.contextSensitivePanel);
        this.contextSensitivePanel.setLayout(contextSensitivePanelLayout);
        contextSensitivePanelLayout.setHorizontalGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.ftPositionTxt).addGap(49, 49, 49).addComponent(this.ftPosition, 0, 351, Short.MAX_VALUE)).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.ftSeparatorPanel, -2, -1, -2)).addComponent(this.editorContext).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.edContentTypeTxt).addGap(12, 12, 12).addComponent(this.edContentType, 0, 351, Short.MAX_VALUE)).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.edPositionTxt).addGap(49, 49, 49).addComponent(this.edPosition, 0, 351, Short.MAX_VALUE)).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.edSeparatorPanel, -2, -1, -2)).addComponent(this.fileTypeContext).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.ftContentTypeTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftContentType, 0, 351, Short.MAX_VALUE).addGap(1, 1, 1))).addContainerGap()));
        contextSensitivePanelLayout.setVerticalGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addComponent(this.fileTypeContext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftContentTypeTxt).addComponent(this.ftContentType, -2, -1, -2)).addGap(6, 6, 6).addGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.ftPositionTxt)).addComponent(this.ftPosition, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.ftSeparatorPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.editorContext).addGap(6, 6, 6).addGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.edContentTypeTxt)).addComponent(this.edContentType, -2, -1, -2)).addGap(6, 6, 6).addGroup(contextSensitivePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextSensitivePanelLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.edPositionTxt)).addComponent(this.edPosition, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.edSeparatorPanel, -2, -1, -2)));
        this.fileTypeContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_FileTypeContext"));
        this.ftContentType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftContentType"));
        this.ftPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftPosition"));
        this.editorContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_EditorContext"));
        this.edContentType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edContentType"));
        this.edPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edPosition"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.categoryTxt).addGap(12, 12, 12).addComponent(this.category, 0, 411, Short.MAX_VALUE)).addComponent(this.globalMenuItem).addGroup(layout.createSequentialGroup().addComponent(this.menuSeparatorBefore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuSeparatorAfter)).addComponent(this.globalToolbarButton).addGroup(layout.createSequentialGroup().addComponent(this.toolbarTxt).addGap(16, 16, 16).addComponent(this.toolbar, 0, 418, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.toolbarPositionTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbarPosition, 0, 418, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menuTxt).addComponent(this.menuPositionTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menu, 0, 418, Short.MAX_VALUE).addComponent(this.menuPosition, 0, 418, Short.MAX_VALUE))).addComponent(this.alwaysEnabledPanel, -1, 493, Short.MAX_VALUE).addComponent(this.contextSensitivePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.categoryTxt)).addComponent(this.category, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.globalMenuItem).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.menuTxt)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menu, -2, -1, -2))).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.menuPosition, -2, -1, -2).addComponent(this.menuPositionTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.menuSeparatorBefore).addComponent(this.menuSeparatorAfter)).addGap(18, 18, 18).addComponent(this.globalToolbarButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.toolbarTxt)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbar, -2, -1, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.toolbarPositionTxt)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbarPosition, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.alwaysEnabledPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contextSensitivePanel, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
        this.category.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_Category"));
        this.globalMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalMenuItem"));
        this.menu.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menu"));
        this.menuPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuPosition"));
        this.menuSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuSeparatorBefore"));
        this.menuSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuSeparatorAfter"));
        this.globalToolbarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalToolbarButton"));
        this.toolbar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_toolbar"));
        this.toolbarPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_toolbarPosition"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_GuiRegistrationPanel"));
    }

    private void shortcutsListChanged(ListSelectionEvent evt) {
        this.setShortcutGroupEnabled();
    }

    private void keyStrokeRemoveActionPerformed(ActionEvent evt) {
        DefaultListModel lm = (DefaultListModel)this.shortcutsList.getModel();
        Object[] selected = this.shortcutsList.getSelectedValues();
        if (selected.length > 0) {
            int idx = this.shortcutsList.getSelectionModel().getMinSelectionIndex();
            for (int i = 0; i < selected.length; ++i) {
                lm.removeElement(selected[i]);
            }
            if (lm.getSize() > 0) {
                idx = idx > 0 ? idx - 1 : 0;
                this.shortcutsList.setSelectedIndex(idx);
            }
        }
        this.checkValidity();
    }

    private void editorContextActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
        this.checkValidity();
    }

    private void fileTypeContextActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.checkValidity();
    }

    private void globalMenuItemActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.checkValidity();
    }

    private void globalToolbarButtonActionPerformed(ActionEvent evt) {
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        this.checkValidity();
    }

    private void globalKeyboardShortcutActionPerformed(ActionEvent evt) {
        this.setShortcutGroupEnabled();
        this.checkValidity();
    }

    private void keyStrokeChangeActionPerformed(ActionEvent evt) {
        KeyStroke[] keyStrokes = ShortcutEnterPanel.showDialog();
        if (keyStrokes != null && keyStrokes.length > 0) {
            String newShortcut = WizardUtils.keyStrokesToString(keyStrokes);
            DefaultListModel lm = (DefaultListModel)this.shortcutsList.getModel();
            if (!lm.contains(newShortcut)) {
                lm.addElement(newShortcut);
                this.data.setKeyStroke(WizardUtils.keyStrokesToLogicalString(keyStrokes));
                this.shortcutsList.setSelectedValue(newShortcut, true);
                this.checkValidity();
            }
        }
    }

    private FileSystem getSFS() {
        assert (!EventQueue.isDispatchThread()) : "Called from ETD!";
        if (this.sfs == null) {
            try {
                this.sfs = ((NbModuleProvider)this.data.getProject().getLookup().lookup(NbModuleProvider.class)).getEffectiveSystemFilesystem();
            }
            catch (IOException ex) {
                Logger.getLogger(GUIRegistrationPanel.class.getName()).log(Level.INFO, null, ex);
                this.sfs = FileUtil.createMemoryFileSystem();
            }
        }
        return this.sfs;
    }

    private List<DataFolder> getFoldersByName(DataFolder startFolder, String subFoldersName) {
        ArrayList<DataFolder> result = new ArrayList<DataFolder>();
        for (DataFolder dObj : GUIRegistrationPanel.getFolders(startFolder)) {
            if (!subFoldersName.equals(dObj.getName()) || dObj.getPrimaryFile().getParent() == startFolder.getPrimaryFile()) continue;
            result.add(dObj);
        }
        return result;
    }

    private static List<DataFolder> getFolders(DataFolder folder) {
        ArrayList<DataFolder> folders = new ArrayList<DataFolder>();
        GUIRegistrationPanel.getFolders(folder, folders);
        return folders;
    }

    private static void getFolders(DataFolder folder, List<DataFolder> folders) {
        for (DataObject d : folder.getChildren()) {
            if (!(d instanceof DataFolder)) continue;
            DataFolder f = (DataFolder)d;
            folders.add(f);
            GUIRegistrationPanel.getFolders(f, folders);
        }
    }

    private class PML
    implements PopupMenuListener {
        private JComboBox menu;
        private JComboBox position;

        PML(JComboBox menu, JComboBox position) {
            this.menu = menu;
            this.position = position;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            WizardUtils.LayerItemPresenter item = GUIRegistrationPanel.getSelectedLayerPresenter(this.menu);
            if (item != null) {
                GUIRegistrationPanel.this.loadPositionsCombo(item, this.position);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(null);
        }
    }
}

