/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewProvider;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class ProjectWebServiceView {
    private static final Lookup.Result<ProjectWebServiceViewProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(ProjectWebServiceViewProvider.class));
    private Reference<Project> project;
    private List<ProjectWebServiceViewImpl> impls;
    private List<ChangeListener> serviceListeners;
    private List<ChangeListener> clientListeners;
    private ChangeListener serviceListener;
    private ChangeListener clientListener;

    private Project getProject() {
        return this.project.get();
    }

    private ProjectWebServiceView(Project project) {
        this.project = new WeakReference<Project>(project);
        this.serviceListener = new ChangeListenerDelegate(ViewType.SERVICE);
        this.clientListener = new ChangeListenerDelegate(ViewType.CLIENT);
    }

    List<ProjectWebServiceViewImpl> getWebServiceViews() {
        return this.impls != null ? Collections.unmodifiableList(this.impls) : this.impls;
    }

    final void addChangeListener(ChangeListener l, ViewType viewType) {
        switch (viewType.ordinal()) {
            case 0: {
                if (this.serviceListeners == null) {
                    this.serviceListeners = new ArrayList<ChangeListener>();
                }
                this.serviceListeners.add(l);
                break;
            }
            case 1: {
                if (this.clientListeners == null) {
                    this.clientListeners = new ArrayList<ChangeListener>();
                }
                this.clientListeners.add(l);
            }
        }
    }

    final void removeChangeListener(ChangeListener l, ViewType viewType) {
        switch (viewType.ordinal()) {
            case 0: {
                if (this.serviceListeners == null) break;
                this.serviceListeners.remove(l);
                break;
            }
            case 1: {
                if (this.clientListeners == null) break;
                this.clientListeners.remove(l);
            }
        }
    }

    final void fireChange(ChangeEvent evt, ViewType viewType) {
        if (evt == null) {
            evt = new ChangeEvent(this);
        }
        try {
            switch (viewType.ordinal()) {
                case 0: {
                    for (ChangeListener l : this.serviceListeners) {
                        l.stateChanged(evt);
                    }
                    return;
                }
                case 1: {
                    for (ChangeListener l : this.clientListeners) {
                        l.stateChanged(evt);
                    }
                    return;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    final Node[] createView(ViewType viewType) {
        this.initImpls();
        ArrayList<Node> result = new ArrayList<Node>();
        for (ProjectWebServiceViewImpl view : this.getWebServiceViews()) {
            if (view.isViewEmpty(viewType)) continue;
            result.addAll(Arrays.asList(view.createView(viewType)));
        }
        return result.toArray(new Node[0]);
    }

    final boolean isViewEmpty(ViewType viewType) {
        this.initImpls();
        for (ProjectWebServiceViewImpl view : this.getWebServiceViews()) {
            if (view.isViewEmpty(viewType)) continue;
            return false;
        }
        return true;
    }

    void addNotify() {
        this.initImpls();
        for (ProjectWebServiceViewImpl impl : this.getWebServiceViews()) {
            impl.addNotify();
            impl.addChangeListener(this.serviceListener, ViewType.SERVICE);
            impl.addChangeListener(this.clientListener, ViewType.CLIENT);
        }
    }

    void removeNotify() {
        if (this.getWebServiceViews() != null) {
            for (ProjectWebServiceViewImpl impl : this.getWebServiceViews()) {
                impl.removeChangeListener(this.serviceListener, ViewType.SERVICE);
                impl.removeChangeListener(this.clientListener, ViewType.CLIENT);
                impl.removeNotify();
            }
        }
    }

    private void callImplAddNotify(ProjectWebServiceViewImpl impl) {
        impl.addNotify();
        impl.addChangeListener(this.serviceListener, ViewType.SERVICE);
        impl.addChangeListener(this.clientListener, ViewType.CLIENT);
    }

    private void callImplRemoveNotify(ProjectWebServiceViewImpl impl) {
        impl.removeChangeListener(this.serviceListener, ViewType.SERVICE);
        impl.removeChangeListener(this.clientListener, ViewType.CLIENT);
        impl.removeNotify();
    }

    private void initImpls() {
        if (this.getWebServiceViews() == null) {
            this.impls = new ArrayList<ProjectWebServiceViewImpl>(this.createWebServiceViews(this.getProject()));
        }
    }

    static Lookup.Result<ProjectWebServiceViewProvider> getProviders() {
        return implementations;
    }

    static ProjectWebServiceView getProjectWebServiceView(Project project) {
        return new ProjectWebServiceView(project);
    }

    private List<ProjectWebServiceViewImpl> createWebServiceViews(Project project) {
        Collection providers = ProjectWebServiceView.getProviders().allInstances();
        if (providers == null || providers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProjectWebServiceViewImpl> viewImpls = new ArrayList<ProjectWebServiceViewImpl>();
        for (ProjectWebServiceViewProvider provider : providers) {
            viewImpls.add(provider.createProjectWebServiceView(project));
        }
        return viewImpls;
    }

    public Node[] getServiceNodes(Project project) {
        return this.createWebServiceNodes(project, ViewType.SERVICE);
    }

    public Node[] getClientNodes(Project project) {
        return this.createWebServiceNodes(project, ViewType.CLIENT);
    }

    private Node[] createWebServiceNodes(Project project, ViewType viewType) {
        List<ProjectWebServiceViewImpl> viewImpls = this.createWebServiceViews(project);
        ArrayList<Node> result = new ArrayList<Node>();
        for (ProjectWebServiceViewImpl view : viewImpls) {
            if (view.isViewEmpty(viewType)) continue;
            result.addAll(Arrays.asList(view.createView(viewType)));
        }
        return result.toArray(new Node[0]);
    }

    private final class ChangeListenerDelegate
    implements ChangeListener {
        private final ViewType viewType;

        private ChangeListenerDelegate(ViewType viewType) {
            this.viewType = viewType;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ProjectWebServiceView.this.fireChange(e, this.viewType);
        }
    }

    public static enum ViewType {
        SERVICE,
        CLIENT;

    }
}

