/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class ExceptionCompletionItem
implements CompletionItem {
    private static final String CLASS_ICON = "org/netbeans/modules/php/dbgp/resources/class.png";
    private static final String PLATFORM_ICON = "org/netbeans/modules/php/dbgp/resources/php16Key.png";
    private final ClassElement element;
    private final boolean isPlatform;
    private final boolean isDeprecated;

    public ExceptionCompletionItem(ClassElement element) {
        this.element = element;
        if (element instanceof ClassElement) {
            this.isPlatform = element.isPlatform();
            this.isDeprecated = element.isDeprecated();
        } else {
            this.isPlatform = false;
            this.isDeprecated = false;
        }
    }

    public void defaultAction(JTextComponent component) {
        Document doc = component.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.getName(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)this.getIcon(), (boolean)false);
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont, (Color)Color.black, (int)width, (int)height, (boolean)selected);
    }

    public String getIcon() {
        return CLASS_ICON;
    }

    public String getLeftText() {
        StringBuilder sb = new StringBuilder();
        if (this.isDeprecated) {
            sb.append("<s>");
        }
        sb.append("<font color=\"#560000\">");
        sb.append(this.element.getName());
        sb.append("</font>");
        if (this.isDeprecated) {
            sb.append("</s>");
        }
        return sb.toString();
    }

    public String getRightText() {
        StringBuilder sb = new StringBuilder();
        String in = this.element.getIn();
        if (in != null && in.length() > 0) {
            sb.append(in);
            return sb.toString();
        }
        if (this.element instanceof PhpElement) {
            ClassElement ie = this.element;
            if (this.isPlatform) {
                return "PHP Platform";
            }
            String filename = ie.getFilenameUrl();
            int index = filename.lastIndexOf(47);
            if (index != -1) {
                filename = filename.substring(index + 1);
            }
            sb.append(filename);
            return sb.toString();
        }
        return null;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.element.getName();
    }

    public CharSequence getInsertPrefix() {
        return this.element.getName();
    }

    public String getName() {
        return this.element.getNamespaceName().append(this.element.getName()).toString();
    }

    public static class Builtin
    extends ExceptionCompletionItem {
        private final String element;

        public Builtin(String element) {
            super(null);
            this.element = element;
        }

        @Override
        public String getIcon() {
            return ExceptionCompletionItem.PLATFORM_ICON;
        }

        @Override
        public String getRightText() {
            return "";
        }

        @Override
        public String getLeftText() {
            return this.element;
        }

        @Override
        public String getName() {
            return this.element;
        }

        @Override
        public int getSortPriority() {
            return -1;
        }

        @Override
        public CharSequence getSortText() {
            return this.element;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.element;
        }
    }
}

