/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.util.Lookup;

public final class HelpCtx {
    private static final Logger err = Logger.getLogger("org.openide.util.HelpCtx");
    public static final HelpCtx DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");
    private final URL helpCtx;
    private final String helpID;

    @Deprecated
    public HelpCtx(URL helpCtx) {
        this.helpCtx = helpCtx;
        this.helpID = null;
    }

    public HelpCtx(String helpID) {
        this.helpID = helpID;
        this.helpCtx = null;
    }

    @Deprecated
    public HelpCtx(Class<?> clazz) {
        this(clazz.getName());
    }

    public URL getHelp() {
        return this.helpCtx;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public boolean display() {
        for (Displayer d : Lookup.getDefault().lookupAll(Displayer.class)) {
            if (!d.display(this)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int base = HelpCtx.class.hashCode();
        if (this.helpCtx != null) {
            base ^= this.helpCtx.hashCode();
        }
        if (this.helpID != null) {
            base ^= this.helpID.hashCode();
        }
        return base;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HelpCtx other = (HelpCtx)obj;
        if (!(this.helpCtx == other.helpCtx || this.helpCtx != null && this.helpCtx.equals(other.helpCtx))) {
            return false;
        }
        return !(this.helpID == null ? other.helpID != null : !this.helpID.equals(other.helpID));
    }

    public String toString() {
        if (this.helpID != null) {
            return "HelpCtx[" + this.helpID + "]";
        }
        return "HelpCtx[" + String.valueOf(this.helpCtx) + "]";
    }

    public static void setHelpIDString(JComponent comp, String helpID) {
        err.log(Level.FINE, "setHelpIDString: {0} on {1}", new Object[]{helpID, comp});
        comp.putClientProperty("HelpID", helpID);
    }

    public static HelpCtx findHelp(Component comp) {
        if (err.isLoggable(Level.FINEST)) {
            err.log(Level.FINEST, "findHelp on " + String.valueOf(comp), new Exception());
        } else {
            err.log(Level.FINE, "findHelp on {0}", comp);
        }
        while (comp != null) {
            JComponent jc;
            String hid;
            if (comp instanceof Provider) {
                HelpCtx h = ((Provider)((Object)comp)).getHelpCtx();
                err.log(Level.FINE, "found help {0} through HelpCtx.Provider interface", h);
                return h;
            }
            if (comp instanceof JComponent && (hid = (String)(jc = (JComponent)comp).getClientProperty("HelpID")) != null) {
                err.log(Level.FINE, "found help {0} by client property", hid);
                return new HelpCtx(hid);
            }
            comp = comp.getParent();
            err.log(Level.FINE, "no luck, trying parent {0}", comp);
        }
        err.fine("nothing found");
        return DEFAULT_HELP;
    }

    public static HelpCtx findHelp(Object instance) {
        if (instance instanceof Component) {
            return HelpCtx.findHelp((Component)instance);
        }
        if (instance instanceof Provider) {
            return ((Provider)instance).getHelpCtx();
        }
        try {
            BeanDescriptor d = Introspector.getBeanInfo(instance.getClass()).getBeanDescriptor();
            String v = (String)d.getValue("helpID");
            if (v != null) {
                return new HelpCtx(v);
            }
        }
        catch (IntrospectionException e) {
            err.log(Level.FINE, "findHelp on {0}: {1}", new Object[]{instance, e});
        }
        return DEFAULT_HELP;
    }

    public static interface Displayer {
        public boolean display(HelpCtx var1);
    }

    public static interface Provider {
        public HelpCtx getHelpCtx();
    }
}

