/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class PickNameAction
extends CookieAction {
    static FileObject findFile(Node[] activatedNodes) {
        return ((DataObject)activatedNodes[0].getCookie(DataObject.class)).getPrimaryFile();
    }

    static NbModuleProvider findProject(FileObject f) {
        URL[] location = (URL[])f.getAttribute("layers");
        if (location == null || location.length != 1) {
            return null;
        }
        Project p = FileOwnerQuery.getOwner((URI)URI.create(location[0].toExternalForm()));
        if (p == null) {
            return null;
        }
        return (NbModuleProvider)p.getLookup().lookup(NbModuleProvider.class);
    }

    private static String findBundlePath(NbModuleProvider p) {
        FileObject src = p.getSourceDirectory();
        ManifestManager mm = ManifestManager.getInstance(Util.getManifest(p.getManifestFile()), false);
        String bundlePath = mm.getLocalizingBundle();
        if (bundlePath != null && bundlePath.endsWith(".properties") && src.getFileObject(bundlePath) != null) {
            return bundlePath;
        }
        return null;
    }

    protected void performAction(Node[] activatedNodes) {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(PickNameAction.class, (String)"PickNameAction_dialog_label"), NbBundle.getMessage(PickNameAction.class, (String)"PickNameAction_dialog_title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        FileObject f = PickNameAction.findFile(activatedNodes);
        if (f == null) {
            return;
        }
        NbModuleProvider p = PickNameAction.findProject(f);
        if (p == null) {
            return;
        }
        String bundlePath = PickNameAction.findBundlePath(p);
        if (bundlePath == null) {
            return;
        }
        try {
            FileObject properties = p.getSourceDirectory().getFileObject(bundlePath);
            EditableProperties ep = Util.loadProperties(properties);
            String key = LayerUtil.generateBundleKeyForFile(f.getPath());
            ep.setProperty(key, name);
            Util.storeProperties(properties, ep);
            f.setAttribute("displayName", (Object)("bundlevalue:" + bundlePath.substring(0, bundlePath.length() - ".properties".length()).replace('/', '.') + "#" + key));
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!super.enable(activatedNodes)) {
            return false;
        }
        FileObject f = PickNameAction.findFile(activatedNodes);
        if (f == null) {
            return false;
        }
        NbModuleProvider p = PickNameAction.findProject(f);
        if (p == null) {
            return false;
        }
        return PickNameAction.findBundlePath(p) != null;
    }

    public String getName() {
        return NbBundle.getMessage(PickIconAction.class, (String)"LBL_pick_name");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

