/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SearchExecutor
extends HgProgressSupport {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private final File root;
    private final Set<File> files;
    private Map<String, File> pathToRoot;
    private final String fromRevision;
    private final String toRevision;
    private int limitRevisions;
    private final String branchName;
    static final int DEFAULT_LIMIT = 10;
    static final int UNLIMITTED = -1;
    private final boolean includeMerges;
    private HgBranch[] branches;

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        SearchCriteriaPanel criteria = master.getCriteria();
        this.fromRevision = criteria.getFrom();
        this.toRevision = criteria.getTo();
        this.includeMerges = criteria.isIncludeMerges();
        this.limitRevisions = criteria.getLimit();
        if (this.limitRevisions <= 0) {
            this.limitRevisions = -1;
        }
        this.branchName = criteria.getBranch();
        this.pathToRoot = new HashMap<String, File>();
        File rootFile = Mercurial.getInstance().getRepositoryRoot(master.getRoots()[0]);
        if (rootFile == null) {
            rootFile = master.getRoots()[0];
        }
        this.root = rootFile;
        this.files = new HashSet<File>(Arrays.asList(master.getRoots()));
    }

    @Override
    public void perform() {
        OutputLogger logger = this.getLogger();
        try {
            this.branches = HgCommand.getBranches(this.root, OutputLogger.getLogger(null));
        }
        catch (HgException ex) {
            this.branches = new HgBranch[0];
            Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
        }
        List<RepositoryRevision> results = this.search(this.fromRevision, this.toRevision, this.limitRevisions, this.branchName, this, logger);
        if (!this.isCanceled()) {
            this.checkFinished(results);
        }
    }

    public void start() {
        if (!HgBranch.DEFAULT_NAME.equals(this.branchName)) {
            HgModuleConfig.getDefault().setSearchOnBranchEnabled(this.master.getCurrentBranch(), !this.branchName.isEmpty());
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.root);
        this.start(rp, this.root, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
    }

    private List<RepositoryRevision> search(String fromRevision, String toRevision, int limitRevisions, String branchName, HgProgressSupport progressSupport, OutputLogger logger) {
        if (progressSupport.isCanceled()) {
            return Collections.emptyList();
        }
        HgLogMessage[] messages = new HgLogMessage[]{};
        try {
            if (this.master.isIncomingSearch()) {
                messages = HgCommand.getIncomingMessages(this.root, toRevision, branchName.isEmpty() ? null : branchName, this.includeMerges, false, this.includeMerges, limitRevisions, logger);
            } else if (this.master.isOutSearch()) {
                messages = HgCommand.getOutMessages(this.root, toRevision, branchName.isEmpty() ? null : branchName, this.includeMerges, this.includeMerges, limitRevisions, logger);
            } else {
                List<String> branchNames = branchName.isEmpty() ? Collections.emptyList() : Collections.singletonList(branchName);
                messages = HgCommand.getLogMessages(this.root, this.files, fromRevision, toRevision, this.includeMerges, false, this.includeMerges, limitRevisions, branchNames, logger, true);
            }
        }
        catch (HgException.HgCommandCanceledException branchNames) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        return this.appendResults(this.root, messages);
    }

    private List<RepositoryRevision> appendResults(File root, HgLogMessage[] logMessages) {
        ArrayList<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
        for (int i = logMessages.length - 1; i >= 0; --i) {
            HgLogMessage logMessage = logMessages[i];
            RepositoryRevision rev = new RepositoryRevision(logMessage, root, this.getCurrentRevisionKind(), this.master.getRoots(), this.getBranches(logMessage));
            results.add(rev);
        }
        return results;
    }

    private RepositoryRevision.Kind getCurrentRevisionKind() {
        if (this.master.isIncomingSearch()) {
            return RepositoryRevision.Kind.INCOMING;
        }
        if (this.master.isOutSearch()) {
            return RepositoryRevision.Kind.OUTGOING;
        }
        return RepositoryRevision.Kind.LOCAL;
    }

    private void checkFinished(final List<RepositoryRevision> results) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SearchExecutor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (results.isEmpty()) {
                    this.this$0.master.setResults(null, -1);
                } else {
                    this.this$0.master.setResults(results, this.this$0.limitRevisions);
                }
            }
        });
    }

    List<RepositoryRevision> search(int count, HgProgressSupport supp) {
        return this.search(this.fromRevision, this.toRevision, count, this.branchName, supp, supp.getLogger());
    }

    private Set<String> getBranches(HgLogMessage logMessage) {
        HashSet<String> headOfBranches = new HashSet<String>(2);
        for (HgBranch b : this.branches) {
            if (!b.getRevisionInfo().getCSetShortID().equals(logMessage.getCSetShortID())) continue;
            headOfBranches.add(b.getName());
        }
        return headOfBranches;
    }
}

