/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.options.PropertiesPanel;
import org.netbeans.modules.mercurial.options.PropertiesTable;
import org.netbeans.modules.mercurial.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgExtProperties
implements ActionListener,
DocumentListener {
    private PropertiesPanel panel;
    private File root;
    private PropertiesTable propTable;
    private HgProgressSupport support;
    private File loadedValueFile;
    private Font fontTextArea;

    public HgExtProperties(PropertiesPanel panel, PropertiesTable propTable, File root) {
        this.panel = panel;
        this.propTable = propTable;
        this.root = root;
        panel.getTxtAreaValue().getDocument().addDocumentListener(this);
        ((JTextField)panel.getComboName().getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        propTable.getTable().addMouseListener(new TableMouseListener());
        panel.getBtnAdd().addActionListener(this);
        panel.getBtnRemove().addActionListener(this);
        panel.getComboName().setEditable(true);
        panel.getBtnAdd().setEnabled(false);
        this.initPropertyNameCbx();
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel panel) {
        this.panel = panel;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.panel.getBtnAdd())) {
            this.addProperty();
        }
        if (source.equals(this.panel.getBtnRemove())) {
            this.removeProperties();
        }
    }

    protected void initPropertyNameCbx() {
        ArrayList lstName = new ArrayList(8);
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel(new Vector(lstName));
        this.panel.getComboName().setModel(comboModel);
        this.panel.getComboName().getEditor().setItem("");
    }

    protected String getPropertyValue() {
        return this.panel.getTxtAreaValue().getText();
    }

    protected String getPropertyName() {
        Object selectedItem = this.panel.getComboName().getSelectedObjects()[0];
        if (selectedItem == null) {
            return this.panel.getComboName().getEditor().getItem().toString().trim();
        }
        return selectedItem.toString().trim();
    }

    protected void refreshProperties() {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        try {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    Properties props = HgModuleConfig.getDefault().getProperties(HgExtProperties.this.root, "extensions");
                    final HgPropertiesNode[] hgProps = new HgPropertiesNode[props.size()];
                    int i = 0;
                    Enumeration<?> e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        String tmp = props.getProperty(name);
                        String value = tmp != null ? tmp : "";
                        hgProps[i] = new HgPropertiesNode(name, value);
                        ++i;
                    }
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.HgExtProperties.this.propTable.setNodes(hgProps);
                            this.this$1.HgExtProperties.this.setSelected(0);
                            this.this$1.HgExtProperties.this.propTable.getTable().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    });
                }
            };
            this.support.start(rp, (HgURL)null, NbBundle.getMessage(HgExtProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    private boolean addProperty(String name, String value) {
        HgPropertiesNode[] hgPropertiesNodes = this.propTable.getNodes();
        for (int i = 0; i < hgPropertiesNodes.length; ++i) {
            String hgPropertyName = hgPropertiesNodes[this.propTable.getModelIndex(i)].getName();
            if (!hgPropertyName.equals(name)) continue;
            hgPropertiesNodes[this.propTable.getModelIndex(i)].setValue(value);
            this.propTable.setNodes(hgPropertiesNodes);
            return true;
        }
        HgPropertiesNode[] hgProps = new HgPropertiesNode[hgPropertiesNodes.length + 1];
        for (int i = 0; i < hgPropertiesNodes.length; ++i) {
            hgProps[i] = hgPropertiesNodes[i];
        }
        hgProps[hgPropertiesNodes.length] = new HgPropertiesNode(name, value);
        this.propTable.setNodes(hgProps);
        return true;
    }

    public void addProperty() {
        if (this.addProperty(this.getPropertyName(), this.getPropertyValue())) {
            this.panel.getComboName().getEditor().setItem("");
            this.panel.getTxtAreaValue().setText("");
        }
    }

    public void setProperties() {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor();
        try {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        HgModuleConfig.getDefault().clearProperties(HgExtProperties.this.root, "extensions");
                        HgPropertiesNode[] hgPropertiesNodes = HgExtProperties.this.propTable.getNodes();
                        for (int i = 0; i < hgPropertiesNodes.length; ++i) {
                            String hgPropertyName = hgPropertiesNodes[HgExtProperties.this.propTable.getModelIndex(i)].getName();
                            String hgPropertyValue = hgPropertiesNodes[HgExtProperties.this.propTable.getModelIndex(i)].getValue();
                            HgModuleConfig.getDefault().setProperty(HgExtProperties.this.root, "extensions", hgPropertyName, hgPropertyValue, true);
                        }
                    }
                    catch (IOException ex) {
                        HgModuleConfig.notifyParsingError();
                    }
                }
            };
            this.support.start(rp, (HgURL)null, NbBundle.getMessage(HgExtProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    public void removeProperties() {
        int[] rows = this.propTable.getSelectedItems();
        if (rows.length == 0) {
            return;
        }
        HgPropertiesNode[] hgPropertiesNodes = this.propTable.getNodes();
        if (hgPropertiesNodes.length == 0) {
            return;
        }
        HgPropertiesNode[] hgProps = new HgPropertiesNode[hgPropertiesNodes.length - rows.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.propTable.getModelIndex(rows[i]);
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < hgPropertiesNodes.length; ++i) {
            if (i != rows[j]) {
                hgProps[k++] = hgPropertiesNodes[i];
                continue;
            }
            if (j >= rows.length - 1) continue;
            ++j;
        }
        this.propTable.setNodes(hgProps);
        this.panel.getComboName().getEditor().setItem("");
        this.panel.getTxtAreaValue().setText("");
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.validateUserInput(event);
    }

    private void validateUserInput(DocumentEvent event) {
        Document doc = event.getDocument();
        String name = this.panel.getComboName().getEditor().getItem().toString().trim();
        String value = this.panel.getTxtAreaValue().getText().trim();
        if (name.length() == 0 || name.indexOf(" ") > 0) {
            this.panel.getBtnAdd().setEnabled(false);
        } else {
            this.panel.getBtnAdd().setEnabled(true);
        }
    }

    private void setSelected(int index) {
        HgPropertiesNode[] hgPropertiesNodes = this.propTable.getNodes();
        if (hgPropertiesNodes == null || hgPropertiesNodes.length == 0 || index < 0) {
            return;
        }
        final String hgPropertyName = hgPropertiesNodes[this.propTable.getModelIndex(index)].getName();
        final String hgPropertyValue = hgPropertiesNodes[this.propTable.getModelIndex(index)].getValue();
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ HgExtProperties this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                LinkedHashSet<String> initialSet = new LinkedHashSet<String>();
                initialSet.add(hgPropertyName);
                DefaultComboBoxModel targetsModel = new DefaultComboBoxModel(new Vector(initialSet));
                this.this$0.panel.getComboName().setModel(targetsModel);
                this.this$0.panel.getTxtAreaValue().setText(hgPropertyValue);
            }
        });
    }

    public class TableMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent event) {
            int[] rows;
            if (event.getClickCount() == 1 && (rows = HgExtProperties.this.propTable.getSelectedItems()) != null && rows.length > 0) {
                HgExtProperties.this.setSelected(rows[0]);
            }
        }
    }
}

