/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.LinkLabel;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TaskNotificationPanel
extends JPanel {
    private final List<IssueImpl> tasks;
    private final Action openAction;
    private final int ROWS_COUNT = 4;
    private JButton btnAction;
    private JPanel jPanel1;
    private JPanel pnlTasks;

    public TaskNotificationPanel(List<IssueImpl> tasks, Action openAction) {
        this.tasks = tasks;
        this.openAction = openAction;
        this.initComponents();
        this.initTasks();
    }

    private void initTasks() {
        IssueImpl task;
        for (int i = 0; i < 4 && (task = this.getTask(i)) != null; ++i) {
            LinkLabel lbl = new LinkLabel(this, DashboardUtils.getTaskDisplayName(task), ImageUtilities.image2Icon((Image)task.getPriorityIcon())){
                final /* synthetic */ TaskNotificationPanel this$0;
                {
                    this.this$0 = this$0;
                    super(text, icon);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    task.open();
                }
            };
            GridBagConstraints gbc = new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0);
            this.pnlTasks.add((Component)lbl, gbc);
        }
        int overflow = this.tasks.size() - 4;
        if (overflow > 0) {
            JLabel lblOthers = new JLabel(NbBundle.getMessage(TaskNotificationPanel.class, (String)"LBL_Others", (Object)overflow));
            GridBagConstraints gbc = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0);
            this.pnlTasks.add((Component)lblOthers, gbc);
        }
    }

    private IssueImpl getTask(int index) {
        if (index < this.tasks.size()) {
            return this.tasks.get(index);
        }
        return null;
    }

    private void initComponents() {
        this.pnlTasks = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnAction = new LinkButton(NbBundle.getMessage(TaskNotificationPanel.class, (String)"LBL_OpenAction"), this.openAction);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.pnlTasks.setOpaque(false);
        this.pnlTasks.setLayout(new GridBagLayout());
        this.add((Component)this.pnlTasks, "Center");
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.btnAction)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.btnAction)));
        this.add((Component)this.jPanel1, "Last");
    }
}

