/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.ServerType;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.jaxws._RetoucheUtil;
import org.netbeans.modules.maven.jaxws.actions.AddOperationAction;
import org.netbeans.modules.maven.jaxws.actions.WSEditAttributesAction;
import org.netbeans.modules.maven.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.maven.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesCookieImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsNode
extends AbstractNode
implements ConfigureHandlerCookie {
    JaxWsService service;
    FileObject srcRoot;
    private FileObject implBeanClass;
    InstanceContent content;
    Project project;
    private static final Logger LOG = Logger.getLogger(JaxWsNode.class.getCanonicalName());
    private static final String WAITING_BADGE = "org/netbeans/modules/maven/jaxws/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/maven/jaxws/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/maven/jaxws/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsNode(JaxWsService service, FileObject srcRoot, FileObject implBeanClass) {
        this(service, srcRoot, implBeanClass, new InstanceContent());
    }

    private JaxWsNode(JaxWsService service, FileObject srcRoot, FileObject implBeanClass, InstanceContent content) {
        super((Children)new JaxWsChildren(service, srcRoot, implBeanClass), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.service = service;
        this.srcRoot = srcRoot;
        this.content = content;
        this.implBeanClass = implBeanClass;
        this.project = FileOwnerQuery.getOwner((FileObject)srcRoot);
        if (service.isServiceProvider() && implBeanClass.getAttribute("jax-ws-service") == null) {
            try {
                implBeanClass.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        EditorCookie cookie = (EditorCookie)JaxWsNode.this.getDataObject().getCookie(EditorCookie.class);
                        JEditorPane[] panes = cookie.getOpenedPanes();
                        JaxWsNode.this.getDataObject().setValid(false);
                        if (panes != null && panes.length > 0) {
                            ((EditorCookie)JaxWsNode.this.getDataObject().getCookie(EditorCookie.class)).open();
                        }
                    }
                    catch (PropertyVetoException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        String serviceName = service.getServiceName();
        this.setName(serviceName);
        content.add((Object)this);
        content.add((Object)service);
        content.add((Object)implBeanClass);
        OpenCookie cookie = new OpenCookie(){

            public void open() {
                OpenCookie oc = JaxWsNode.this.getOpenCookie();
                if (oc != null) {
                    oc.open();
                }
            }
        };
        content.add((Object)cookie);
        this.setServiceUrl();
        content.add((Object)new EditWSAttributesCookieImpl((Node)this));
        this.attachFileChangeListener();
    }

    private boolean isWebProject() {
        J2eeModule.Type moduleType;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return provider != null && J2eeModule.Type.WAR.equals(moduleType = provider.getJ2eeModule().getType());
    }

    public String getDisplayName() {
        return this.service.getServiceName();
    }

    public Image getIcon(int type) {
        return this.getServiceImage();
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private DataObject getDataObject() {
        FileObject f = this.getImplBean();
        if (f != null) {
            try {
                return DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException de) {
                LOG.log(Level.INFO, null, de);
            }
        }
        return null;
    }

    private OpenCookie getOpenCookie() {
        OpenCookie oc = null;
        FileObject f = this.getImplBean();
        if (f != null) {
            try {
                DataObject d = DataObject.find((FileObject)f);
                oc = (OpenCookie)d.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException de) {
                LOG.log(Level.INFO, null, de);
            }
        }
        return oc;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        ArrayList<CallableSystemAction> actions = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(AddOperationAction.class), null, (CallableSystemAction)SystemAction.get(WsTesterPageAction.class), (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(actions, "WebServices/Services/Actions");
        return actions.toArray(new Action[0]);
    }

    private void addFromLayers(List<Action> actions, String path) {
        Lookup look = Lookups.forPath((String)path);
        for (Object next : look.lookupAll(Object.class)) {
            if (next instanceof Action) {
                actions.add((Action)next);
                continue;
            }
            if (!(next instanceof JSeparator)) continue;
            actions.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    private String getWebServiceURL() {
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        String contextRoot = serverContextInfo.getContextRoot();
        return "http://" + serverContextInfo.getHost() + ":" + serverContextInfo.getPort() + "/" + this.getServiceUri(contextRoot);
    }

    private String getNameFromPackageName(String packageName) {
        int index = packageName.lastIndexOf(".");
        return index >= 0 ? packageName.substring(index + 1) : packageName;
    }

    public String getWsdlURL() {
        String wsdlUrl = this.getWebServiceURL();
        return wsdlUrl.length() == 0 ? "" : wsdlUrl + "?wsdl";
    }

    public String getTesterPageURL() {
        JaxWs.UriDescriptor uriDescriptor;
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        ServiceInfo serviceInfo = this.getServiceInfo();
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        WSStack<JaxWs> jaxWsStack = stackUtils.getWsStack(JaxWs.class);
        if (jaxWsStack != null && (uriDescriptor = ((JaxWs)jaxWsStack.get()).getWsUriDescriptor()) != null) {
            return uriDescriptor.getTesterPageUri(serverContextInfo.getHost(), serverContextInfo.getPort(), serverContextInfo.getContextRoot(), serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
        }
        return this.getWebServiceURL();
    }

    public void destroy() throws IOException {
        if (this.service.getLocalWsdl() != null) {
            final String serviceId = this.service.getId();
            ModelOperation<POMModel> oper = new ModelOperation<POMModel>(){
                final /* synthetic */ JaxWsNode this$0;
                {
                    this.this$0 = this$0;
                }

                public void performOperation(POMModel model) {
                    MavenModelUtils.removeWsimportExecution(model, serviceId);
                }
            };
            FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
            Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(oper));
            try {
                this.removeStaleFile(serviceId);
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", ex);
            }
            FileObject wsdlFileObject = this.getLocalWsdl();
            JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
            if (wsdlFileObject != null && jaxWsSupport != null) {
                boolean hasOtherServices = false;
                List services = jaxWsSupport.getServices();
                for (JaxWsService s : services) {
                    if (serviceId == null || serviceId.equals(s.getId()) || !this.service.getLocalWsdl().equals(s.getLocalWsdl())) continue;
                    hasOtherServices = true;
                    break;
                }
                if (!hasOtherServices) {
                    wsdlFileObject.delete();
                }
            }
        }
        WSUtils.removeImplClass(this.project, this.service.getImplementationClass());
    }

    private FileObject getImplBean() {
        String implBean = this.service.getImplementationClass();
        if (implBean != null) {
            return this.srcRoot.getFileObject(implBean.replace('.', '/') + ".java");
        }
        return null;
    }

    private FileObject getLocalWsdl() {
        String relativePath;
        FileObject localWsdlocalFolder;
        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.implBeanClass);
        if (jaxWsSupport != null && (localWsdlocalFolder = jaxWsSupport.getWsdlFolder(false)) != null && (relativePath = this.service.getLocalWsdl()) != null) {
            return localWsdlocalFolder.getFileObject(relativePath);
        }
        return null;
    }

    private JavaSource getImplBeanJavaSource() {
        FileObject implBean = this.getImplBean();
        if (implBean != null) {
            return JavaSource.forFileObject((FileObject)implBean);
        }
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    private String getPortNumber(InstanceProperties instanceProperties) {
        String portNumber = instanceProperties.getProperty("httpportnumber");
        if (portNumber == null || portNumber.equals("")) {
            return "8080";
        }
        return portNumber;
    }

    private String getHostName(InstanceProperties instanceProperties) {
        String serverUrl = instanceProperties.getProperty("url");
        String hostName = "localhost";
        if (serverUrl != null && serverUrl.indexOf("::") > 0) {
            int index1 = serverUrl.indexOf("::");
            int index2 = serverUrl.lastIndexOf(":");
            if (index2 > index1 + 2) {
                hostName = serverUrl.substring(index1 + 2, index2);
            }
        }
        return hostName;
    }

    void setServiceUrl() {
        new RequestProcessor(JaxWsNode.class).post(new Runnable(){

            @Override
            public void run() {
                JaxWsNode.this.setValue("wsdl-url", JaxWsNode.this.getWsdlURL());
                JaxWsNode.this.fireShortDescriptionChange();
            }
        });
    }

    protected void fireShortDescriptionChange() {
        this.setShortDescription(this.getWsdlURL());
    }

    private void attachFileChangeListener() {
        this.implBeanClass.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileChanged(final FileEvent fe) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        String oldServiceName = this.this$1.JaxWsNode.this.service.getServiceName();
                        final String[] newServiceName = new String[1];
                        JavaSource javaSource = JavaSource.forFileObject((FileObject)fe.getFile());
                        if (javaSource != null) {
                            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void run(CompilationController controller) throws IOException {
                                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                                    if (typeElement != null) {
                                        newServiceName[0] = this.this$2.this$1.JaxWsNode.this.getServiceName(controller, typeElement);
                                    }
                                }

                                public void cancel() {
                                }
                            };
                            try {
                                javaSource.runUserActionTask((Task)task, true);
                            }
                            catch (IOException ex) {
                                LOG.log(Level.WARNING, null, ex);
                            }
                            if (newServiceName[0] == null) {
                                newServiceName[0] = fe.getFile().getName() + "Service";
                            }
                            if (!newServiceName[0].equals(oldServiceName)) {
                                FileObject implBean = this.this$1.JaxWsNode.this.getImplBean();
                                if (this.this$1.JaxWsNode.this.getImplBean() != null) {
                                    this.this$1.JaxWsNode.this.service.setServiceName(newServiceName[0]);
                                    this.this$1.JaxWsNode.this.fireDisplayNameChange(oldServiceName, newServiceName[0]);
                                    this.this$1.JaxWsNode.this.fireNameChange(oldServiceName, newServiceName[0]);
                                    this.this$1.JaxWsNode.this.fireShortDescriptionChange();
                                    if (!WSUtils.isJsr109Supported(this.this$1.JaxWsNode.this.project)) {
                                        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)implBean);
                                        FileObject ddFolder = jaxWsSupport.getDeploymentDescriptorFolder();
                                        if (ddFolder != null) {
                                            try {
                                                WSUtils.replaceSunJaxWsEntries(ddFolder, oldServiceName, newServiceName[0]);
                                            }
                                            catch (IOException ex) {
                                                Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify endpoint in sun-jaxws.xml file", ex);
                                            }
                                        }
                                        try {
                                            WSUtils.replaceServiceEntriesFromDD(this.this$1.JaxWsNode.this.project, oldServiceName, newServiceName[0]);
                                        }
                                        catch (IOException ex) {
                                            Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, "Cannot modify web.xml file", ex);
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private String getServiceName(CompilationController controller, TypeElement classElement) {
        AnnotationMirror anMirror = _RetoucheUtil.getAnnotation(controller, classElement, "javax.jws.WebService");
        if (anMirror == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = anMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("serviceName")) continue;
            return (String)expressions.get(entry.getKey()).getValue();
        }
        return null;
    }

    public void configureHandler() {
        boolean[] isNew;
        HandlerChains handlerChains;
        FileObject handlerFO;
        ArrayList<String> handlerClasses;
        FileObject implBeanFo;
        block10: {
            implBeanFo = this.getImplBean();
            handlerClasses = new ArrayList<String>();
            handlerFO = null;
            handlerChains = null;
            Object[] handlerFileName = new String[1];
            isNew = new boolean[]{true};
            JavaSource implBeanJavaSrc = JavaSource.forFileObject((FileObject)implBeanFo);
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
                final /* synthetic */ String[] val$handlerFileName;
                final /* synthetic */ JaxWsNode this$0;
                {
                    this.val$handlerFileName = stringArray;
                    this.this$0 = this$0;
                }

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    AnnotationMirror handlerAnnotation = _RetoucheUtil.getAnnotation(controller, typeElement, "javax.jws.HandlerChain");
                    if (handlerAnnotation != null) {
                        isNew[0] = false;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = handlerAnnotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            ExecutableElement ex = entry.getKey();
                            AnnotationValue annotation = entry.getValue();
                            if (!ex.getSimpleName().contentEquals("file")) continue;
                            this.val$handlerFileName[0] = (String)annotation.getValue();
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                implBeanJavaSrc.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            if (!isNew[0] && handlerFileName[0] != null) {
                try {
                    FileObject parent = implBeanFo.getParent();
                    File parentFile = FileUtil.toFile((FileObject)parent);
                    File file = new File(parentFile, handlerFileName[0]);
                    if (file.exists()) {
                        file = file.getCanonicalFile();
                        handlerFO = FileUtil.toFileObject((File)file);
                    }
                    if (handlerFO != null) {
                        try {
                            handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(handlerFO);
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, null, e);
                            return;
                        }
                        HandlerChain[] handlerChainArray = handlerChains.getHandlerChains();
                        HandlerChain chain = handlerChainArray[0];
                        Handler[] handlers = chain.getHandlers();
                        for (int i = 0; i < handlers.length; ++i) {
                            handlerClasses.add(handlers[i].getHandlerClass());
                        }
                        break block10;
                    }
                    NotifyDescriptor.Message dialogDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object[])handlerFileName), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(this.project, handlerClasses, true, this.service.getServiceName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new HandlerButtonListener(panel, handlerChains, handlerFO, implBeanFo, this.service, isNew[0]));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
    }

    private void removeStaleFile(String name) throws IOException {
        FileObject staleFile = this.project.getProjectDirectory().getFileObject("target/jaxws/stale/" + name + ".stale");
        if (staleFile != null) {
            staleFile.delete();
        }
    }

    private String getServiceUri(String contextRoot) {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        String wsURI = null;
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        try {
            JaxWs.UriDescriptor uriDescriptor;
            ServiceInfo serviceInfo = new ServiceInfo();
            boolean isEjb = J2eeModule.Type.EJB.equals(moduleType);
            this.resolveServiceInfo(serviceInfo, isEjb);
            boolean fromStack = false;
            WSStack<JaxWs> jaxWsStack = stackUtils.getWsStack(JaxWs.class);
            if (jaxWsStack != null && (uriDescriptor = ((JaxWs)jaxWsStack.get()).getWsUriDescriptor()) != null) {
                fromStack = true;
                wsURI = uriDescriptor.getServiceUri(contextRoot, serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
            }
            if (!fromStack) {
                String portName = serviceInfo.getPortName();
                wsURI = (contextRoot == null ? "" : contextRoot + "/") + serviceInfo.getServiceName() + (portName == null ? "" : "/" + portName);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return wsURI;
    }

    private ServerContextInfo getServerContextInfo() {
        String portNumber = "8080";
        String hostName = "localhost";
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            Logger.getLogger(JaxWsNode.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            ServerInstance.Descriptor instanceDescriptor = null;
            if (serverInstance != null) {
                instanceDescriptor = serverInstance.getDescriptor();
            }
            if (instanceDescriptor != null) {
                int port = instanceDescriptor.getHttpPort();
                portNumber = port == 0 ? "8080" : String.valueOf(port);
                String hstName = instanceDescriptor.getHostname();
                if (hstName != null) {
                    hostName = hstName;
                }
            } else {
                InstanceProperties instanceProperties = provider.getInstanceProperties();
                if (instanceProperties == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
                } else {
                    portNumber = this.getPortNumber(instanceProperties);
                    hostName = this.getHostName(instanceProperties);
                }
            }
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Removed ServerInstance", ex);
        }
        String contextRoot = "";
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            try {
                contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (contextRoot != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        } else if (J2eeModule.Type.EJB.equals(moduleType) && ServerType.JBOSS == stackUtils.getServerType()) {
            contextRoot = this.project.getProjectDirectory().getName();
        }
        if (contextRoot == null) {
            contextRoot = "";
        }
        return new ServerContextInfo(hostName, portNumber, contextRoot);
    }

    private ServiceInfo getServiceInfo() {
        ServiceInfo serviceInfo = new ServiceInfo();
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        boolean isEjb = J2eeModule.Type.EJB.equals(provider.getJ2eeModule().getType());
        try {
            this.resolveServiceInfo(serviceInfo, isEjb);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return serviceInfo;
    }

    private void resolveServiceInfo(final ServiceInfo serviceInfo, final boolean inEjbProject) throws UnsupportedEncodingException {
        final String[] serviceName = new String[1];
        final String[] name = new String[1];
        final boolean[] isProvider = new boolean[]{false};
        serviceInfo.setEjb(inEjbProject);
        JavaSource javaSource = this.getImplBeanJavaSource();
        if (javaSource != null) {
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
                final /* synthetic */ JaxWsNode this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    if (typeElement == null) {
                        return;
                    }
                    boolean foundWsAnnotation = this.this$0.resolveServiceUrl(controller, typeElement, serviceName, name);
                    if (!foundWsAnnotation) {
                        boolean bl = isProvider[0] = _RetoucheUtil.getAnnotation(controller, typeElement, "javax.xml.ws.WebServiceProvider") != null;
                    }
                    if (!inEjbProject) {
                        serviceInfo.setEjb(this.this$0.isStatelessEjb(controller, typeElement));
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        String qualifiedImplClassName = this.service.getImplementationClass();
        String implClassName = this.getNameFromPackageName(qualifiedImplClassName);
        if (serviceName[0] == null) {
            serviceName[0] = URLEncoder.encode(implClassName + "Service", "UTF-8");
        }
        serviceInfo.setServiceName(serviceName[0]);
        if (name[0] == null) {
            name[0] = isProvider[0] ? qualifiedImplClassName : implClassName;
            name[0] = URLEncoder.encode(name[0], "UTF-8");
        }
        serviceInfo.setPortName(name[0]);
    }

    private boolean isStatelessEjb(CompilationController controller, TypeElement targetElement) {
        return _RetoucheUtil.getAnnotation(controller, targetElement, "javax.ejb.Stateless") != null;
    }

    private boolean resolveServiceUrl(CompilationController controller, TypeElement targetElement, String[] serviceName, String[] name) throws IOException {
        boolean foundWsAnnotation = false;
        AnnotationMirror anMirror = _RetoucheUtil.getAnnotation(controller, targetElement, "javax.jws.WebService");
        if (anMirror == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = anMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
            if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                serviceName[0] = (String)expressions.get(entry.getKey()).getValue();
                if (serviceName[0] != null) {
                    serviceName[0] = URLEncoder.encode(serviceName[0], "UTF-8");
                }
            } else if (entry.getKey().getSimpleName().contentEquals("name")) {
                name[0] = (String)expressions.get(entry.getKey()).getValue();
                if (name[0] != null) {
                    name[0] = URLEncoder.encode(name[0], "UTF-8");
                }
            }
            if (serviceName[0] == null || name[0] == null) continue;
            break;
        }
        return true;
    }

    private static class ServerContextInfo {
        private String host;
        private String port;
        private String contextRoot;

        public ServerContextInfo(String host, String port, String contextRoot) {
            this.host = host;
            this.port = port;
            this.contextRoot = contextRoot;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getContextRoot() {
            return this.contextRoot;
        }
    }

    private static class ServiceInfo {
        private String serviceName;
        private String portName;
        private boolean ejb;

        private ServiceInfo() {
        }

        public void setEjb(boolean ejb) {
            this.ejb = ejb;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public boolean isEjb() {
            return this.ejb;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

